/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.IrpMaster;

import java.util.ArrayList;
import org.harctoolbox.IrpMaster.BitDirection;
import org.harctoolbox.IrpMaster.BitField;
import org.harctoolbox.IrpMaster.BitSpec;
import org.harctoolbox.IrpMaster.Debug;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.IrpMaster.PrimaryIrStream;
import org.harctoolbox.IrpMaster.PrimitiveIrStreamItem;
import org.harctoolbox.IrpMaster.Protocol;
import org.harctoolbox.IrpMaster.UnassignedException;

public class BitStream
extends PrimitiveIrStreamItem {
    private int length;
    private long[] data = new long[1];

    public String toString() {
        if (this.data.length == 1) {
            return "BitStream, length = " + this.length + ", data = " + this.data[0] + " = " + Long.toBinaryString(this.data[0]);
        }
        StringBuilder dataString = new StringBuilder();
        dataString.append("[ ");
        StringBuilder binString = new StringBuilder();
        for (int i = this.data.length - 1; i >= 0; --i) {
            dataString.append(Long.toString(this.data[i])).append(" ");
            binString.append(Long.toBinaryString(this.data[i])).append(" ");
        }
        return "BitStream, length = " + this.length + ", data = " + dataString + "] = " + binString;
    }

    public BitStream(Protocol env) {
        super(env);
        this.data[0] = 0L;
        this.length = 0;
    }

    public void add(BitField bitField) throws IncompatibleArgumentException {
        this.add(bitField, this.environment.getBitDirection());
    }

    public void add(BitField bitField, BitDirection bitDirection) throws IncompatibleArgumentException {
        if (bitField.isInfinite()) {
            throw new IncompatibleArgumentException("Infinite bitfields cannot be converted to bitstreams.");
        }
        long newData = this.environment.getBitDirection() == BitDirection.msb ? bitField.toLong() : IrpUtils.reverse(bitField.toLong(), bitField.getWidth());
        this.length += bitField.getWidth();
        if (this.length > 64) {
            if (this.longsNeeded(this.length) > this.data.length) {
                long[] newdata = new long[this.data.length + 1];
                System.arraycopy(this.data, 0, newdata, 0, this.data.length);
                newdata[this.data.length] = 0L;
                this.data = newdata;
            }
            for (int i = this.data.length - 1; i > 0; --i) {
                long x;
                this.data[i] = x = this.data[i] << bitField.getWidth() | this.getLeftmostBits(this.data[i - 1], bitField.getWidth());
            }
        }
        this.data[0] = this.data[0] << bitField.getWidth() | newData;
    }

    private long getLeftmostBits(long x, int n) {
        return x >> 64 - n & (1L << n) - 1L;
    }

    private int longsNeeded(int n) {
        return n / 64 + (n % 64 == 0 ? 0 : 1);
    }

    private int getChunkNo(int n, int chunksize) {
        if (n < 0 || this.length > 0 && (n + 1) * chunksize - 1 >= this.length) {
            throw new IndexOutOfBoundsException("Illegal bit " + n + " in getChunkNo");
        }
        if (((n + 1) * chunksize - 1) / 64 != n * chunksize / 64) {
            throw new RuntimeException("Case not implemented");
        }
        int chunk = (int)(this.data[n * chunksize / 64] >> n * chunksize) & (1 << chunksize) - 1;
        return chunk;
    }

    @Override
    public ArrayList<PrimitiveIrStreamItem> evaluate(BitSpec bitSpec) throws UnassignedException, IncompatibleArgumentException {
        this.debugBegin();
        if (bitSpec == null) {
            throw new UnassignedException("BitStream " + this.toString() + " has no associated BitSpec, cannot compute IRStream");
        }
        ArrayList<PrimitiveIrStreamItem> list = new ArrayList<PrimitiveIrStreamItem>();
        if (this.length % bitSpec.getChunkSize() != 0) {
            throw new IncompatibleArgumentException("chunksize (= " + bitSpec.getChunkSize() + ") does not divide bitstream length (= " + this.length + ").");
        }
        int noChunks = this.length / bitSpec.getChunkSize();
        for (int n = 0; n < noChunks; ++n) {
            int chunkNo = noChunks - n - 1;
            PrimaryIrStream irs = bitSpec.getBitIrsteam(this.getChunkNo(chunkNo, bitSpec.getChunkSize()));
            ArrayList<PrimitiveIrStreamItem> items = irs.evaluate(null);
            list.addAll(items);
        }
        Debug.debugBitStream(this.toString());
        this.debugEnd(list);
        return list;
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }
}

