/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.IrpMaster;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.IrSequence;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.IrpMaster.ModulatedIrSequence;

public class Cleaner {
    private int[] rawData;
    private List<Integer> dumbTimingsTable;
    private List<Integer> timingsTable;
    private HashMap<Integer, Integer> histogram;
    private int[] cookedData;
    private int[] sorted;
    private HashMap<Integer, Integer> lookDownTable;

    private Cleaner(IrSequence irSequence, int absoluteTolerance, double relativeTolerance) {
        this.rawData = irSequence.toInts();
        this.createHistogram();
        this.createDumbTimingsTable(absoluteTolerance, relativeTolerance);
        this.improveTimingsTable(absoluteTolerance, relativeTolerance);
        this.createCookedData();
    }

    private Cleaner() {
    }

    private void createHistogram() {
        this.histogram = new HashMap();
        for (int d : this.rawData) {
            int old = this.histogram.containsKey(d) ? this.histogram.get(d) : 0;
            this.histogram.put(d, old + 1);
        }
    }

    private void createDumbTimingsTable(int absoluteTolerance, double relativeTolerance) {
        this.dumbTimingsTable = new ArrayList<Integer>();
        this.sorted = (int[])this.rawData.clone();
        Arrays.sort(this.sorted);
        int last = Integer.MIN_VALUE;
        for (int d : this.sorted) {
            if (IrpUtils.isEqual(d, last, absoluteTolerance, relativeTolerance)) continue;
            this.dumbTimingsTable.add(d);
            last = d;
        }
    }

    private void improveTimingsTable(int absoluteTolerance, double relativeTolerance) {
        this.lookDownTable = new HashMap();
        this.timingsTable = new ArrayList<Integer>();
        int indexInSortedTimings = 0;
        for (int timingsIndex = 0; timingsIndex < this.dumbTimingsTable.size(); ++timingsIndex) {
            int dumbTiming = this.dumbTimingsTable.get(timingsIndex);
            int sum = 0;
            int terms = 0;
            int lastDuration = -1;
            while (indexInSortedTimings < this.sorted.length && IrpUtils.isEqual(dumbTiming, this.sorted[indexInSortedTimings], absoluteTolerance, relativeTolerance)) {
                int duration;
                if ((duration = this.sorted[indexInSortedTimings++]) == lastDuration) continue;
                lastDuration = duration;
                int noHits = this.histogram.get(duration);
                sum += noHits * duration;
                terms += noHits;
                this.lookDownTable.put(duration, timingsIndex);
            }
            int average = (int)Math.round((double)sum / (double)terms);
            this.timingsTable.add(average);
        }
    }

    private void createCookedData() {
        this.cookedData = new int[this.rawData.length];
        for (int i = 0; i < this.rawData.length; ++i) {
            this.cookedData[i] = this.lookDownTable.get(this.rawData[i]);
        }
    }

    private int[] toDurations() {
        int[] data = new int[this.rawData.length];
        for (int i = 0; i < this.rawData.length; ++i) {
            data[i] = this.timingsTable.get(this.cookedData[i]);
        }
        return data;
    }

    private IrSequence toIrSequence() {
        try {
            return new IrSequence(this.toDurations());
        }
        catch (IncompatibleArgumentException ex) {
            throw new InternalError();
        }
    }

    public static IrSequence clean(IrSequence irSequence, int absoluteTolerance, double relativeTolerance) {
        Cleaner cleaner = new Cleaner(irSequence, absoluteTolerance, relativeTolerance);
        return cleaner.toIrSequence();
    }

    public static ModulatedIrSequence clean(ModulatedIrSequence irSequence, int absoluteTolerance, double relativeTolerance) {
        Cleaner cleaner = new Cleaner(irSequence, absoluteTolerance, relativeTolerance);
        return new ModulatedIrSequence(cleaner.toIrSequence(), irSequence.getFrequency(), irSequence.getDutyCycle());
    }
}

