/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.IrpMaster;

import org.harctoolbox.IrpMaster.UserComm;

public class Debug {
    private int debug = 0;
    private UserComm userComm;
    private static Debug instance = new Debug(0);

    public static Debug getInstance() {
        return instance;
    }

    public static String helpString() {
        return Debug.helpString(",");
    }

    public static String helpString(String separator) {
        return Item.helpString(separator);
    }

    public static void setDebug(int d) {
        Debug.instance.debug = d;
    }

    public static int getDebug() {
        return Debug.instance.debug;
    }

    public Debug(int debug) {
        this(debug, new UserComm());
    }

    public Debug(int debug, UserComm userComm) {
        this.debug = debug;
        this.userComm = userComm;
    }

    public void debugMsg(Item type, String msg) {
        if (this.debugOn(type)) {
            this.userComm.debugMsg(type.name(), msg);
        }
    }

    public void debugMsg(String msg) {
        this.userComm.debugMsg("", msg);
    }

    public boolean debugOn(Item type) {
        return (Item.power(type) & this.debug) != 0;
    }

    public String toString() {
        return this.toString(",");
    }

    public String toString(String separator) {
        StringBuilder result = new StringBuilder();
        for (Item it : Item.values()) {
            if (!this.debugOn(it)) continue;
            result.append((Object)it).append(separator);
        }
        return "[" + (result.length() == 0 ? "" : result.substring(0, result.length() - separator.length())) + "]";
    }

    public static void debugMain(String msg) {
        instance.debugMsg(Item.Main, msg);
    }

    public static void debugConfigfile(String msg) {
        instance.debugMsg(Item.Configfile, msg);
    }

    public static void debugIrpParser(String msg) {
        instance.debugMsg(Item.IrpParser, msg);
    }

    public static void debugASTParser(String msg) {
        instance.debugMsg(Item.ASTParser, msg);
    }

    public static void debugNameEngine(String msg) {
        instance.debugMsg(Item.NameEngine, msg);
    }

    public static void debugBitFields(String msg) {
        instance.debugMsg(Item.BitFields, msg);
    }

    public static void debugParameters(String msg) {
        instance.debugMsg(Item.Parameters, msg);
    }

    public static void debugExpressions(String msg) {
        instance.debugMsg(Item.Expressions, msg);
    }

    public static void debugIrSignals(String msg) {
        instance.debugMsg(Item.IrSignals, msg);
    }

    public static void debugIrStreamItems(String msg) {
        instance.debugMsg(Item.IrStreamItems, msg);
    }

    public static void debugBitSpec(String msg) {
        instance.debugMsg(Item.BitSpec, msg);
    }

    public static void debugDecodeIR(String msg) {
        instance.debugMsg(Item.DecodeIR, msg);
    }

    public static void debugIrStreams(String msg) {
        instance.debugMsg(Item.IrStreams, msg);
    }

    public static void debugBitStream(String msg) {
        instance.debugMsg(Item.BitStream, msg);
    }

    public static void debugEvaluate(String msg) {
        instance.debugMsg(Item.Evaluate, msg);
    }

    public static void main(String[] args) {
        System.out.println(Item.helpString("\n"));
        if (args.length > 0) {
            Debug debug = new Debug(Integer.parseInt(args[0]));
            System.out.println(debug);
        }
    }

    public static enum Item {
        Main,
        Configfile,
        IrpParser,
        ASTParser,
        NameEngine,
        BitFields,
        Parameters,
        Expressions,
        IrSignals,
        IrStreamItems,
        BitSpec,
        DecodeIR,
        IrStreams,
        BitStream,
        Evaluate;


        public static int power(Item it) {
            return 1 << it.ordinal();
        }

        public static String helpString(String separator) {
            StringBuilder result = new StringBuilder();
            for (Item it : Item.values()) {
                result.append((Object)it).append("=").append(Item.power(it)).append(separator);
            }
            return result.substring(0, result.length() - separator.length());
        }

        public static String helpString() {
            return Item.helpString(",");
        }

        public static String helpString(int index) {
            return Item.values()[index].name();
        }

        public static int size() {
            return Item.values().length;
        }
    }
}

