/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.IrpMaster;

import com.hifiremote.decodeir.DecodeIRCaller;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.harctoolbox.IrpMaster.Debug;
import org.harctoolbox.IrpMaster.DomainViolationException;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.InterpretString;
import org.harctoolbox.IrpMaster.InvalidRepeatException;
import org.harctoolbox.IrpMaster.IrSequence;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.IrpMaster.ModulatedIrSequence;
import org.harctoolbox.IrpMaster.ParseException;
import org.harctoolbox.IrpMaster.Pronto;
import org.harctoolbox.IrpMaster.Protocol;
import org.harctoolbox.IrpMaster.UnassignedException;
import org.harctoolbox.IrpMaster.UserComm;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DecodeIR {
    public static final String appName = "DecodeIR";
    private static final String libraryName = "DecodeIR";
    private static final String libraryPathProperty = "harctoolbox.decodeir.library.path";
    private static boolean libIsLoaded = false;
    private boolean valid = false;
    private static String version = null;
    private DecodeIRCaller dirc;
    private DecodedSignal[] decodedSignals;

    public static DecodeIR newDecodeIR(int[] data, int lengthRepeat, int lengthEnding, int frequency) {
        DecodeIR decoder = new DecodeIR(data, lengthRepeat, lengthEnding, frequency);
        return decoder.valid ? decoder : null;
    }

    public static DecodeIR newDecodeIR(IrSignal irSignal) {
        DecodeIR decoder = new DecodeIR(irSignal);
        return decoder.valid ? decoder : null;
    }

    public static DecodeIR newDecodeIR(int[] CCF2) throws IrpMasterException {
        DecodeIR decoder = new DecodeIR(CCF2);
        return decoder.valid ? decoder : null;
    }

    public static DecodeIR create(IrSequence irSequence, double frequency) {
        ModulatedIrSequence modulatedIrSequence = new ModulatedIrSequence(irSequence, frequency, -1.0);
        DecodeIR decoder = new DecodeIR(modulatedIrSequence);
        return decoder.valid ? decoder : null;
    }

    public static DecodeIR newDecodeIR(ModulatedIrSequence irSequence) {
        DecodeIR decoder = new DecodeIR(irSequence);
        return decoder.valid ? decoder : null;
    }

    public static DecodeIR newDecodeIR(String ccf) throws ParseException, IncompatibleArgumentException, UnassignedException, DomainViolationException, InvalidRepeatException {
        DecodeIR decoder = new DecodeIR(ccf);
        return decoder.valid ? decoder : null;
    }

    public static boolean loadLibrary() {
        boolean success;
        if (libIsLoaded) {
            return true;
        }
        String userSpecifiedPath = System.getProperty(libraryPathProperty);
        boolean bl = userSpecifiedPath == null ? DecodeIR.localLoadLibrary() || DecodeIR.systemLoadLibrary() : (success = DecodeIR.loadAbsoluteLibrary(userSpecifiedPath));
        if (success) {
            version = new DecodeIRCaller().getVersion();
        }
        return success;
    }

    private static boolean loadAbsoluteLibrary(String path) {
        String absolutePath = new File(path).getAbsolutePath();
        try {
            System.load(absolutePath);
            Debug.debugDecodeIR("Loaded file " + absolutePath);
            libIsLoaded = true;
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            Debug.debugDecodeIR("Loading of file " + absolutePath + " failed");
            return false;
        }
    }

    private static boolean localLoadLibrary() {
        String folderName = (System.getProperty("os.name").startsWith("Windows") ? "Windows" : System.getProperty("os.name")) + '-' + System.getProperty("os.arch").toLowerCase(Locale.US);
        String mappedName = System.mapLibraryName("DecodeIR");
        String libraryFile = folderName + File.separator + mappedName;
        if (System.getProperty("harctoolbox.jniLibsHome") != null) {
            libraryFile = System.getProperty("harctoolbox.jniLibsHome") + File.separator + libraryFile;
        }
        if (DecodeIR.loadAbsoluteLibrary(libraryFile)) {
            return true;
        }
        if (System.getProperty("os.name").startsWith("Mac")) {
            mappedName = System.mapLibraryName("DecodeIR").replaceFirst("\\.dylib", ".jnilib");
            libraryFile = folderName + File.separator + mappedName;
            return DecodeIR.loadAbsoluteLibrary(libraryFile);
        }
        return false;
    }

    private static boolean systemLoadLibrary() {
        try {
            System.loadLibrary("DecodeIR");
            libIsLoaded = true;
            Debug.debugDecodeIR("Loading of DecodeIR from system path succeeded.");
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            Debug.debugDecodeIR("Loading of DecodeIR from system path failed.");
            return false;
        }
    }

    public static String getVersion() {
        DecodeIR.loadLibrary();
        return version;
    }

    private boolean setup(int[] us_data, int lengthRepeat, int lengthEnding, int frequency) {
        boolean success = DecodeIR.loadLibrary();
        if (!success) {
            return false;
        }
        this.valid = true;
        this.dirc = new DecodeIRCaller();
        this.dirc.setBursts(us_data, lengthRepeat, lengthEnding);
        this.dirc.setFrequency(frequency);
        this.dirc.initDecoder();
        Debug.debugDecodeIR("DecodeIR was setup with f=" + frequency + ", repeat=" + lengthRepeat + ", ending=" + lengthEnding + ", data=" + IrpUtils.stringArray(us_data));
        ArrayList<DecodedSignal> work = new ArrayList<DecodedSignal>();
        while (this.dirc.decode()) {
            DecodedSignal decodedSignal = new DecodedSignal(this.dirc.getProtocolName(), this.dirc.getDevice(), this.dirc.getSubDevice(), this.dirc.getOBC(), this.dirc.getHex(), this.dirc.getMiscMessage(), this.dirc.getErrorMessage());
            work.add(decodedSignal);
        }
        this.decodedSignals = work.toArray(new DecodedSignal[work.size()]);
        return true;
    }

    private boolean setup(IrSignal irSignal) {
        return this.setup(irSignal.toIntArray(), irSignal.getRepeatLength(), irSignal.getEndingLength(), (int)Math.round(irSignal.getFrequency()));
    }

    private DecodeIR(int[] data, int lengthRepeat, int lengthEnding, int frequency) {
        this.setup(data, lengthRepeat, lengthEnding, frequency);
    }

    private DecodeIR(IrSignal irSignal) {
        this.setup(irSignal);
    }

    private DecodeIR(int[] CCF2) throws IrpMasterException {
        this(Pronto.ccfSignal(CCF2));
    }

    private DecodeIR(ModulatedIrSequence irSequence) {
        this(InterpretString.interpretIrSequence(irSequence, true, true));
    }

    private DecodeIR(String ccf) throws ParseException, IncompatibleArgumentException, UnassignedException, DomainViolationException, InvalidRepeatException {
        IrSignal irSignal = InterpretString.interpretString(ccf, 38000.0, false, true);
        if (irSignal == null) {
            throw new ParseException("Could not interpret string `" + ccf + "'");
        }
        this.setup(irSignal);
    }

    private static int[] parseRawString(String s) throws NumberFormatException {
        String[] work = s.split("\\s+");
        int[] result = new int[work.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Math.abs(Integer.parseInt(work[i].replaceFirst("\\+", "")));
        }
        return result;
    }

    public DecodedSignal[] getDecodedSignals() {
        return this.valid ? this.decodedSignals : null;
    }

    public static DecodedSignal[] decode(int[] data, int lengthRepeat, int lengthEnding, int frequency) {
        DecodeIR decoder = DecodeIR.newDecodeIR(data, lengthRepeat, lengthEnding, frequency);
        return decoder != null ? decoder.getDecodedSignals() : null;
    }

    public static DecodedSignal[] decode(IrSignal irSignal) {
        DecodeIR decoder = DecodeIR.newDecodeIR(irSignal);
        return decoder != null ? decoder.getDecodedSignals() : null;
    }

    public static DecodedSignal[] decode(String ccf) throws IncompatibleArgumentException, ParseException, UnassignedException, DomainViolationException, InvalidRepeatException {
        DecodeIR decoder = DecodeIR.newDecodeIR(ccf);
        return decoder != null ? decoder.getDecodedSignals() : null;
    }

    public static DecodedSignal[] decode(int[] CCF2) throws IrpMasterException {
        DecodeIR decoder = DecodeIR.newDecodeIR(CCF2);
        return decoder != null ? decoder.getDecodedSignals() : null;
    }

    public static DecodedSignal[] decode(IrSequence irSequence, double frequency) {
        DecodeIR decoder = DecodeIR.create(irSequence, frequency);
        return decoder != null ? decoder.getDecodedSignals() : null;
    }

    public static DecodedSignal[] decode(ModulatedIrSequence irSequence) {
        DecodeIR decoder = DecodeIR.newDecodeIR(irSequence);
        return decoder != null ? decoder.getDecodedSignals() : null;
    }

    public static void invoke(ModulatedIrSequence seq) {
        DecodeIR.invoke(InterpretString.interpretIrSequence(seq, true, true));
    }

    public static void invoke(IrSignal irSignal) {
        DecodeIR.invoke(irSignal, System.out);
    }

    public static void invoke(IrSignal irSignal, PrintStream out) {
        DecodeIR.invoke(irSignal, null, null, null, false, out);
    }

    public static boolean invoke(IrSignal irSignal, String protocolName, Protocol protocol, HashMap<String, Long> actualParameters, boolean verbose, PrintStream out) {
        if (irSignal == null) {
            return false;
        }
        boolean verified = false;
        try {
            DecodedSignal[] decodes = DecodeIR.decode(irSignal.toIntArray(), irSignal.getRepeatLength(), irSignal.getEndingLength(), (int)irSignal.getFrequency());
            if (decodes != null) {
                if (decodes.length == 0) {
                    if (verbose) {
                        out.println("-");
                    }
                } else {
                    boolean hasReportedSuccess = false;
                    for (DecodedSignal decode : decodes) {
                        boolean isOk = decode.isOk(protocolName, protocol, actualParameters);
                        if (isOk) {
                            verified = true;
                            Debug.debugDecodeIR(decode + ": success");
                            if (!verbose || hasReportedSuccess) continue;
                            out.println("success");
                            hasReportedSuccess = true;
                            continue;
                        }
                        out.println(decode);
                    }
                }
            }
        }
        catch (UnsatisfiedLinkError ex) {
            UserComm.error("DecodeIR not found in java.library.path");
        }
        return verified;
    }

    private static void usage(int exitcode) {
        System.err.println("Usage:");
        System.err.println("DecodeIR [OPTIONS] -v | --version | --help |  CCF-code | raw-code| - | <filename>");
        System.err.println("where OPTIONS = -d|--debug <n>, -i|--intro <n>, -r|--repetition <n>, -e|--ending <n>, -s|--skip <n>, -f|--frequency <frequency in Hz>");
        System.exit(exitcode);
    }

    public static void main(String[] args) {
        int debug = 0;
        int frequency = 0;
        int introLength = -1;
        int repetitionLength = -1;
        int endingLength = 0;
        try {
            DecodedSignal[] result;
            int skip = 0;
            int arg_i = 0;
            BufferedReader reader = null;
            String ccfString = null;
            String rawString = null;
            block32: while (arg_i < args.length && args[arg_i].length() > 1 && args[arg_i].charAt(0) == '-') {
                switch (args[arg_i]) {
                    case "--help": {
                        DecodeIR.usage(0);
                        continue block32;
                    }
                    case "-v": 
                    case "--version": {
                        System.out.println("DecodeIR version " + DecodeIR.getVersion());
                        System.exit(0);
                    }
                    case "-s": 
                    case "--skip": {
                        int n = ++arg_i;
                        ++arg_i;
                        skip = Integer.parseInt(args[n]);
                        continue block32;
                    }
                    case "-d": 
                    case "--debug": {
                        int n = ++arg_i;
                        ++arg_i;
                        debug = Integer.parseInt(args[n]);
                        Debug.setDebug(debug);
                        continue block32;
                    }
                    case "-f": 
                    case "--frequency": {
                        int n = ++arg_i;
                        ++arg_i;
                        frequency = Integer.parseInt(args[n]);
                        continue block32;
                    }
                    case "-i": 
                    case "--intro": {
                        int n = ++arg_i;
                        ++arg_i;
                        introLength = Integer.parseInt(args[n]);
                        continue block32;
                    }
                    case "-r": 
                    case "--repetition": {
                        int n = ++arg_i;
                        ++arg_i;
                        repetitionLength = Integer.parseInt(args[n]);
                        continue block32;
                    }
                    case "-e": 
                    case "--ending": {
                        int n = ++arg_i;
                        ++arg_i;
                        endingLength = Integer.parseInt(args[n]);
                        continue block32;
                    }
                }
                DecodeIR.usage(1);
            }
            if (args[arg_i].equals("-")) {
                reader = new BufferedReader(new InputStreamReader(System.in, IrpUtils.dumbCharset));
            } else if (args.length - arg_i == 1) {
                if (args[arg_i].startsWith("0000") || args[arg_i].startsWith("0100")) {
                    ccfString = args[arg_i];
                } else if (args[arg_i].startsWith("+")) {
                    rawString = args[arg_i];
                } else {
                    reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(args[arg_i]), IrpUtils.dumbCharset));
                }
            }
            if (reader != null) {
                for (int i = 0; i < skip; ++i) {
                    reader.readLine();
                }
                String line = reader.readLine();
                if (line != null && (line.startsWith("0000") || line.startsWith("0100"))) {
                    ccfString = line;
                } else {
                    rawString = line;
                }
            }
            if (ccfString != null) {
                result = DecodeIR.decode(ccfString);
            } else if (rawString != null) {
                int[] data = DecodeIR.parseRawString(rawString);
                if ((long)introLength != -1L && (long)repetitionLength == -1L) {
                    repetitionLength = data.length / 2 - introLength - endingLength;
                }
                result = DecodeIR.decode(data, repetitionLength, endingLength, frequency);
            } else {
                int i;
                int[] data = new int[args.length - arg_i];
                if ((long)introLength != -1L && (long)repetitionLength == -1L) {
                    repetitionLength = data.length / 2 - introLength - endingLength;
                }
                if (args[arg_i].startsWith("+")) {
                    for (i = 0; i < args.length - arg_i; ++i) {
                        data[i] = Integer.parseInt(args[i + arg_i].replaceFirst("[\\+-]", ""));
                    }
                    result = DecodeIR.decode(data, frequency, repetitionLength, endingLength);
                } else {
                    for (i = 0; i < args.length - arg_i; ++i) {
                        data[i] = Integer.parseInt(args[i + arg_i], 16);
                    }
                    result = DecodeIR.decode(data);
                }
            }
            if (result != null) {
                for (DecodedSignal result1 : result) {
                    System.out.println(result1);
                }
            }
        }
        catch (IrpMasterException ex) {
            System.err.println("IrpMaster exception: " + ex.getMessage());
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
        catch (NumberFormatException ex) {
            System.err.println("Number format exception " + ex.getMessage());
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (debug > 0) {
                System.err.println("ArrayIndexOutOfBoundsException occured");
            }
            DecodeIR.usage(3);
        }
    }

    public static class DecodedSignal {
        private String protocolName;
        private int device;
        private int subDevice;
        private int OBC;
        private String miscMessage;
        private String errorMessage;
        private final HashMap<String, Integer> miscNames = new HashMap();

        public DecodedSignal(String protocolName, int device, int subDevice, int OBC, int[] hex, String miscMessage, String errorMessage) {
            String[] names;
            this.protocolName = protocolName;
            this.device = device;
            this.subDevice = subDevice;
            this.OBC = OBC;
            this.miscMessage = miscMessage;
            this.errorMessage = errorMessage;
            for (String name : names = miscMessage.replaceAll("\\s*=\\s*", "=").split("[ ,]")) {
                String[] q = name.split("=");
                if (q.length != 2) continue;
                try {
                    this.miscNames.put(q[0], Integer.parseInt(q[1]));
                }
                catch (NumberFormatException ex) {
                    UserComm.warning("Output from DecodeIR: `" + name + "' could not be parsed.");
                }
            }
        }

        public DecodedSignal(String protocolName, int device, int subDevice, int OBC) {
            this(protocolName, device, subDevice, OBC, null, "", "");
        }

        public DecodedSignal(String protocolName, int device, int OBC) {
            this(protocolName, device, -1, OBC);
        }

        public HashMap<String, Long> getParameters() {
            LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
            if (this.device >= 0) {
                result.put("D", Long.valueOf(this.device));
            }
            if (this.subDevice >= 0) {
                result.put("S", Long.valueOf(this.subDevice));
            }
            if (this.OBC >= 0) {
                result.put("F", Long.valueOf(this.OBC));
            }
            for (String name : this.miscNames.keySet()) {
                result.put(name, (long)this.miscNames.get(name));
            }
            return result;
        }

        public String getProtocol() {
            return this.protocolName;
        }

        public boolean isOk(String protocolName, Protocol protocol, HashMap<String, Long> vars) {
            if (protocolName == null || protocol == null || vars == null) {
                return false;
            }
            boolean specialOk = true;
            boolean protocolOk = true;
            HashSet<String> exceptionVars = new HashSet<String>();
            if (protocolName.equalsIgnoreCase("x10.n")) {
                protocolOk = this.protocolName.toLowerCase(IrpUtils.dumbLocale).startsWith("x10:");
                specialOk = (long)Integer.parseInt(this.protocolName.substring(4)) == vars.get("N");
                exceptionVars.add("N");
            } else if (protocolName.endsWith("-???-???")) {
                int length = this.protocolName.lastIndexOf(45) + 1;
                protocolOk = protocolName.startsWith(this.protocolName.toLowerCase(IrpUtils.dumbLocale).substring(0, length));
                if (!protocolOk) {
                    return false;
                }
                String MNstring = this.protocolName.substring(length);
                String[] s = MNstring.split("\\.");
                specialOk = (long)Integer.parseInt(s[0]) == vars.get("M") && (long)Integer.parseInt(s[1]) == vars.get("N");
                exceptionVars.add("M");
                exceptionVars.add("N");
            } else if (protocolName.equalsIgnoreCase("tivo")) {
                protocolOk = this.protocolName.toLowerCase(IrpUtils.dumbLocale).startsWith("tivo ");
                specialOk = (long)Integer.parseInt(this.protocolName.substring(10)) == vars.get("U") && this.device == 133 && this.subDevice == 48;
                exceptionVars.add("U");
            } else {
                protocolOk = this.protocolName.equals("XMP-1/2") ? protocolName.equalsIgnoreCase("XMP-1") || protocolName.equalsIgnoreCase("XMP-2") : (this.protocolName.equals("Ad Notam") ? protocolName.equalsIgnoreCase("adnotam") : (this.protocolName.equals("G.I. Cable") ? protocolName.equalsIgnoreCase("G.I.Cable") : (this.protocolName.equals("Pace MSS") ? protocolName.equalsIgnoreCase("PaceMSS") : (this.protocolName.equalsIgnoreCase("RECS80") ? protocolName.substring(0, 6).equalsIgnoreCase("RECS80") : protocolName.equalsIgnoreCase(this.protocolName)))));
            }
            for (Map.Entry<String, Long> kvp : vars.entrySet()) {
                int decodeIrValue;
                String var = kvp.getKey();
                long deflt = -1L;
                try {
                    deflt = protocol.getParameterDefault(var, vars);
                }
                catch (UnassignedException unassignedException) {
                }
                catch (DomainViolationException ex) {
                    System.err.println(ex.getMessage());
                }
                if (exceptionVars.contains(var) || kvp.getValue() == deflt) continue;
                int n = var.equals("D") ? this.device : (var.equals("S") ? this.subDevice : (var.endsWith("F") ? this.OBC : (decodeIrValue = this.miscNames.containsKey(var) ? this.miscNames.get(var) : -1)));
                if ((long)decodeIrValue != -1L && kvp.getValue().intValue() == decodeIrValue) continue;
                return false;
            }
            return protocolOk && specialOk;
        }

        public String toString() {
            return "protocol = " + this.protocolName + (this.device >= 0 ? ", device = " + this.device : "") + (this.subDevice >= 0 ? ", subdevice = " + this.subDevice : "") + ", obc = " + this.OBC + (!this.miscMessage.isEmpty() ? ", misc = " + this.miscMessage : "") + (!this.errorMessage.isEmpty() ? ", error = " + this.errorMessage : "");
        }

        public static String toPrintString(DecodedSignal[] decodes, boolean censor) {
            if (decodes == null) {
                return "";
            }
            if (censor && decodes.length > 1) {
                return decodes[0].toString() + (decodes.length == 2 ? " (+ one other decode)" : " (+ " + decodes.length + " other decodes)");
            }
            StringBuilder result = new StringBuilder();
            for (DecodedSignal decode : decodes) {
                if (result.length() > 0) {
                    result.append("; ");
                }
                result.append(decode.toString());
            }
            return result.toString();
        }

        public static String toPrintString(DecodedSignal[] decodes) {
            return DecodedSignal.toPrintString(decodes, false);
        }

        public Element xmlElement(Document doc) {
            Element el = doc.createElement("decode");
            el.setAttribute("protocol", this.protocolName);
            if (this.device >= 0) {
                el.setAttribute("device", Integer.toString(this.device));
            }
            if (this.subDevice >= 0) {
                el.setAttribute("subdevice", Integer.toString(this.subDevice));
            }
            el.setAttribute("obc", Integer.toString(this.OBC));
            if (!this.miscMessage.isEmpty()) {
                el.setAttribute("misc", this.miscMessage);
            }
            if (!this.errorMessage.isEmpty()) {
                el.setAttribute("error", this.errorMessage);
            }
            return el;
        }
    }

    public static class DecodeIrException
    extends IrpMasterException {
        public DecodeIrException(String string) {
            super(string);
        }
    }
}

