/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.IrpMaster;

import java.util.ArrayList;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.harctoolbox.IrpMaster.ASTTraverser;
import org.harctoolbox.IrpMaster.BitSpec;
import org.harctoolbox.IrpMaster.DomainViolationException;
import org.harctoolbox.IrpMaster.DurationType;
import org.harctoolbox.IrpMaster.Extent;
import org.harctoolbox.IrpMaster.GeneralSpec;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.IrpLexer;
import org.harctoolbox.IrpMaster.IrpParser;
import org.harctoolbox.IrpMaster.PrimitiveIrStreamItem;
import org.harctoolbox.IrpMaster.Protocol;
import org.harctoolbox.IrpMaster.UnassignedException;

public class Duration
extends PrimitiveIrStreamItem {
    private DurationType durationType;
    private double us = -1.0;
    private double time_periods = -1.0;
    private double time_units = -1.0;

    public static Duration newDuration(Protocol env, double time, String unit, DurationType durationType) {
        return durationType == DurationType.extent ? new Extent(env, time, unit) : new Duration(env, time, unit, durationType);
    }

    public Duration(Protocol env, double time, DurationType dt) {
        this(env, time, "u", dt);
    }

    public Duration(Protocol env, double time, String unit, DurationType dt) {
        super(env);
        this.durationType = dt;
        if (unit == null || unit.isEmpty()) {
            this.time_units = time;
        } else if (unit.equals("p")) {
            this.time_periods = time;
        } else if (unit.equals("m")) {
            this.us = 1000.0 * time;
        } else if (unit.equals("u")) {
            this.us = time;
        }
    }

    public double evaluate_sign(double elapsed) throws ArithmeticException, IncompatibleArgumentException {
        return this.durationType == DurationType.flash ? this.evaluate(elapsed) : -this.evaluate(elapsed);
    }

    public double evaluate(double elapsed) throws ArithmeticException, IncompatibleArgumentException {
        if (this.time_periods != -1.0) {
            if (this.environment.getFrequency() > 0.0) {
                return 1000000.0 * this.time_periods / this.environment.getFrequency();
            }
            throw new ArithmeticException("Units in p and frequency == 0 do not go together.");
        }
        if (this.time_units != -1.0) {
            if (this.environment.getUnit() > 0.0) {
                return this.time_units * this.environment.getUnit();
            }
            throw new ArithmeticException("Relative units and unit == 0 do not go together.");
        }
        return this.us;
    }

    public static Duration newDuration(Protocol env, String str) {
        IrpLexer lex = new IrpLexer(new ANTLRStringStream(str));
        CommonTokenStream tokens = new CommonTokenStream(lex);
        IrpParser parser = new IrpParser(tokens);
        try {
            IrpParser.duration_return r = parser.duration();
            CommonTree AST2 = r.getTree();
            return ASTTraverser.duration(env, AST2);
        }
        catch (RecognitionException | DomainViolationException | UnassignedException ex) {
            System.err.println(ex.getMessage());
            return null;
        }
    }

    public DurationType getDurationType() {
        return this.durationType;
    }

    @Override
    public ArrayList<PrimitiveIrStreamItem> evaluate(BitSpec bitSpec) {
        this.debugBegin();
        ArrayList<PrimitiveIrStreamItem> list = new ArrayList<PrimitiveIrStreamItem>(1);
        list.add(this);
        return list;
    }

    public String toString() {
        return (Object)((Object)this.durationType) + ":" + (this.us != -1.0 ? this.us + "u" : (this.time_periods != -1.0 ? this.time_periods + "p" : this.time_units + "u"));
    }

    private static void test(Protocol protocol, String str) throws ArithmeticException, IncompatibleArgumentException {
        Duration d = Duration.newDuration(protocol, str);
        System.out.println(d + "\t" + Math.round(d.evaluate_sign(0.0)));
    }

    private static void test(String str) throws ArithmeticException, IncompatibleArgumentException {
        Duration.test(new Protocol(), str);
    }

    private static void test(String gs, String str) throws ArithmeticException, IncompatibleArgumentException {
        Duration.test(new Protocol(new GeneralSpec(gs)), str);
    }

    private static void usage(int code) {
        System.out.println("Usage:");
        System.out.println("\tDuration [<generalSpec>] <duration> [<variable>=<value>]*");
        System.exit(code);
    }

    public static void main(String[] args) {
        try {
            switch (args.length) {
                case 0: {
                    Duration.usage(1);
                    break;
                }
                case 1: {
                    Duration.test(args[0]);
                    break;
                }
                case 2: {
                    Duration.test(args[0], args[1]);
                    break;
                }
                default: {
                    Protocol prot = new Protocol(new GeneralSpec(args[0]));
                    try {
                        prot.assign(args, 2);
                    }
                    catch (IncompatibleArgumentException ex) {
                        System.err.println(ex.getMessage());
                        Duration.usage(3);
                    }
                    Duration.test(prot, args[1]);
                    break;
                }
            }
        }
        catch (ArithmeticException | IncompatibleArgumentException ex) {
            System.err.println(ex.getMessage());
        }
    }

    @Override
    public boolean isEmpty() throws IncompatibleArgumentException {
        return this.evaluate(0.0) == 0.0;
    }
}

