/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.IrpMaster;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedHashMap;
import org.harctoolbox.IrpMaster.IrpUtils;

public class EvaluateLog {
    LinkedHashMap<String, Integer> map = new LinkedHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EvaluateLog(String filename) {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), IrpUtils.dumbCharset));
        }
        catch (FileNotFoundException ex) {
            System.err.println(ex.getMessage());
            return;
        }
        try {
            String line;
            while ((line = in.readLine()) != null) {
                String[] s = line.split(":");
                if (!s[s.length - 1].equals(" failed")) continue;
                this.map.put(s[0], this.map.containsKey(s[0]) ? this.map.get(s[0]) + 1 : 1);
            }
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {
                System.err.println(ex);
            }
        }
    }

    public String toString() {
        int total = 0;
        StringBuilder result = new StringBuilder();
        for (String protocol : this.map.keySet()) {
            result.append(protocol).append(": ").append(this.map.get(protocol)).append("\n");
            total += this.map.get(protocol).intValue();
        }
        return result.toString() + "\nTotal: " + total;
    }

    private static void usage(int exitcode) {
        System.err.println("Usage:\n\tEvaluateLogs <logfile>");
        System.exit(exitcode);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            EvaluateLog.usage(1);
        }
        EvaluateLog el = new EvaluateLog(args[0]);
        System.out.println(el);
    }
}

