/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.IrpMaster;

import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.harctoolbox.IrpMaster.ASTTraverser;
import org.harctoolbox.IrpMaster.DomainViolationException;
import org.harctoolbox.IrpMaster.GeneralSpec;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.IrpLexer;
import org.harctoolbox.IrpMaster.IrpParser;
import org.harctoolbox.IrpMaster.Protocol;
import org.harctoolbox.IrpMaster.UnassignedException;

public class Expression {
    private static boolean debug;

    public static long evaluate(Protocol env, String str) throws UnassignedException, DomainViolationException {
        IrpLexer lex = new IrpLexer(new ANTLRStringStream(str));
        CommonTokenStream tokens = new CommonTokenStream(lex);
        IrpParser parser = new IrpParser(tokens);
        try {
            IrpParser.expression_return r = parser.expression();
            CommonTree AST2 = r.getTree();
            if (debug) {
                System.out.println(AST2.toStringTree());
            }
            return Expression.evaluate(env, AST2);
        }
        catch (RecognitionException ex) {
            System.err.println(ex.getMessage());
            return 0L;
        }
    }

    public static long evaluate(Protocol env, CommonTree AST2) throws UnassignedException, DomainViolationException {
        return ASTTraverser.expression(env, AST2);
    }

    private static void usage(int code) {
        System.out.println("Usage:");
        System.out.println("\tExpression [-d]? <expression> [<name>=<value>|{<name>=<expression>}]*");
        System.exit(code);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            Expression.usage(1);
        }
        int arg_i = 0;
        if (args[0].equals("-d")) {
            debug = true;
            ++arg_i;
        }
        Protocol prot = new Protocol(new GeneralSpec());
        String expression = null;
        try {
            expression = args[arg_i].trim();
            prot.assign(args, arg_i + 1);
        }
        catch (IncompatibleArgumentException ex) {
            System.err.println(ex.getMessage());
            Expression.usage(1);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            Expression.usage(1);
        }
        if (expression != null && (expression.charAt(0) != '(' || expression.charAt(expression.length() - 1) != ')')) {
            expression = '(' + expression + ')';
        }
        try {
            System.out.println(Expression.evaluate(prot, expression));
        }
        catch (DomainViolationException | UnassignedException ex) {
            System.err.println(ex.getMessage());
        }
    }
}

