/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.IrpMaster;

import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.harctoolbox.IrpMaster.ASTTraverser;
import org.harctoolbox.IrpMaster.BitDirection;
import org.harctoolbox.IrpMaster.IrpLexer;
import org.harctoolbox.IrpMaster.IrpParser;
import org.harctoolbox.IrpMaster.UnassignedException;

public class GeneralSpec {
    private double frequency = 38000.0;
    private double dutyCycle = -1.0;
    public static final double defaultDutyCycle = -1.0;
    private BitDirection bitDirection = defaultBitDirection;
    public static final BitDirection defaultBitDirection = BitDirection.lsb;
    private double unit = 1.0;
    public static final double defaultUnit = 1.0;
    private double unit_pulses = -1.0;

    public String toString() {
        return "Frequency = " + this.frequency + "Hz, unit = " + this.unit + "us, " + (Object)((Object)this.bitDirection) + (this.dutyCycle > 0.0 ? ", Duty cycle = " + this.dutyCycle + "%." : ", Duty cycle: -.");
    }

    private void updateUnit() {
        if (this.unit_pulses != -1.0) {
            if (this.frequency == 0.0) {
                throw new ArithmeticException("Units in p and frequency == 0 do not go together.");
            }
            this.unit = (int)(this.unit_pulses * (1000000.0 / this.frequency));
        }
    }

    public GeneralSpec(BitDirection bitDirection, double unit, double unit_pulses, double frequency, double dutyCycle) {
        this.bitDirection = bitDirection;
        this.unit = unit;
        this.unit_pulses = unit_pulses;
        this.frequency = frequency;
        this.dutyCycle = dutyCycle;
        this.updateUnit();
    }

    private GeneralSpec(GeneralSpec src) {
        this.bitDirection = src.bitDirection;
        this.unit = src.unit;
        this.unit_pulses = src.unit_pulses;
        this.frequency = src.frequency;
        this.dutyCycle = src.dutyCycle;
        this.updateUnit();
    }

    public GeneralSpec() {
        this(defaultBitDirection, 1.0, -1.0, 38000.0, -1.0);
    }

    private static CommonTree toAST(String str) {
        IrpLexer lex = new IrpLexer(new ANTLRStringStream(str));
        CommonTokenStream tokens = new CommonTokenStream(lex);
        IrpParser parser = new IrpParser(tokens);
        CommonTree AST2 = null;
        try {
            IrpParser.generalspec_return r = parser.generalspec();
            AST2 = r.getTree();
        }
        catch (RecognitionException ex) {
            System.err.println(ex.getMessage());
        }
        return AST2;
    }

    private static GeneralSpec newGeneralSpec(CommonTree AST2) {
        GeneralSpec generalSpec;
        block2: {
            generalSpec = null;
            try {
                generalSpec = ASTTraverser.generalspec(AST2);
            }
            catch (UnassignedException ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return generalSpec;
    }

    public GeneralSpec(CommonTree tree) {
        this(GeneralSpec.newGeneralSpec(tree));
    }

    public GeneralSpec(String str) {
        this(GeneralSpec.newGeneralSpec(GeneralSpec.toAST(str)));
    }

    BitDirection getBitDirection() {
        return this.bitDirection;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public double getUnit() {
        return this.unit;
    }

    public double getDutyCycle() {
        return this.dutyCycle;
    }

    private static void test(String str) {
        GeneralSpec gs = new GeneralSpec(str);
        System.out.println(GeneralSpec.toAST(str).toStringTree());
        System.out.println(gs);
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            GeneralSpec.test(args[0]);
        } else {
            GeneralSpec.test("{38.4k,564}");
            GeneralSpec.test("{564,38.4k}");
            GeneralSpec.test("{msb, 889u}");
            GeneralSpec.test("{42%, 10p,msb,40k}");
            GeneralSpec.test("{msb ,40k , 33.33333% ,10p }");
            GeneralSpec.test("{msb, 123u, 100k, 10p, 1000k}");
        }
    }
}

