/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.IrpMaster;

import org.harctoolbox.IrpMaster.Cleaner;
import org.harctoolbox.IrpMaster.DomainViolationException;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.InvalidRepeatException;
import org.harctoolbox.IrpMaster.IrSequence;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.ModulatedIrSequence;
import org.harctoolbox.IrpMaster.ParseException;
import org.harctoolbox.IrpMaster.Pronto;
import org.harctoolbox.IrpMaster.RepeatFinder;
import org.harctoolbox.IrpMaster.UeiLearnedSignal;
import org.harctoolbox.IrpMaster.UnassignedException;

public class InterpretString {
    private InterpretString() {
    }

    public static IrSignal interpretString(String str, double frequency, boolean invokeRepeatFinder, boolean invokeCleaner, double absouluteTolerance, double relativeTolerance) throws ParseException, IncompatibleArgumentException, UnassignedException, DomainViolationException, InvalidRepeatException {
        try {
            if (str.trim().startsWith("[")) {
                String[] codes = str.trim().substring(1).split("[\\[\\]]+");
                return new IrSignal(frequency, -1.0, codes[0], codes.length > 1 ? codes[1] : null, codes.length > 2 ? codes[2] : null);
            }
            try {
                int[] array = Pronto.parseString(str);
                return array != null ? Pronto.ccfSignal(array) : UeiLearnedSignal.parseUeiLearned(str);
            }
            catch (IllegalArgumentException | IncompatibleArgumentException ex) {
                return InterpretString.interpretRawString(str, frequency, invokeRepeatFinder, invokeCleaner, absouluteTolerance, relativeTolerance);
            }
        }
        catch (NumberFormatException ex) {
            throw new ParseException("Could not interpret string " + str + " (" + ex.getMessage() + ")");
        }
    }

    public static IrSignal interpretString(String str, double frequency, boolean invokeRepeatFinder, boolean invokeCleaner) throws ParseException, IncompatibleArgumentException, UnassignedException, DomainViolationException, InvalidRepeatException {
        return InterpretString.interpretString(str, frequency, invokeRepeatFinder, invokeCleaner, 60.0, 0.2);
    }

    private static IrSignal interpretRawString(String str, double frequency, boolean invokeRepeatFinder, boolean invokeCleaner, double absoluteTolerance, double relativeTolerance) throws ParseException, IncompatibleArgumentException {
        try {
            String fixedString = str.replaceAll("\\+\\s+", "+").replaceAll("-\\s+", "-");
            String[] codes = fixedString.split("[\n\r]+");
            if (codes.length > 1 && codes.length <= 3) {
                return new IrSignal(frequency, -1.0, codes[0], codes[1], codes.length > 2 ? codes[2] : null);
            }
            IrSequence irSequence = new IrSequence(fixedString, true);
            ModulatedIrSequence modulatedIrSequence = new ModulatedIrSequence(irSequence, frequency, -1.0);
            return InterpretString.interpretIrSequence(modulatedIrSequence, invokeRepeatFinder, invokeCleaner, absoluteTolerance, relativeTolerance);
        }
        catch (NumberFormatException ex) {
            throw new ParseException("Could not interpret string " + str + " (" + ex.getMessage() + ")");
        }
    }

    public static IrSignal interpretIrSequence(ModulatedIrSequence modulatedIrSequence, boolean invokeRepeatFinder, boolean invokeCleaner, double absoluteTolerance, double relativeTolerance) {
        ModulatedIrSequence cleaned;
        ModulatedIrSequence modulatedIrSequence2 = cleaned = invokeCleaner ? Cleaner.clean(modulatedIrSequence, (int)RepeatFinder.getDefaultAbsoluteTolerance(), RepeatFinder.getDefaultRelativeTolerance()) : modulatedIrSequence;
        if (invokeRepeatFinder) {
            RepeatFinder repeatFinder = new RepeatFinder(modulatedIrSequence, absoluteTolerance, relativeTolerance);
            return repeatFinder.toIrSignal(cleaned);
        }
        return cleaned.toIrSignal();
    }

    public static IrSignal interpretIrSequence(ModulatedIrSequence modulatedIrSequence, boolean invokeRepeatFinder, boolean invokeCleaner) {
        return InterpretString.interpretIrSequence(modulatedIrSequence, invokeRepeatFinder, invokeCleaner, 60.0, 0.2);
    }

    public static IrSignal interpretIrSequence(int[] data, double frequency, boolean invokeRepeatFinder, boolean invokeCleaner, double absoluteTolerance, double relativeTolerance) {
        try {
            return InterpretString.interpretIrSequence(new ModulatedIrSequence(data, frequency, -1.0), invokeRepeatFinder, invokeCleaner, absoluteTolerance, relativeTolerance);
        }
        catch (IncompatibleArgumentException ex) {
            return null;
        }
    }

    public static IrSignal interpretIrSequence(int[] data, double frequency, boolean invokeRepeatFinder, boolean invokeCleaner) {
        try {
            return InterpretString.interpretIrSequence(new ModulatedIrSequence(data, frequency, -1.0), invokeRepeatFinder, invokeCleaner);
        }
        catch (IncompatibleArgumentException ex) {
            return null;
        }
    }
}

