/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.IrpMaster;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.IrpMaster.PrimaryIrStream;
import org.harctoolbox.IrpMaster.UnassignedException;

public class IrSequence
implements Cloneable,
Serializable {
    protected double[] data;
    private static final double epsilon = 0.001;
    private static final int dummySpaceDuration = 50;

    public final double get(int i) {
        return this.data[i];
    }

    public final int iget(int i) {
        return (int)Math.round(Math.abs(this.data[i]));
    }

    public final int[] toInts() {
        return this.toInts(false);
    }

    public final int[] toInts(boolean alternatingSigns) {
        int[] array = new int[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            int duration = (int)Math.round(Math.abs(this.data[i]));
            array[i] = alternatingSigns && i % 2 != 0 ? -duration : duration;
        }
        return array;
    }

    public final double[] toDoubles() {
        return (double[])this.data.clone();
    }

    public final int[] toPulses(double frequency) {
        int[] array = new int[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            array[i] = (int)Math.round(Math.abs(frequency * this.data[i] / 1000000.0));
        }
        return array;
    }

    public IrSequence() {
        this.data = new double[0];
    }

    public IrSequence(double[] data) throws IncompatibleArgumentException {
        if (data.length % 2 != 0) {
            throw new IncompatibleArgumentException("IrSequence has odd length = " + data.length);
        }
        this.data = (double[])data.clone();
    }

    public IrSequence(int[] idata) throws IncompatibleArgumentException {
        this(idata, false);
    }

    public IrSequence(int[] idata, boolean acceptOdd) throws IncompatibleArgumentException {
        int length = idata.length;
        if (length % 2 != 0) {
            if (acceptOdd) {
                --length;
            } else {
                throw new IncompatibleArgumentException("IrSequence has odd length = " + idata.length);
            }
        }
        this.data = new double[length];
        for (int i = 0; i < length; ++i) {
            this.data[i] = idata[i];
        }
    }

    public IrSequence(String str, boolean fixOddSequences) throws IncompatibleArgumentException, NumberFormatException {
        if (str == null || str.trim().isEmpty()) {
            this.data = new double[0];
        } else {
            String[] strings = str.trim().split("[\\s,;]+");
            if (strings.length == 1) {
                strings = str.trim().split("(?=\\+)|(?=-)");
            }
            boolean hasAlternatingSigns = false;
            for (String string : strings) {
                if (!string.startsWith("-")) continue;
                hasAlternatingSigns = true;
                break;
            }
            int[] tmplist = new int[strings.length + 1];
            int index = -1;
            for (String string : strings) {
                if (string.isEmpty()) continue;
                int x = Integer.parseInt(string.replaceFirst("\\+", ""));
                if (index == -1 && x < 0) continue;
                if (hasAlternatingSigns && index >= 0 && this.sameSign(tmplist[index], x)) {
                    int n = index;
                    tmplist[n] = tmplist[n] + x;
                    continue;
                }
                tmplist[++index] = x;
            }
            if (index % 2 == 0) {
                if (fixOddSequences) {
                    tmplist[++index] = 50;
                } else {
                    throw new IncompatibleArgumentException("IrSequence ends with a space");
                }
            }
            this.data = new double[index + 1];
            for (int i = 0; i < index + 1; ++i) {
                this.data[i] = tmplist[i];
            }
        }
    }

    public IrSequence(String str) throws IncompatibleArgumentException, NumberFormatException {
        this(str, false);
    }

    private boolean sameSign(int x, int y) {
        return x < 0 == y < 0;
    }

    public IrSequence(int[] idata, int offset, int length) {
        if (length % 2 != 0) {
            throw new RuntimeException("IrSequence has odd length = " + length);
        }
        if (offset >= idata.length && length != 0) {
            throw new RuntimeException("IrSequence: offset beyond end.");
        }
        if (offset + length > idata.length) {
            throw new RuntimeException("IrSequence: length too large.");
        }
        this.data = new double[length];
        for (int i = 0; i < length; ++i) {
            this.data[i] = idata[i + offset];
        }
    }

    public IrSequence(ArrayList<Double> list) throws IncompatibleArgumentException {
        ArrayList<Double> normalized = IrSequence.normalize(list, true);
        if (normalized.size() % 2 != 0) {
            throw new IncompatibleArgumentException("IrSequence cannot end with a flash.");
        }
        this.data = new double[normalized.size()];
        for (int i = 0; i < normalized.size(); ++i) {
            this.data[i] = normalized.get(i);
        }
    }

    public IrSequence(PrimaryIrStream irStream) throws IncompatibleArgumentException, UnassignedException {
        this(irStream.toIrSequence());
    }

    public IrSequence(IrSequence src) {
        this.data = (double[])src.data.clone();
    }

    public static IrSequence concatenate(Collection<IrSequence> sequences) {
        IrSequence s = new IrSequence();
        for (IrSequence seq : sequences) {
            s = s.append(seq);
        }
        return s;
    }

    public IrSequence append(IrSequence tail, int repetitions) {
        double[] newData = new double[this.data.length + repetitions * tail.data.length];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        for (int r = 0; r < repetitions; ++r) {
            System.arraycopy(tail.data, 0, newData, this.data.length + r * tail.data.length, tail.data.length);
        }
        IrSequence irSequence = new IrSequence();
        irSequence.data = newData;
        return irSequence;
    }

    public IrSequence append(IrSequence tail) {
        return this.append(tail, 1);
    }

    public IrSequence append(double delay) throws IncompatibleArgumentException {
        if (this.data.length == 0) {
            throw new IncompatibleArgumentException("IrSequence is empty");
        }
        IrSequence irSequence = new IrSequence(this);
        irSequence.data[this.data.length - 1] = -(Math.abs(this.data[this.data.length - 1]) + Math.abs(delay));
        return irSequence;
    }

    public IrSequence clone() throws CloneNotSupportedException {
        super.clone();
        return new IrSequence(this);
    }

    public IrSequence subSequence(int start, int length) throws IncompatibleArgumentException {
        if (start % 2 != 0) {
            throw new IncompatibleArgumentException("Starting index has to be even, was " + start);
        }
        double[] newData = new double[length];
        System.arraycopy(this.data, start, newData, 0, length);
        return new IrSequence(newData);
    }

    public IrSequence truncate(int length) throws IncompatibleArgumentException {
        return this.subSequence(0, length);
    }

    public IrSequence[] chop(double threshold) {
        ArrayList<IrSequence> arrayList = new ArrayList<IrSequence>();
        int beg = 0;
        for (int i = 1; i < this.data.length; i += 2) {
            if (!(this.data[i] >= threshold) && i != this.data.length - 1) continue;
            double[] arr = new double[i - beg + 1];
            System.arraycopy(this.data, beg, arr, 0, i - beg + 1);
            try {
                arrayList.add(new IrSequence(arr));
            }
            catch (IncompatibleArgumentException ex) {
                throw new InternalError();
            }
            beg = i + 1;
        }
        return arrayList.toArray(new IrSequence[arrayList.size()]);
    }

    public IrSequence addToFlashes(double amount) {
        IrSequence clone;
        try {
            clone = this.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
        for (int i = 0; i < this.data.length; i += 2) {
            int n = i;
            clone.data[n] = clone.data[n] + (clone.data[i] > 0.0 ? amount : -amount);
        }
        return clone;
    }

    public IrSequence addToGaps(double amount) {
        IrSequence clone;
        try {
            clone = this.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
        for (int i = 1; i < this.data.length; i += 2) {
            int n = i;
            clone.data[n] = clone.data[n] + (clone.data[i] > 0.0 ? amount : -amount);
        }
        return clone;
    }

    public IrSequence flashExcess(double amount) {
        return this.addToFlashes(amount).addToGaps(-amount);
    }

    public IrSequence noisify(double max) {
        IrSequence clone;
        try {
            clone = this.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
        for (int i = 0; i < this.data.length; i += 2) {
            double t = max * (2.0 * Math.random() - 1.0);
            int n = i;
            clone.data[n] = clone.data[n] + t;
            int n2 = i + 1;
            clone.data[n2] = clone.data[n2] - t;
        }
        return clone;
    }

    public boolean isEqual(IrSequence irSequence) {
        return this.isEqual(irSequence, 60.0, 0.2);
    }

    public boolean isEqual(IrSequence irSequence, double absoluteTolerance, double relativeTolerance) {
        if (irSequence == null || this.data.length != irSequence.data.length) {
            return false;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (IrpUtils.isEqual(this.data[i], irSequence.data[i], absoluteTolerance, relativeTolerance)) continue;
            return false;
        }
        return true;
    }

    public boolean isEqual(int beginning, int compareStart, int length, double absoluteTolerance, double relativeTolerance, double lastLimit) {
        boolean specialTreatment = compareStart + length == this.data.length && lastLimit > 0.0;
        for (int i = 0; i < (specialTreatment ? length - 1 : length); ++i) {
            if (IrpUtils.isEqual(Math.abs(this.data[beginning + i]), Math.abs(this.data[compareStart + i]), absoluteTolerance, relativeTolerance)) continue;
            return false;
        }
        return !specialTreatment || IrpUtils.isEqual(Math.abs(this.data[beginning + length - 1]), Math.abs(this.data[compareStart + length - 1]), absoluteTolerance, relativeTolerance) || Math.abs(this.data[beginning + length - 1]) >= lastLimit && Math.abs(this.data[compareStart + length - 1]) >= lastLimit;
    }

    public boolean isEqual(int beginning, int compareStart, int length, double absoluteTolerance, double relativeTolerance) {
        return this.isEqual(beginning, compareStart, length, absoluteTolerance, relativeTolerance, 0.0);
    }

    private static ArrayList<Double> normalize(ArrayList<Double> list, boolean nukeLeadingZeros) {
        if (list == null || list.isEmpty()) {
            return list;
        }
        while (nukeLeadingZeros && list.size() > 1 && list.get(0) <= 0.0) {
            list.remove(0);
        }
        for (int i = 0; i < list.size(); ++i) {
            while (i + 1 < list.size() && IrSequence.equalSign(list.get(i), list.get(i + 1))) {
                double val = list.get(i) + list.get(i + 1);
                list.remove(i);
                list.remove(i);
                list.add(i, val);
            }
        }
        return list;
    }

    private static boolean equalSign(double x, double y) {
        return x <= 0.0 && y <= 0.0 || x >= 0.0 && y >= 0.0;
    }

    public final int getLength() {
        return this.data.length;
    }

    public double getGap() {
        return this.data.length > 0 ? Math.abs(this.data[this.data.length - 1]) : -1.0;
    }

    public final boolean isEmpty() {
        return this.data.length == 0;
    }

    public final boolean containsZeros() {
        for (double t : this.data) {
            if (!(Math.abs(t) < 0.001)) continue;
            return true;
        }
        return false;
    }

    public final boolean replaceZeros(double replacement) {
        boolean wasChanged = false;
        for (int i = 0; i < this.data.length; ++i) {
            if (!(Math.abs(this.data[i]) < 0.001)) continue;
            this.data[i] = replacement;
            wasChanged = true;
        }
        return wasChanged;
    }

    public final int getNumberBursts() {
        return this.data.length / 2;
    }

    public double getDuration() {
        return this.getDuration(0, this.data.length);
    }

    public double getDuration(int begin, int length) {
        return IrpUtils.l1Norm(this.data, begin, length);
    }

    public String toPrintString(boolean alternatingSigns, boolean noSigns, String separator) {
        StringBuilder s = new StringBuilder();
        if (alternatingSigns) {
            for (int i = 0; i < this.data.length; ++i) {
                int x = (int)Math.abs(Math.round(this.data[i]));
                s.append(String.format(i % 2 == 0 ? (i > 0 ? separator + "+%d" : "+%d") : separator + "-%d", x));
            }
        } else if (noSigns) {
            for (int i = 0; i < this.data.length; ++i) {
                int x = (int)Math.abs(Math.round(this.data[i]));
                s.append(String.format(i % 2 == 0 ? (i > 0 ? separator + "%d" : "%d") : separator + "%d", x));
            }
        } else {
            for (int i = 0; i < this.data.length; ++i) {
                s.append(String.format(i > 0 ? separator + "%d" : "%d", (int)Math.round(this.data[i])));
            }
        }
        return s.toString();
    }

    public String toPrintString(boolean alternatingSigns, boolean noSigns) {
        return this.toPrintString(alternatingSigns, noSigns, " ");
    }

    public String toPrintString(boolean alternatingSigns) {
        return this.toPrintString(alternatingSigns, false);
    }

    public String toPrintString() {
        return this.toPrintString(false, false, " ");
    }

    public String toString() {
        if (this.data.length == 0) {
            return "[]";
        }
        StringBuilder result = new StringBuilder();
        result.append("[").append(Math.round(this.data[0]));
        for (int i = 1; i < this.data.length; ++i) {
            result.append(",").append(Math.round(this.data[i]));
        }
        return result.append("]").toString();
    }

    public String toString(boolean alternatingSigns) {
        if (this.data.length == 0) {
            return "[]";
        }
        StringBuilder result = new StringBuilder();
        result.append("[").append(Math.round(Math.abs(this.data[0])));
        for (int i = 1; i < this.data.length; ++i) {
            result.append(",").append(alternatingSigns && i % 2 != 0 ? "-" : "").append(Math.round(Math.abs(this.data[i])));
        }
        return result.append("]").toString();
    }

    public static void main(String[] args) {
        try {
            IrSequence[] seqs;
            IrSignal irSignal = new IrSignal("0000 006C 0022 0002 015B 00AD 0016 0016 0016 0016 0016 0041 0016 0041 0016 0016 0016 0016 0016 0016 0016 0016 0016 0016 0016 0041 0016 0016 0016 0016 0016 0016 0016 0041 0016 0016 0016 0016 0016 0016 0016 0016 0016 0016 0016 0041 0016 0041 0016 0041 0016 0016 0016 0016 0016 0041 0016 0041 0016 0041 0016 0016 0016 0016 0016 0016 0016 0041 0016 0041 0016 06A4 015B 0057 0016 0E6C");
            IrSequence irSequence = irSignal.toModulatedIrSequence(3).noisify(10.0);
            for (IrSequence irs : seqs = irSequence.chop(25000.0)) {
                System.out.println(irs);
            }
        }
        catch (IrpMasterException ex) {
            System.err.println(ex);
        }
        double[] d = new double[]{1.0, 2.0, 3.0, -4.0};
        String raw = " +1266 -426 +1266 -426 +422 -1270 +1266 -426 +1266 -426 +422 -1270 +422 -1270 +422 -1270 +422 -1270 +422 -1270 +422 -1270 +1266 -7096 +1266 -426 +1266 -426 +422 -1270 +1266 -426 +1266 -426 +422 -1270 +422 -1270 +422 -1270 +422 -1270 +422 -1270  +422 -1270 +1266 -7096   ";
        try {
            IrSequence irs = new IrSequence(d);
            System.out.println(irs);
            irs = new IrSequence(raw);
            System.out.println(irs);
            System.out.println(new IrSequence());
        }
        catch (IncompatibleArgumentException incompatibleArgumentException) {
            // empty catch block
        }
    }
}

