/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.IrpMaster;

import java.io.FileNotFoundException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.harctoolbox.IrpMaster.DecodeIR;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.IrSequence;
import org.harctoolbox.IrpMaster.IrpMaster;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.IrpMaster.ModulatedIrSequence;
import org.harctoolbox.IrpMaster.Pass;
import org.harctoolbox.IrpMaster.Pronto;
import org.harctoolbox.IrpMaster.Protocol;
import org.harctoolbox.IrpMaster.UnassignedException;

public class IrSignal {
    protected IrSequence introSequence;
    protected IrSequence repeatSequence;
    protected IrSequence endingSequence;
    protected EnumMap<Pass, IrSequence> map;
    protected double frequency;
    protected double dutyCycle = -1.0;

    public final double getFrequency() {
        return this.frequency;
    }

    public final double getDutyCycle() {
        return this.dutyCycle;
    }

    public final int getIntroLength() {
        return this.introSequence.getLength();
    }

    public final int getIntroBursts() {
        return this.introSequence.getNumberBursts();
    }

    public final int[] getIntroInts(boolean alternatingSigns) {
        return this.introSequence.toInts(alternatingSigns);
    }

    public final int[] getIntroPulses() {
        return this.introSequence.toPulses(this.frequency);
    }

    public final double getIntroDouble(int i) {
        return this.introSequence.get(i);
    }

    public final int getRepeatLength() {
        return this.repeatSequence.getLength();
    }

    public final int getRepeatBursts() {
        return this.repeatSequence.getNumberBursts();
    }

    public final int[] getRepeatInts(boolean alternatingSigns) {
        return this.repeatSequence.toInts(alternatingSigns);
    }

    public final int[] getRepeatPulses() {
        return this.repeatSequence.toPulses(this.frequency);
    }

    public final double getRepeatDouble(int i) {
        return this.repeatSequence.get(i);
    }

    public final int getEndingLength() {
        return this.endingSequence.getLength();
    }

    public final int getEndingBursts() {
        return this.endingSequence.getNumberBursts();
    }

    public final int[] getEndingInts(boolean alternatingSigns) {
        return this.endingSequence.toInts(alternatingSigns);
    }

    public final int[] getEndingPulses() {
        return this.endingSequence.toPulses(this.frequency);
    }

    public final double getEndingDouble(int i) {
        return this.endingSequence.get(i);
    }

    public final double getDuration() {
        return this.introSequence.getDuration() + this.repeatSequence.getDuration() + this.endingSequence.getDuration();
    }

    public final double getDuration(int count) {
        return this.introSequence.getDuration() + (double)this.repeatsPerCountSemantic(count) * this.repeatSequence.getDuration() + this.endingSequence.getDuration();
    }

    public final double getDouble(Pass pass, int i) {
        return this.map.get((Object)pass).get(i);
    }

    public final int getLength(Pass pass) {
        return this.map.get((Object)pass).getLength();
    }

    public String toString() {
        return "Freq=" + Math.round(this.frequency) + "Hz " + this.introSequence + this.repeatSequence + this.endingSequence;
    }

    public String toString(boolean alternatingSigns) {
        return "Freq=" + Math.round(this.frequency) + "Hz " + this.introSequence.toString(alternatingSigns) + this.repeatSequence.toString(alternatingSigns) + this.endingSequence.toString(alternatingSigns);
    }

    public String toPrintString(boolean alternatingSigns, boolean noSigns, String separator) {
        return this.introSequence.toPrintString(alternatingSigns, noSigns, separator) + "\n" + this.repeatSequence.toPrintString(alternatingSigns, noSigns, separator) + (this.endingSequence.getLength() > 0 ? "\n" + this.endingSequence.toPrintString(alternatingSigns, noSigns, separator) : "");
    }

    public String toPrintString(boolean alternatingSigns) {
        return this.toPrintString(alternatingSigns, false, " ");
    }

    public String toPrintString() {
        return this.toPrintString(false);
    }

    private void append(int offset, int[] result, IrSequence seq) {
        for (int i = 0; i < seq.getLength(); ++i) {
            result[i + offset] = seq.iget(i);
        }
    }

    public final int repeatsPerCountSemantic(int count) {
        return this.introSequence.isEmpty() ? count : count - 1;
    }

    public final int[] toIntArray(int repetitions) {
        int[] result = new int[this.introSequence.getLength() + repetitions * this.repeatSequence.getLength() + this.endingSequence.getLength()];
        this.append(0, result, this.introSequence);
        for (int i = 0; i < repetitions; ++i) {
            this.append(this.introSequence.getLength() + i * this.repeatSequence.getLength(), result, this.repeatSequence);
        }
        this.append(this.introSequence.getLength() + repetitions * this.repeatSequence.getLength(), result, this.endingSequence);
        return result;
    }

    public final int[] toIntArray() {
        return this.toIntArray(1);
    }

    public final int[] toIntArrayCount(int count) {
        return this.toIntArray(this.repeatsPerCountSemantic(count));
    }

    public final boolean isEmpty() {
        return this.introSequence.isEmpty() && this.repeatSequence.isEmpty() && this.endingSequence.isEmpty();
    }

    public final boolean containsZeros() {
        return this.introSequence.containsZeros() || this.repeatSequence.containsZeros() || this.endingSequence.containsZeros();
    }

    public final void replaceZeros(double replacement) {
        this.introSequence.replaceZeros(replacement);
        this.repeatSequence.replaceZeros(replacement);
        this.endingSequence.replaceZeros(replacement);
    }

    public void replaceZeros(int replacement) {
        this.replaceZeros(this.frequency > 0.0 ? (double)replacement / this.frequency * 1000000.0 : (double)replacement);
    }

    public final double getGap() {
        return Math.max(this.introSequence.getGap(), this.repeatSequence.getGap());
    }

    public IrSignal(double frequency, double dutyCycle, IrSequence introSequence, IrSequence repeatSequence, IrSequence endingSequence) {
        this.frequency = frequency;
        this.dutyCycle = dutyCycle;
        this.introSequence = introSequence != null && !introSequence.isEqual(repeatSequence) ? introSequence : new IrSequence();
        this.repeatSequence = repeatSequence != null ? repeatSequence : new IrSequence();
        this.endingSequence = endingSequence != null && !endingSequence.isEqual(repeatSequence) ? endingSequence : new IrSequence();
        this.map = new EnumMap(Pass.class);
        this.map.put(Pass.intro, introSequence);
        this.map.put(Pass.repeat, repeatSequence);
        this.map.put(Pass.ending, endingSequence);
    }

    public IrSignal(int[] durations, int noIntroBursts, int noRepeatBursts, int frequency) {
        this(durations, noIntroBursts, noRepeatBursts, frequency, -1.0);
    }

    public IrSignal(double frequency, double dutyCycle, String introSequence, String repeatSequence, String endingSequence) throws IncompatibleArgumentException {
        this(frequency, dutyCycle, new IrSequence(introSequence), new IrSequence(repeatSequence), new IrSequence(endingSequence));
    }

    public IrSignal(int[] durations, int noIntroBursts, int noRepeatBursts, int frequency, double dutyCycle) {
        this((double)frequency, dutyCycle, new IrSequence(durations, 0, 2 * noIntroBursts), new IrSequence(durations, 2 * noIntroBursts, 2 * noRepeatBursts), new IrSequence(durations, 2 * (noIntroBursts + noRepeatBursts), durations.length - 2 * (noIntroBursts + noRepeatBursts)));
    }

    public IrSignal() {
        this(new int[0], 0, 0, 38000);
    }

    private void copyFrom(IrSignal victim) {
        this.dutyCycle = victim.dutyCycle;
        this.frequency = victim.frequency;
        this.introSequence = victim.introSequence;
        this.repeatSequence = victim.repeatSequence;
        this.endingSequence = victim.endingSequence;
        this.map = victim.map;
    }

    public IrSignal(String ccf) throws IrpMasterException {
        this.copyFrom(Pronto.ccfSignal(ccf));
    }

    public IrSignal(int[] ccf) throws IrpMasterException {
        this.copyFrom(Pronto.ccfSignal(ccf));
    }

    public IrSignal(String[] ccf, int begin) throws IrpMasterException {
        this.copyFrom(Pronto.ccfSignal(ccf, begin));
    }

    public IrSignal(String protocolsIniPath, int offset, String ... args) throws IrpMasterException, FileNotFoundException, UnassignedException {
        if (args == null || args.length - offset < 1) {
            throw new IncompatibleArgumentException("Too few arguments");
        }
        if (args[offset].matches("^[0-9]{3}[0-9a-fA-F]$")) {
            int[] ccf = new int[args.length - offset];
            for (int i = 0; i < args.length - offset; ++i) {
                ccf[i] = Integer.parseInt(args[i], 16);
            }
            this.copyFrom(Pronto.ccfSignal(ccf));
        } else {
            int arg_i = offset;
            String protocolName = args[arg_i++];
            LinkedHashMap<String, Long> parameters = new LinkedHashMap<String, Long>();
            while (arg_i < args.length && !args[arg_i].isEmpty() && args[arg_i].contains("=")) {
                String[] kv;
                if ((kv = args[arg_i++].split("=")).length != 2) {
                    throw new IncompatibleArgumentException("Parse error by " + args[arg_i - 1]);
                }
                parameters.put(kv[0], IrpUtils.parseLong(kv[1], true));
            }
            switch (args.length - arg_i) {
                case 0: {
                    break;
                }
                case 1: {
                    parameters.put("F", IrpUtils.parseLong(args[arg_i++], true));
                    break;
                }
                case 2: {
                    parameters.put("D", IrpUtils.parseLong(args[arg_i++], true));
                    parameters.put("F", IrpUtils.parseLong(args[arg_i++], true));
                    break;
                }
                case 3: {
                    parameters.put("D", IrpUtils.parseLong(args[arg_i++], true));
                    parameters.put("S", IrpUtils.parseLong(args[arg_i++], true));
                    parameters.put("F", IrpUtils.parseLong(args[arg_i++], true));
                    break;
                }
                case 4: {
                    parameters.put("D", IrpUtils.parseLong(args[arg_i++], true));
                    parameters.put("S", IrpUtils.parseLong(args[arg_i++], true));
                    parameters.put("F", IrpUtils.parseLong(args[arg_i++], true));
                    parameters.put("T", IrpUtils.parseLong(args[arg_i++], true));
                    break;
                }
                default: {
                    throw new IncompatibleArgumentException("Too many parameters.");
                }
            }
            if (parameters.isEmpty()) {
                throw new IncompatibleArgumentException("No parameters given.");
            }
            IrpMaster irpMaster = new IrpMaster(protocolsIniPath);
            Protocol protocol = irpMaster.newProtocol(protocolName);
            IrSignal irSignal = protocol.renderIrSignal(parameters);
            this.copyFrom(irSignal);
        }
    }

    public IrSignal(String protocolsIniPath, String protocolName, HashMap<String, Long> parameters) throws FileNotFoundException, IrpMasterException {
        this(new IrpMaster(protocolsIniPath), protocolName, parameters);
    }

    public IrSignal(IrpMaster irpMaster, String protocolName, HashMap<String, Long> parameters) throws IrpMasterException {
        Protocol protocol = irpMaster.newProtocol(protocolName);
        if (protocol == null) {
            throw new IrpMasterException("Protocol \"" + protocolName + "\" is not known.");
        }
        IrSignal irSignal = protocol.renderIrSignal(parameters);
        this.copyFrom(irSignal);
    }

    public IrSignal(String protocolsIniPath, String protocolName, String parameters) throws FileNotFoundException, IrpMasterException {
        this(protocolsIniPath, protocolName, Protocol.parseParams(parameters));
    }

    public final ModulatedIrSequence toModulatedIrSequence(int count) {
        return this.toModulatedIrSequence(true, this.repeatsPerCountSemantic(count), true);
    }

    public final ModulatedIrSequence toModulatedIrSequence(boolean intro, int repetitions, boolean ending) {
        IrSequence seq1 = intro ? this.introSequence : new IrSequence();
        IrSequence seq2 = seq1.append(this.repeatSequence, repetitions);
        return new ModulatedIrSequence(ending ? seq2.append(this.endingSequence) : seq2, this.frequency, this.dutyCycle);
    }

    public final IrSignal toOneShot(int count) {
        return new IrSignal(this.frequency, this.dutyCycle, this.toModulatedIrSequence(count), null, null);
    }

    public boolean isEqual(IrSignal irSignal, double absoluteTolerance, double relativeTolerance, double frequencyTolerance) {
        return IrpUtils.isEqual(this.frequency, irSignal.frequency, frequencyTolerance, 0.0) && this.introSequence.isEqual(irSignal.introSequence, absoluteTolerance, relativeTolerance) && this.repeatSequence.isEqual(irSignal.repeatSequence, absoluteTolerance, relativeTolerance) && this.endingSequence.isEqual(irSignal.endingSequence, absoluteTolerance, relativeTolerance);
    }

    public boolean isEqual(IrSignal irSignal) {
        return this.isEqual(irSignal, 60.0, 0.2, 500.0);
    }

    public final ModulatedIrSequence getIntroSequence() {
        return new ModulatedIrSequence(this.introSequence, this.frequency, this.dutyCycle);
    }

    public final ModulatedIrSequence getRepeatSequence() {
        return new ModulatedIrSequence(this.repeatSequence, this.frequency, this.dutyCycle);
    }

    public final ModulatedIrSequence getEndingSequence() {
        return new ModulatedIrSequence(this.endingSequence, this.frequency, this.dutyCycle);
    }

    public final String ccfString() throws IncompatibleArgumentException {
        return Pronto.toPrintString(this);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            int[] times = new int[]{-9024, -4512, -564, -1692, 564, -564, 564, -564, 564, -564, 564, -564, 564, -564, 564, -564, 564, -564, 564, -564, 564, -1692, 564, -564, 564, -564, 564, -564, 564, -564, 564, -564, 564, -564, 564, -1692, 564, -1692, 564, -564, 564, -564, 564, -564, 564, -564, 564, -564, 564, -564, 564, -564, 564, -564, 564, -1692, 564, -1692, 564, -1692, 564, -1692, 564, -1692, 564, -1692, 564, -43992, 9024, -2256, 564, -97572};
            try {
                IrSignal irSignal = new IrSignal(times, 34, 2, 38400);
                System.out.println(irSignal.ccfString());
                System.out.println(irSignal.toString(true));
                System.out.println(irSignal.toString(false));
                System.out.println(irSignal);
            }
            catch (IncompatibleArgumentException ex) {
                System.err.println(ex.getMessage());
            }
        } else {
            String protocolsIni = "data/IrpProtocols.ini";
            int arg_i = 0;
            if (args[arg_i].equals("-c")) {
                int n = ++arg_i;
                ++arg_i;
                protocolsIni = args[n];
            }
            try {
                IrSignal irSignal = new IrSignal(protocolsIni, arg_i, args);
                System.out.println(irSignal);
                System.out.println(irSignal.ccfString());
                DecodeIR.invoke(irSignal);
            }
            catch (FileNotFoundException | IrpMasterException ex) {
                System.err.println(ex.getMessage());
            }
        }
    }
}

