/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.IrpMaster;

import com.hifiremote.exchangeir.Analyzer;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Set;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.harctoolbox.IrpMaster.Debug;
import org.harctoolbox.IrpMaster.DecodeIR;
import org.harctoolbox.IrpMaster.DomainViolationException;
import org.harctoolbox.IrpMaster.ExchangeIR;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.InterpretString;
import org.harctoolbox.IrpMaster.InvalidRepeatException;
import org.harctoolbox.IrpMaster.IrSequence;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.IrpLexer;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.IrpMaster.IrpParseException;
import org.harctoolbox.IrpMaster.IrpParser;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.IrpMaster.Iterate.InputVariableSetValues;
import org.harctoolbox.IrpMaster.Iterate.RandomValueSet;
import org.harctoolbox.IrpMaster.ParseException;
import org.harctoolbox.IrpMaster.Pass;
import org.harctoolbox.IrpMaster.Pronto;
import org.harctoolbox.IrpMaster.Protocol;
import org.harctoolbox.IrpMaster.UeiLearnedSignal;
import org.harctoolbox.IrpMaster.UnassignedException;
import org.harctoolbox.IrpMaster.UnknownProtocolException;
import org.harctoolbox.IrpMaster.UserComm;
import org.harctoolbox.IrpMaster.XmlExport;

public class IrpMaster
implements Serializable {
    private UserComm userComm;
    private static final int max_recursion_depth_expanding = 5;
    private String configFileVersion = "not found";
    private static boolean testParse = false;
    private static String usageMessage = "Usage: one of\n\tIrpMaster --help\n\tIrpMaster [--decodeir] [--analyze] [-c|--config <configfilename>] --version\n\tIrpMaster [OPTIONS] -n|--name <protocolname> [?]\n\tIrpMaster [OPTIONS] --dump <dumpfilename> [-n|--name <protocolname>]\n\tIrpMaster [OPTIONS] [--ccf] <CCF-SIGNAL>|<RAW-SEQUENCE>\n\tIrpMaster [OPTIONS] [--ccf] \"<INTRO-SEQUENCE>\" [\"<REPEAT-SEQUENCE>\" [\"<ENDING-SQUENCE>\"]]\n\tIrpMaster [OPTIONS] [-n|--name] <protocolname> [PARAMETERASSIGNMENT]\n\tIrpMaster [OPTIONS] [-i|--irp] <IRP-Protocol> [PARAMETERASSIGNMENT]\n\nwhere OPTIONS=--stringtree <filename>,--dot <dotfilename>,--xmlprotocol <xmlprotocolfilename>,-c|--config <configfile>,-d|--debug <debugcode>|?,-s|--seed <seed>,-q|--quiet,-P|--pass <intro|repeat|ending|all>,--interactive,--decodeir,--analyze,-o|--outfile <outputfilename>, -x|--xml, -r|--raw, -p|--pronto, -u|--uei, --disregard-repeat-mins, -#|--repetitions <number_repetitions>.\n\nAny filename can be given as `-', meaning stdin or stdout.\nPARAMETERASSIGNMENT is one or more expressions like `name=value' (without spaces!). One value without name defaults to `F`, two values defaults to `D` and `F`, three values defaults to `D`, `S`, and `F`, four values to `D`, `S`, `F', and `T`, in the order given.\n\nAll integer values are nonnegative and can be given in base 10, 16 (prefix `0x'), 8 (leading 0), or 2 (prefix `0b' or `%'). They must be less or equal to 2^63-1 = 9223372036854775807.\n\nAll parameter assignment, both with explicit name and without, can be given as intervals, like `0..255' or '0:255', causing the program to generate all signals within the interval. Also * can be used for parameter intervals, in which case min and max are taken from the parameterspecs in the (extended) IRP notation. The notation #<number> can also be used for parameter intervals, in which case <number> random values between min and max are generated.";
    private LinkedHashMap<String, UnparsedProtocol> protocols = new LinkedHashMap();

    private void dump(PrintStream ps, String name) {
        ps.println(this.protocols.get(name));
    }

    private void dump(PrintStream ps) {
        for (String s : this.protocols.keySet()) {
            this.dump(ps, s);
        }
    }

    private void dump(String filename) throws FileNotFoundException {
        this.dump(IrpUtils.getPrintSteam(filename));
    }

    private void dump(String filename, String name) throws FileNotFoundException {
        this.dump(IrpUtils.getPrintSteam(filename), name);
    }

    public boolean isKnown(String protocol) {
        return this.protocols.containsKey(protocol.toLowerCase(Locale.US));
    }

    public static boolean isKnown(String protocolsPath, String protocol) throws FileNotFoundException, IncompatibleArgumentException {
        return new IrpMaster(protocolsPath).isKnown(protocol);
    }

    public String getIrp(String name) {
        UnparsedProtocol prot = this.protocols.get(name);
        return prot == null ? null : prot.irp;
    }

    public Set<String> getNames() {
        return this.protocols.keySet();
    }

    public String getDocumentation(String name) {
        UnparsedProtocol prot = this.protocols.get(name);
        return prot == null ? null : prot.documentation;
    }

    public String getEfcTranslation(String name) {
        UnparsedProtocol prot = this.protocols.get(name);
        return prot == null ? null : prot.efcTranslation;
    }

    public ArrayList<Short> getUeiProtocol(String name) {
        UnparsedProtocol prot = this.protocols.get(name);
        return prot == null ? null : prot.ueiProtocol;
    }

    public Protocol newProtocol(String name) throws UnassignedException, ParseException, UnknownProtocolException {
        UnparsedProtocol protocol = this.protocols.get(name.toLowerCase(IrpUtils.dumbLocale));
        if (protocol == null) {
            throw new UnknownProtocolException(name);
        }
        return new Protocol(protocol.name.toLowerCase(IrpUtils.dumbLocale), protocol.irp, protocol.documentation);
    }

    public Protocol newProtocolOrNull(String name) throws UnassignedException, ParseException, UnknownProtocolException {
        return this.isKnown(name) ? this.newProtocol(name) : null;
    }

    private void expand() throws IncompatibleArgumentException {
        for (String protocol : this.protocols.keySet()) {
            this.expand(0, protocol);
        }
    }

    private void expand(int depth, String name) throws IncompatibleArgumentException {
        String p_name;
        UnparsedProtocol ancestor;
        UnparsedProtocol p = this.protocols.get(name);
        if (!p.irp.contains("{")) {
            throw new IncompatibleArgumentException("IRP `" + p.irp + "' does not contain `{'.");
        }
        if (!p.irp.startsWith("{") && (ancestor = this.protocols.get((p_name = p.irp.substring(0, p.irp.indexOf(123)).trim()).toLowerCase(IrpUtils.dumbLocale))) != null) {
            String replacement = ancestor.irp.lastIndexOf(91) == -1 ? ancestor.irp : ancestor.irp.substring(0, ancestor.irp.lastIndexOf(91));
            Debug.debugConfigfile("Protocol " + name + ": `" + p_name + "' replaced by `" + replacement + "'.");
            p.irp = p.irp.replaceAll(p_name, replacement);
            this.protocols.put(name, p);
            if (depth < 5) {
                this.expand(depth + 1, name);
            } else {
                System.err.println("Recursion depth in expanding " + name + " exceeded.");
            }
        }
    }

    private void addProtocol(UnparsedProtocol current) {
        if (current == null || current.irp == null || current.name == null) {
            return;
        }
        if (current.documentation != null) {
            current.documentation = current.documentation.trim();
        }
        if (this.protocols.containsKey(current.name.toLowerCase(IrpUtils.dumbLocale))) {
            this.userComm.warningMsg("Multiple definitions of protocol `" + current.name.toLowerCase(IrpUtils.dumbLocale) + "'. Keeping the last.");
        }
        this.protocols.put(current.name.toLowerCase(IrpUtils.dumbLocale), current);
        if (testParse) {
            IrpLexer lex = new IrpLexer(new ANTLRStringStream(current.irp));
            CommonTokenStream tokens = new CommonTokenStream(lex);
            IrpParser parser = new IrpParser(tokens);
            try {
                parser.protocol();
            }
            catch (RecognitionException ex) {
                System.out.println(ex.getMessage());
            }
        }
    }

    private IrpMaster() {
        this.userComm = new UserComm();
    }

    public IrpMaster(InputStream inputStream) throws IncompatibleArgumentException {
        this(new InputStreamReader(inputStream, IrpUtils.dumbCharset));
    }

    public IrpMaster(Reader reader) throws IncompatibleArgumentException {
        this();
        BufferedReader in = new BufferedReader(reader);
        UnparsedProtocol currentProtocol = null;
        int lineNo = 0;
        try {
            String lineRead = in.readLine();
            while (lineRead != null) {
                String payload;
                ++lineNo;
                String line = lineRead.trim();
                String[] kw = line.split("=", 2);
                String keyword = kw[0];
                String string = payload = kw.length > 1 ? kw[1].trim() : null;
                while (payload != null && payload.endsWith("\\")) {
                    payload = payload.substring(0, payload.length() - 1);
                    payload = payload + in.readLine();
                }
                if (!line.startsWith("#")) {
                    if (line.equals("[version]")) {
                        this.configFileVersion = in.readLine();
                    } else if (line.equals("[protocol]")) {
                        this.addProtocol(currentProtocol);
                        currentProtocol = new UnparsedProtocol();
                    } else if (currentProtocol != null && currentProtocol.documentation != null) {
                        currentProtocol.documentation = currentProtocol.documentation + (currentProtocol.documentation.isEmpty() ? line : (line.isEmpty() ? "\n\n" : (currentProtocol.documentation.endsWith("\n") ? "" : " ") + line));
                    } else if (line.equals("[documentation]")) {
                        if (currentProtocol != null) {
                            currentProtocol.documentation = "";
                        }
                    } else if (keyword.equals("name")) {
                        if (currentProtocol != null) {
                            currentProtocol.name = payload;
                        }
                    } else if (keyword.equals("irp")) {
                        if (currentProtocol != null) {
                            currentProtocol.irp = payload;
                        }
                    } else if (keyword.equals("EFC_translation")) {
                        if (currentProtocol != null) {
                            currentProtocol.efcTranslation = payload;
                        }
                    } else if (keyword.equals("usable")) {
                        if (payload == null || !payload.equals("yes")) {
                            currentProtocol = null;
                        }
                    } else if (keyword.equals("UEI_protocol")) {
                        if (currentProtocol != null) {
                            String[] str = payload != null ? payload.split("[\\s,;or]+") : new String[]{};
                            boolean hasComplained = false;
                            for (String s : str) {
                                try {
                                    currentProtocol.ueiProtocol.add(Short.parseShort(s, 16));
                                }
                                catch (NumberFormatException ex) {
                                    if (hasComplained) continue;
                                    Debug.debugConfigfile("Unparsable UEI protocol in line " + lineNo + ": " + line);
                                    hasComplained = true;
                                }
                            }
                        }
                    } else if (keyword.length() <= 1 && !line.isEmpty()) {
                        Debug.debugConfigfile("Ignored line: " + line);
                    }
                }
                lineRead = in.readLine();
            }
            this.addProtocol(currentProtocol);
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
        this.expand();
        Debug.debugConfigfile(this.protocols.size() + " protocols read.");
    }

    public IrpMaster(String datafile) throws FileNotFoundException, IncompatibleArgumentException {
        this(IrpUtils.getInputSteam(datafile));
    }

    private static void usage(int returncode) {
        (returncode == 0 ? System.out : System.err).println(usageMessage);
        System.exit(returncode);
    }

    public static void main(String[] args) {
        InputVariableSetValues inputVariableSetValues = null;
        LinkedHashMap<String, String> usersParameters = new LinkedHashMap<String, String>();
        String configFilename = null;
        String xmlProtocolFilename = null;
        String dotFilename = null;
        String stringtreeFilename = null;
        String dumpFilename = null;
        String irp = null;
        String protocolName = null;
        String outFileName = "-";
        String logFileName = null;
        boolean quiet = false;
        boolean doRaw = false;
        boolean doPronto = false;
        boolean doXML = false;
        boolean doCcf = false;
        boolean doUei = false;
        boolean didSomethingUseful = false;
        boolean invokeDecodeIR = false;
        boolean invokeAnalyzeIR = false;
        boolean generateProtocolInfo = false;
        int pass = -2;
        int seed = -1;
        int arg_i = 0;
        int no_repetitions = 1;
        boolean considerRepeatMins = true;
        boolean interactive = false;
        String irpString = null;
        IrpMaster irpMaster = null;
        if (args.length == 0) {
            IrpMaster.usage(1);
        }
        try {
            while (arg_i < args.length && !args[arg_i].isEmpty() && args[arg_i].charAt(0) == '-') {
                if (args[arg_i].equals("--help")) {
                    IrpMaster.usage(0);
                }
                if (args[arg_i].equals("--version")) {
                    System.out.println("IrpMaster version 1.3");
                    if (configFilename != null) {
                        try {
                            IrpMaster irpmaster = new IrpMaster(configFilename);
                            System.out.println("Configfile version: " + irpmaster.configFileVersion);
                        }
                        catch (FileNotFoundException ex) {
                            System.out.println("Configfile not found");
                        }
                    }
                    if (invokeDecodeIR) {
                        try {
                            System.out.println("DecodeIR version: " + DecodeIR.getVersion());
                        }
                        catch (UnsatisfiedLinkError ex) {
                            System.err.println("DecodeIR not found in java.library.path.");
                        }
                    }
                    if (invokeAnalyzeIR) {
                        System.out.println("Analyzer version: " + Analyzer.getVersion());
                    }
                    System.out.println("JVM: " + System.getProperty("java.vendor") + " " + System.getProperty("java.version") + " " + System.getProperty("os.name") + "-" + System.getProperty("os.arch"));
                    System.out.println();
                    System.out.println("Copyright (C) 2011, 2012, 2013, 2014, 2015, 2016 Bengt Martensson.\n\nThis program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.\n\nThis program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License along with this program. If not, see http://www.gnu.org/licenses/.");
                    System.exit(0);
                }
                if (args[arg_i].equals("-#") || args[arg_i].startsWith("--repetitions")) {
                    int n = ++arg_i;
                    ++arg_i;
                    no_repetitions = (int)IrpUtils.parseLong(args[n], false);
                    continue;
                }
                if (args[arg_i].equalsIgnoreCase("--Analyze")) {
                    ++arg_i;
                    invokeAnalyzeIR = true;
                    continue;
                }
                if (args[arg_i].equals("-c") || args[arg_i].startsWith("--config")) {
                    int n = ++arg_i;
                    ++arg_i;
                    configFilename = args[n];
                    continue;
                }
                if (args[arg_i].startsWith("--ccf")) {
                    ++arg_i;
                    doCcf = true;
                    continue;
                }
                if (args[arg_i].equals("-D") || args[arg_i].equalsIgnoreCase("--DecodeIR")) {
                    ++arg_i;
                    invokeDecodeIR = true;
                    continue;
                }
                if (args[arg_i].equals("-d") || args[arg_i].equals("--debug")) {
                    if (args[++arg_i].equals("?")) {
                        UserComm.print("Debug options: " + Debug.helpString(", "));
                        System.exit(0);
                    }
                    Debug.setDebug((int)IrpUtils.parseLong(args[arg_i++], false));
                    continue;
                }
                if (args[arg_i].equals("--disregard-repeat-mins")) {
                    ++arg_i;
                    considerRepeatMins = false;
                    continue;
                }
                if (args[arg_i].equals("--dot")) {
                    int n = ++arg_i;
                    ++arg_i;
                    dotFilename = args[n];
                    continue;
                }
                if (args[arg_i].equals("--dump")) {
                    int n = ++arg_i;
                    ++arg_i;
                    dumpFilename = args[n];
                    continue;
                }
                if (args[arg_i].equals("-i") || args[arg_i].startsWith("--irp")) {
                    int n = ++arg_i;
                    ++arg_i;
                    irp = args[n];
                    continue;
                }
                if (args[arg_i].startsWith("--interactive")) {
                    ++arg_i;
                    interactive = true;
                    continue;
                }
                if (args[arg_i].equals("-l") || args[arg_i].startsWith("--log")) {
                    int n = ++arg_i;
                    ++arg_i;
                    logFileName = args[n];
                    continue;
                }
                if (args[arg_i].equals("-n") || args[arg_i].startsWith("--name")) {
                    int n = ++arg_i;
                    ++arg_i;
                    protocolName = args[n].toLowerCase(IrpUtils.dumbLocale);
                    continue;
                }
                if (args[arg_i].equals("-o") || args[arg_i].startsWith("--out")) {
                    int n = ++arg_i;
                    ++arg_i;
                    outFileName = args[n];
                    continue;
                }
                if (args[arg_i].equals("-p") || args[arg_i].equals("--pronto")) {
                    ++arg_i;
                    doPronto = true;
                    continue;
                }
                if (args[arg_i].equals("-P") || args[arg_i].equals("--pass")) {
                    int n = ++arg_i;
                    ++arg_i;
                    String arg = args[n];
                    if (arg.matches("[0-9]+")) {
                        pass = Integer.parseInt(arg);
                        considerRepeatMins = true;
                        continue;
                    }
                    pass = Pass.valueOf(arg).toInt();
                    considerRepeatMins = false;
                    continue;
                }
                if (args[arg_i].equals("-q") || args[arg_i].equals("--quiet")) {
                    ++arg_i;
                    quiet = true;
                    continue;
                }
                if (args[arg_i].equals("-r") || args[arg_i].equals("--raw")) {
                    ++arg_i;
                    doRaw = true;
                    continue;
                }
                if (args[arg_i].equals("-s") || args[arg_i].equals("--seed")) {
                    int n = ++arg_i;
                    ++arg_i;
                    seed = Integer.parseInt(args[n]);
                    continue;
                }
                if (args[arg_i].startsWith("--string")) {
                    int n = ++arg_i;
                    ++arg_i;
                    stringtreeFilename = args[n];
                    continue;
                }
                if (args[arg_i].equals("-u") || args[arg_i].equals("--uei")) {
                    ++arg_i;
                    doUei = true;
                    continue;
                }
                if (args[arg_i].equals("-x") || args[arg_i].equals("--xml")) {
                    ++arg_i;
                    doXML = true;
                    continue;
                }
                if (args[arg_i].startsWith("--xmlp")) {
                    int n = ++arg_i;
                    ++arg_i;
                    xmlProtocolFilename = args[n];
                    continue;
                }
                IrpMaster.usage(1);
            }
            UserComm.setQuiet(quiet);
            if (doCcf) {
                boolean prontoPlausible = true;
                boolean ueiPlausible = true;
                boolean rawPlausible = false;
                try {
                    IrSignal irSignal = null;
                    if (args.length == arg_i + 1) {
                        irSignal = args[arg_i].trim().startsWith("+") ? new IrSignal(38000.0, -1.0, new IrSequence(args[arg_i]), null, null) : Pronto.ccfSignal(args[arg_i]);
                    } else if (args.length == arg_i + 2) {
                        irSignal = new IrSignal(38000.0, -1.0, new IrSequence(args[arg_i]), new IrSequence(args[arg_i + 1]), null);
                    } else if (args.length == arg_i + 3) {
                        irSignal = new IrSignal(38000.0, -1.0, new IrSequence(args[arg_i]), new IrSequence(args[arg_i + 1]), new IrSequence(args[arg_i + 2]));
                    } else {
                        int i;
                        int[] ccf = new int[args.length - arg_i];
                        rawPlausible = args[arg_i].startsWith("+");
                        if (rawPlausible) {
                            prontoPlausible = false;
                            ueiPlausible = false;
                            for (i = 0; i < args.length - arg_i; ++i) {
                                ccf[i] = Integer.parseInt(args[i + arg_i].replaceFirst("\\+", ""));
                            }
                        } else {
                            for (i = 0; i < args.length - arg_i; ++i) {
                                prontoPlausible = prontoPlausible && args[i + arg_i].length() == 4;
                                ueiPlausible = ueiPlausible && args[i + arg_i].length() == 2;
                                ccf[i] = Integer.parseInt(args[i + arg_i], 16);
                            }
                        }
                        if (!(prontoPlausible || ueiPlausible || rawPlausible)) {
                            UserComm.error("Signal neither raw, CCF, nor UEI learned.");
                            System.exit(2);
                        }
                        IrSignal irSignal2 = prontoPlausible ? Pronto.ccfSignal(ccf) : (irSignal = rawPlausible ? InterpretString.interpretIrSequence(ccf, 38000.0, true, true) : UeiLearnedSignal.parseUeiLearned(ccf));
                    }
                    if (irSignal == null) {
                        System.err.println("Failure");
                        System.exit(3);
                    }
                    if (doRaw) {
                        System.out.println(irSignal);
                    }
                    if (doPronto) {
                        System.out.println(irSignal.ccfString());
                    }
                    if (doUei) {
                        System.out.println(UeiLearnedSignal.newUeiLearned(irSignal));
                    }
                    if (invokeDecodeIR) {
                        DecodeIR.invoke(irSignal);
                    }
                    if (invokeAnalyzeIR) {
                        System.out.println("AnalyzeIR: " + ExchangeIR.newAnalyzer(irSignal).getIrpWithAltLeadout());
                    }
                }
                catch (NumberFormatException | IrpMasterException ex) {
                    System.err.println(ex);
                    System.exit(3);
                }
                System.exit(0);
            }
            if (!(irp != null || protocolName != null || doCcf || arg_i >= args.length || args[arg_i].isEmpty() || args[arg_i].contains("="))) {
                protocolName = args[arg_i++];
            }
            if (protocolName != null) {
                protocolName = protocolName.toLowerCase(IrpUtils.dumbLocale);
            }
            while (arg_i < args.length && !args[arg_i].isEmpty() && args[arg_i].contains("=")) {
                String[] kv;
                if ((kv = args[arg_i++].split("=")).length != 2) {
                    IrpMaster.usage(1);
                }
                usersParameters.put(kv[0], kv[1]);
            }
            switch (args.length - arg_i) {
                case 0: {
                    if (usersParameters.isEmpty() && protocolName != null) {
                        generateProtocolInfo = true;
                    }
                    break;
                }
                case 1: {
                    if (args[arg_i].equals("?")) {
                        generateProtocolInfo = true;
                        break;
                    }
                    usersParameters.put("F", args[arg_i]);
                    break;
                }
                case 2: {
                    usersParameters.put("D", args[arg_i]);
                    usersParameters.put("F", args[arg_i + 1]);
                    break;
                }
                case 3: {
                    usersParameters.put("D", args[arg_i]);
                    usersParameters.put("S", args[arg_i + 1]);
                    usersParameters.put("F", args[arg_i + 2]);
                    break;
                }
                case 4: {
                    usersParameters.put("D", args[arg_i]);
                    usersParameters.put("S", args[arg_i + 1]);
                    usersParameters.put("F", args[arg_i + 2]);
                    usersParameters.put("T", args[arg_i + 3]);
                    break;
                }
                default: {
                    IrpMaster.usage(1);
                    break;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Debug.debugMain("ArrayIndexOutOfBoundsException: " + e.getMessage());
            IrpMaster.usage(1);
        }
        catch (NumberFormatException e) {
            Debug.debugMain("NumberFormatException: " + e.getMessage());
            IrpMaster.usage(1);
        }
        catch (IncompatibleArgumentException e) {
            UserComm.error(e.getMessage());
            System.exit(4);
        }
        catch (IllegalArgumentException e) {
            System.err.println("IllegalArgumentException: " + e.getMessage());
            System.exit(3);
        }
        if (invokeDecodeIR) {
            try {
                DecodeIR.loadLibrary();
            }
            catch (UnsatisfiedLinkError ex) {
                System.err.println("DecodeIR not found.");
            }
        }
        RandomValueSet.initRng(seed);
        try {
            if (irp != null) {
                if (configFilename != null) {
                    UserComm.warning("Specifying both irp and configuration file is not sensible. Ignoring configuration file.");
                }
                if (protocolName != null) {
                    UserComm.warning("Specifying both irp and protocol name is not sensible. Ignoring protocol name.");
                }
                protocolName = "unnamed_protocol";
                UnparsedProtocol p = new UnparsedProtocol(irp);
                irpMaster = new IrpMaster();
                irpMaster.addProtocol(p);
            } else {
                if (configFilename == null) {
                    System.err.println("Either -i or -c option must be used.");
                    IrpMaster.usage(1);
                }
                irpMaster = new IrpMaster(configFilename);
            }
            if (dumpFilename != null) {
                if (protocolName != null) {
                    irpMaster.dump(dumpFilename, protocolName);
                    System.err.println("Protocol " + irpMaster.protocols.get((Object)protocolName).name + " dumped to " + dumpFilename + ".");
                } else {
                    irpMaster.dump(dumpFilename);
                    System.err.println("All " + irpMaster.protocols.entrySet().size() + " protocols in " + configFilename + " dumped to " + dumpFilename + ".");
                }
                didSomethingUseful = true;
            }
            if (protocolName == null) {
                System.err.println("No protocol name given, nothing to do. Exiting.");
                if (didSomethingUseful) {
                    System.exit(0);
                } else {
                    IrpMaster.usage(1);
                }
            }
            if ((irpString = irpMaster.getIrp(protocolName)) == null) {
                System.err.println("No protocol named `" + protocolName + "' found in " + configFilename + " (case insensitive), exiting.");
                System.exit(2);
            }
            Debug.debugIrpParser("IRP = " + irpString);
            if (generateProtocolInfo) {
                System.out.println(irpString);
                System.exit(0);
            }
            Protocol protocol = irpMaster.newProtocol(protocolName);
            if (dotFilename != null) {
                IrpUtils.getPrintSteam(dotFilename).println(protocol.toDOT());
            }
            if (xmlProtocolFilename != null) {
                new XmlExport(protocol.toDOM()).printDOM(IrpUtils.getPrintSteam(xmlProtocolFilename), null);
            }
            if (stringtreeFilename != null) {
                IrpUtils.getPrintSteam(stringtreeFilename).println(protocol.toString());
            }
            if (usersParameters.isEmpty()) {
                System.err.println("No parameters given, nothing to do. Exiting.");
                System.exit(1);
            }
            if (doXML) {
                protocol.setupDOM();
            }
            try {
                inputVariableSetValues = new InputVariableSetValues(usersParameters, true, protocol);
            }
            catch (NumberFormatException ex) {
                Debug.debugMain("Unparsable number: " + ex.getMessage());
                IrpMaster.usage(1);
            }
            Debug.debugMain(inputVariableSetValues != null ? inputVariableSetValues.toString() : "");
            PrintStream printStream = IrpUtils.getPrintSteam(outFileName);
            PrintStream logFile = IrpUtils.getPrintSteam(logFileName);
            UserComm.setLogging(logFile);
            if (interactive) {
                LinkedHashMap<String, Long> actualParameters = inputVariableSetValues != null ? inputVariableSetValues.iterator().next() : null;
                protocol.interactiveRender(irpMaster.userComm, actualParameters);
                UserComm.print("Bye!");
                System.exit(0);
            }
            for (LinkedHashMap<String, Long> actualParameters : inputVariableSetValues) {
                for (int iterate = 0; iterate < no_repetitions; ++iterate) {
                    IrSequence irSequence = null;
                    IrSignal irSignal = null;
                    if ((long)pass != -2L) {
                        irSequence = protocol.render(actualParameters, pass, considerRepeatMins, true);
                        System.out.println(irSequence == null ? "null" : irSequence.toString());
                        System.out.println(irSequence == null ? "null" : irSequence.toPrintString());
                    } else {
                        irSignal = protocol.renderIrSignal(actualParameters, pass, considerRepeatMins);
                    }
                    if (doXML) {
                        protocol.addSignal(actualParameters);
                    }
                    if (irSignal != null) {
                        Debug.debugMain(irSignal.toString());
                        Debug.debugIrSignals("Total signal duration (us): " + Math.round(irSignal.getDuration()));
                    }
                    boolean writtenHeader = false;
                    if (doRaw && irSignal != null) {
                        if (doXML) {
                            protocol.addRawSignalRepresentation(irSignal);
                        } else {
                            printStream.println(IrpUtils.variableHeader(actualParameters));
                            writtenHeader = true;
                            printStream.println(irSignal.toPrintString());
                        }
                    }
                    if (doPronto && irSignal != null) {
                        if (doXML) {
                            protocol.addXmlNode("pronto", irSignal.ccfString());
                        } else {
                            if (!writtenHeader) {
                                printStream.println(IrpUtils.variableHeader(actualParameters));
                            }
                            writtenHeader = true;
                            printStream.println(irSignal.ccfString());
                        }
                    }
                    if (doUei && irSignal != null) {
                        if (doXML) {
                            protocol.addXmlNode("uei-learned", UeiLearnedSignal.newUeiLearned(irSignal).toString());
                        } else {
                            if (!writtenHeader) {
                                printStream.println(IrpUtils.variableHeader(actualParameters));
                            }
                            writtenHeader = true;
                            printStream.println(UeiLearnedSignal.newUeiLearned(irSignal).toString());
                        }
                    }
                    if (invokeDecodeIR) {
                        if (logFile == null) {
                            System.out.print("DecodeIR result: ");
                        }
                        boolean verified = DecodeIR.invoke(irSignal, protocolName, protocol, actualParameters, logFile == null, System.out);
                        if (logFile != null) {
                            logFile.println(irpMaster.protocols.get((Object)protocolName).name + ": " + IrpUtils.variableHeader(actualParameters) + ": " + (verified ? "passed" : "failed"));
                        }
                    }
                    if (!invokeAnalyzeIR) continue;
                    Analyzer analyzer = ExchangeIR.newAnalyzer(irSignal);
                    System.out.println("AnalyzeIR: " + analyzer.getIrpWithAltLeadout());
                }
            }
            if (doXML) {
                protocol.printDOM(printStream);
            }
            printStream.close();
            if (logFile != null) {
                logFile.close();
            }
        }
        catch (IrpParseException ex) {
            if (irpMaster != null) {
                irpMaster.userComm.errorMsg("IRP parse error: ");
                irpMaster.userComm.printMsg(irpString);
                irpMaster.userComm.printMsg(IrpUtils.spaces(ex.charPositionInLine) + "^");
            } else {
                UserComm.error("IRP parse error: ");
                UserComm.print(irpString);
                UserComm.print(IrpUtils.spaces(ex.charPositionInLine) + "^");
            }
        }
        catch (FileNotFoundException | IrpMasterException ex) {
            if (irpMaster != null) {
                irpMaster.userComm.exceptionMsg(ex);
            }
            UserComm.exception(ex);
        }
    }

    public static String getIrp(String configFilename, String protocolName) {
        IrpMaster irpMaster = null;
        try {
            irpMaster = new IrpMaster(configFilename);
        }
        catch (FileNotFoundException | IncompatibleArgumentException exception) {
            // empty catch block
        }
        return irpMaster == null ? null : irpMaster.getIrp(protocolName);
    }

    public static int makeHex(String outFile, boolean append, String configFileName, String preamble, String protocolName, String device, String OBC) {
        String irp = IrpMaster.getIrp(configFileName, protocolName);
        return irp == null ? -1 : IrpMaster.makeHexIRP(outFile, append, irp, preamble, protocolName, device, OBC);
    }

    public static String makeHex(String configFileName, String protocolName, int device, int subdevice, int obc) {
        IrpMaster irpMaster;
        try {
            irpMaster = new IrpMaster(configFileName);
        }
        catch (FileNotFoundException | IncompatibleArgumentException ex) {
            return null;
        }
        return IrpMaster.makeHexIRP(irpMaster.getIrp(protocolName), device, subdevice, obc);
    }

    public static int makeHexIRP(String outFile, boolean append, String irp, String preamble, String protocolName, String device, String OBC) {
        if (irp == null || irp.isEmpty()) {
            return -2;
        }
        String[] param = device.split("\\.");
        int dev = Integer.parseInt(param[0]);
        int subdev = param.length > 1 ? Integer.parseInt(param[1]) : -1;
        int obc = Integer.parseInt(OBC);
        return IrpMaster.makeHexIRP(outFile, append, irp, preamble, protocolName, dev, subdev, obc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int makeHexIRP(String outFile, boolean append, String irp, String preamble, String protocolName, int device, int subdevice, int obc) {
        int status = 1;
        try (PrintStream out = null;){
            String ccf = IrpMaster.makeHexIRPPriv(irp, device, subdevice, obc);
            out = IrpUtils.getPrintSteam(append ? "+" + outFile : outFile);
            if (preamble != null && !preamble.isEmpty()) {
                out.println(preamble);
            }
            out.println(ccf);
        }
        return status;
    }

    public static String makeHexIRP(String irp, int device, int subdevice, int obc) {
        try {
            return IrpMaster.makeHexIRPPriv(irp, device, subdevice, obc);
        }
        catch (DomainViolationException | IncompatibleArgumentException | InvalidRepeatException | ParseException | UnassignedException irpMasterException) {
            return null;
        }
    }

    private static String makeHexIRPPriv(String irp, int device, int subdevice, int obc) throws UnassignedException, DomainViolationException, IncompatibleArgumentException, InvalidRepeatException, ParseException {
        Protocol protocol = new Protocol(null, irp, null);
        IrSignal irSignal = protocol.renderIrSignal(device, subdevice, obc);
        return irSignal.ccfString();
    }

    private static class UnparsedProtocol
    implements Serializable {
        public static final String unnamed = "unnamed_protocol";
        public String name;
        public String documentation;
        public String irp;
        public String efcTranslation;
        public ArrayList<Short> ueiProtocol;

        UnparsedProtocol(String irp) {
            this.irp = irp;
            this.name = unnamed;
            this.documentation = null;
            this.efcTranslation = null;
            this.ueiProtocol = new ArrayList();
        }

        UnparsedProtocol() {
            this(null);
        }

        public String toString() {
            return this.name + "\t" + this.irp;
        }
    }
}

