/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.IrpMaster;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.harctoolbox.IrpMaster.IrpMaster;

public class IrpUtils {
    public static final String defaultConfigfile = "data" + File.separator + "IrpProtocols.ini";
    public static final String dumbCharsetName = "US-ASCII";
    public static final Charset dumbCharset = Charset.forName("US-ASCII");
    public static final Locale dumbLocale = Locale.US;
    public static final long invalid = -1L;
    public static final long all = -2L;
    public static final long some = -3L;
    public static final int exitSuccess = 0;
    public static final int exitUsageError = 1;
    public static final int exitSemanticUsageError = 2;
    public static final int exitFatalProgramFailure = 3;
    public static final int exitInternalFailure = 4;
    public static final int exitConfigReadError = 5;
    public static final int exitConfigWriteError = 6;
    public static final int exitIoError = 7;
    public static final int exitXmlError = 8;
    public static final int exitDynamicLinkError = 9;
    public static final int exitThisCannotHappen = 10;
    public static final int exitRestart = 99;
    public static final String jp1WikiUrl = "http://www.hifi-remote.com/wiki/index.php?title=Main_Page";
    public static final String irpNotationUrl = "http://www.hifi-remote.com/wiki/index.php?title=IRP_Notation";
    public static final String decodeIrUrl = "http://www.hifi-remote.com/wiki/index.php?title=DecodeIR";
    public static final double defaultFrequency = 38000.0;
    public static final double unknownDutyCycle = -1.0;
    public static final double microseconds2seconds = 1.0E-6;
    public static final double seconds2microseconds = 1000000.0;
    public static final double milliseconds2seconds = 0.001;
    public static final double seconds2milliseconds = 1000.0;
    public static final double milliseconds2microseconds = 1000.0;
    public static final double defaultAbsoluteTolerance = 60.0;
    public static final double defaultRelativeTolerance = 0.2;
    public static final double defaultFrequencyTolerance = 500.0;
    public static final double defaultMinRepeatLastGap = 20000.0;

    public static String join(int beg, String[] s, String separator) {
        if (s == null || s.length <= beg) {
            return "";
        }
        StringBuilder res = new StringBuilder(10 * s.length);
        res.append(s[beg]);
        for (int i = beg + 1; i < s.length; ++i) {
            res.append(separator).append(s[i]);
        }
        return res.toString();
    }

    public static String join(Iterable<String> payload, String separator) {
        StringBuilder str = new StringBuilder(128);
        for (String s : payload) {
            if (str.length() > 0) {
                str.append(separator);
            }
            str.append(s);
        }
        return str.toString();
    }

    public static String join(String[] s, String separator) {
        return IrpUtils.join(0, s, separator);
    }

    public static String join(String[] s, char separator) {
        return IrpUtils.join(s, Character.toString(separator));
    }

    public static String stringArray(int[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "[]";
        }
        StringBuilder result = new StringBuilder(10 * array.length);
        result.append("[").append(array[0]);
        for (int i = 1; i < array.length; ++i) {
            result.append(", ").append(array[i]);
        }
        return result.append("]").toString();
    }

    public static double l1Norm(Double[] sequence) {
        double sum = 0.0;
        for (Double d : sequence) {
            sum += Math.abs(d);
        }
        return sum;
    }

    public static double l1Norm(double[] sequence) {
        return IrpUtils.l1Norm(sequence, 0, sequence.length);
    }

    public static double l1Norm(double[] sequence, int beg, int length) {
        double sum = 0.0;
        for (int i = beg; i < beg + length; ++i) {
            sum += Math.abs(sequence[i]);
        }
        return sum;
    }

    public static boolean isInstance(Object o, String classname) {
        try {
            return Class.forName("IrpMaster." + classname).isInstance(o);
        }
        catch (ClassNotFoundException ex) {
            System.err.println(ex.getMessage());
            return false;
        }
    }

    public static String spaces(int length) {
        byte[] buf = new byte[length];
        for (int i = 0; i < length; ++i) {
            buf[i] = 32;
        }
        return new String(buf, dumbCharset);
    }

    public static PrintStream getPrintSteam(String filename) throws FileNotFoundException {
        if (filename == null) {
            return null;
        }
        String realFilename = filename.startsWith("+") ? filename.substring(1) : filename;
        try {
            return filename.equals("-") ? System.out : new PrintStream((OutputStream)new FileOutputStream(realFilename, filename.startsWith("+")), false, dumbCharsetName);
        }
        catch (UnsupportedEncodingException ex) {
            assert (false);
            return null;
        }
    }

    public static InputStream getInputSteam(String filename) throws FileNotFoundException {
        return filename.equals("-") ? System.in : new FileInputStream(filename);
    }

    public static boolean isEqual(double x, double y, double absoluteTolerance, double relativeTolerance) {
        double absDiff = Math.abs(x - y);
        boolean absoluteOk = absDiff <= absoluteTolerance;
        double max = Math.max(Math.abs(x), Math.abs(y));
        boolean relativeOk = max > 0.0 && absDiff / max <= relativeTolerance;
        return absoluteOk || relativeOk;
    }

    public static boolean isEqual(int x, int y, int absoluteTolerance, double relativeTolerance) {
        int absDiff = Math.abs(x - y);
        boolean absoluteOk = absDiff <= absoluteTolerance;
        int max = Math.max(Math.abs(x), Math.abs(y));
        boolean relativeOk = max > 0 && (double)absDiff / (double)max <= relativeTolerance;
        return absoluteOk || relativeOk;
    }

    public static long power(long x, long y) {
        if (y < 0L) {
            throw new ArithmeticException("power to a negative integer is not sensible here.");
        }
        long r = 1L;
        for (long i = 0L; i < y; ++i) {
            r *= x;
        }
        return r;
    }

    public static long reverse(long x, int width) {
        long y = Long.reverse(x);
        if (width > 0) {
            y >>>= 64 - width;
        }
        return y;
    }

    public static long parseLong(String str, boolean special) {
        String s;
        if (special && (str.startsWith("#") || str.contains(","))) {
            return -3L;
        }
        String string = s = special ? str.replaceAll("[:.\\+<#].*$", "").trim() : str;
        if (special && (s.equals("*") || s.equals("'*'"))) {
            return -2L;
        }
        return s.startsWith("0x") ? Long.parseLong(s.substring(2), 16) : (s.startsWith("0b") ? Long.parseLong(s.substring(2), 2) : (s.startsWith("%") ? Long.parseLong(s.substring(1), 2) : (s.equals("0") ? 0L : (s.startsWith("0") ? Long.parseLong(s.substring(1), 8) : Long.parseLong(s)))));
    }

    public static long parseLong(String str) {
        return IrpUtils.parseLong(str, false);
    }

    public static long parseUpper(String str) {
        String[] s = str.split("\\.\\.");
        if (s.length == 1) {
            s = str.split(":");
        }
        return s.length == 2 ? IrpUtils.parseLong(s[1], false) : -1L;
    }

    public static long variableGet(Map<String, Long> map, String name) {
        return map.containsKey(name) ? map.get(name) : -1L;
    }

    public static String variableHeader(HashMap<String, Long> params) {
        TreeMap<String, Long> map = new TreeMap<String, Long>(params);
        map.remove("D");
        map.remove("F");
        map.remove("S");
        map.remove("T");
        String result = IrpUtils.formatVariable(params, "D", "Device Code: ", "") + IrpUtils.formatVariable(params, "S", ".", "") + " " + IrpUtils.formatVariable(params, "F", "Function: ", "") + IrpUtils.formatVariable(params, "T", ", Toggle: ", "");
        for (String var : map.keySet()) {
            result = result + IrpUtils.formatVariable(params, var, ", " + var + "=", "");
        }
        return result;
    }

    private static String formatVariable(HashMap<String, Long> map, String name, String prefix, String postfix) {
        if (!map.containsKey(name)) {
            return "";
        }
        return prefix + map.get(name) + postfix;
    }

    public static String basename(String s) {
        StringBuilder sb = new StringBuilder(s);
        int n = sb.lastIndexOf(File.separator);
        if (n != -1) {
            sb.delete(0, n + 1);
        }
        if ((n = sb.lastIndexOf(".")) != -1) {
            sb.delete(n, sb.length());
        }
        return sb.toString();
    }

    public static String addExtensionIfNotPresent(String filename, String extension) {
        return filename + (extension != null && !IrpUtils.hasExtension(filename) ? '.' + extension : "");
    }

    private static boolean hasExtension(String filename) {
        int lastSeparator = filename.lastIndexOf(File.separator);
        int lastPeriod = filename.lastIndexOf(46);
        return lastPeriod > lastSeparator;
    }

    public static HashMap<String, Long> mkParameters(long D, long S, long F) {
        HashMap<String, Long> result = new HashMap<String, Long>(3);
        if (D != -1L) {
            result.put("D", D);
        }
        if (S != -1L) {
            result.put("S", S);
        }
        if (F != -1L) {
            result.put("F", F);
        }
        return result;
    }

    public static void main(String[] args) {
        for (String arg : args) {
            System.out.println(arg);
        }
        int arg_i = 0;
        String outFile = args[arg_i++];
        String configFilename = args[arg_i++];
        String preamble = args[arg_i++];
        String protocolName = args[arg_i++];
        String device = args[arg_i++];
        String OBC = args[arg_i++];
        int status = IrpMaster.makeHex(outFile, true, configFilename, preamble, protocolName, device, OBC);
        System.out.println(status);
    }
}

