/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.IrpMaster.Iterate;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.IrpMaster.Iterate.RandomValueSet;
import org.harctoolbox.IrpMaster.Iterate.ValueSetList;
import org.harctoolbox.IrpMaster.ParseException;
import org.harctoolbox.IrpMaster.Protocol;
import org.harctoolbox.IrpMaster.UnassignedException;

public class InputVariableSetValues
implements Iterable<LinkedHashMap<String, Long>> {
    private LinkedHashMap<String, ValueSetList> map;
    private LinkedHashMap<String, Iterator<Long>> iterators;
    private boolean virgin = true;
    private LinkedHashMap<String, Long> currentAssignment;
    private Protocol protocol;

    private boolean isFinished() {
        if (this.virgin) {
            return false;
        }
        boolean finished = true;
        for (String var : this.iterators.keySet()) {
            if (!this.iterators.get(var).hasNext()) continue;
            finished = false;
            break;
        }
        return finished;
    }

    private void update() throws NoSuchElementException {
        if (this.isFinished()) {
            throw new NoSuchElementException();
        }
        if (this.virgin) {
            this.virgin = false;
            return;
        }
        for (String v : this.map.keySet()) {
            Long value;
            if (this.iterators.get(v).hasNext()) {
                value = this.iterators.get(v).next();
                this.currentAssignment.put(v, value);
                break;
            }
            this.map.get(v).reset();
            value = this.iterators.get(v).next();
            this.currentAssignment.put(v, value);
        }
    }

    private InputVariableSetValues(Protocol protocol) {
        this.protocol = protocol;
        this.map = new LinkedHashMap();
        this.currentAssignment = new LinkedHashMap();
        this.iterators = new LinkedHashMap();
    }

    public InputVariableSetValues(String[] str, Protocol protocol) throws UnassignedException, IncompatibleArgumentException, ParseException {
        this(protocol);
        for (String s : str) {
            String[] kv = s.split("=");
            if (kv.length != 2) {
                throw new IllegalArgumentException();
            }
            this.assign(kv[0], kv[1]);
        }
    }

    public InputVariableSetValues(HashMap<String, String> input, boolean reverse, Protocol protocol) throws UnassignedException, IncompatibleArgumentException, ParseException {
        this(protocol);
        if (reverse) {
            String[] s = new String[input.size()];
            input.keySet().toArray(s);
            for (int i = 0; i < s.length; ++i) {
                String key = s[s.length - i - 1];
                this.assign(key, input.get(key));
            }
        } else {
            for (Map.Entry<String, String> kvp : input.entrySet()) {
                this.assign(kvp.getKey(), kvp.getValue());
            }
        }
    }

    public Set<String> getKeys() {
        return this.map.keySet();
    }

    private void assign(String untrimmedName, String value) throws UnassignedException, IncompatibleArgumentException, ParseException {
        ValueSetList vsl;
        String name = untrimmedName.trim();
        try {
            Long val = IrpUtils.parseLong(value, true);
            if (val < 0L && val != -2L && val != -3L) {
                return;
            }
        }
        catch (NumberFormatException ex) {
            if (value == null || value.trim().isEmpty()) {
                throw new UnassignedException("Parameter " + name + " not assigned.");
            }
            throw new IncompatibleArgumentException("Parameter " + name + ": unparsable value `" + value + "'.");
        }
        if (this.protocol == null) {
            throw new UnassignedException("protocol not assigned");
        }
        try {
            vsl = this.protocol.hasParameter(name) ? new ValueSetList(this.protocol.getParameterMin(name), this.protocol.getParameterMax(name), value) : new ValueSetList(null, null, value);
        }
        catch (UnassignedException ex) {
            throw new UnassignedException("Parameter " + name + " not found in parameter specs, cannot loop over it.");
        }
        this.map.put(name, vsl);
        Iterator<Long> it = vsl.iterator();
        this.currentAssignment.put(name, it.next());
        this.iterators.put(name, it);
    }

    public void reset() {
        for (String var : this.map.keySet()) {
            this.map.get(var).reset();
            this.currentAssignment.put(var, this.iterators.get(var).next());
        }
        this.virgin = true;
    }

    public String toString() {
        return this.map.toString();
    }

    @Override
    public Iterator<LinkedHashMap<String, Long>> iterator() {
        return new Iterator<LinkedHashMap<String, Long>>(){

            @Override
            public boolean hasNext() {
                return !InputVariableSetValues.this.isFinished();
            }

            @Override
            public LinkedHashMap<String, Long> next() throws NoSuchElementException {
                InputVariableSetValues.this.update();
                return InputVariableSetValues.this.currentAssignment;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported.");
            }
        };
    }

    public static void main(String[] args) {
        int seed = -1;
        int arg_i = 0;
        if (args[arg_i].equals("-s")) {
            seed = Integer.parseInt(args[++arg_i]);
            ++arg_i;
        }
        RandomValueSet.initRng(seed);
        String[] s = new String[args.length - arg_i];
        System.arraycopy(args, arg_i, s, 0, args.length - arg_i);
        InputVariableSetValues ivsv = null;
        try {
            ivsv = new InputVariableSetValues(s, null);
        }
        catch (UnassignedException ex) {
            System.err.println(ex.getMessage());
            System.exit(23);
        }
        catch (ParseException ex) {
            System.err.println(ex.getMessage());
            System.exit(24);
        }
        catch (IncompatibleArgumentException ex) {
            System.err.println(ex.getMessage());
            System.exit(25);
        }
        System.out.println(ivsv);
        for (LinkedHashMap<String, Long> hm : ivsv) {
            System.out.println(hm);
        }
    }
}

