/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.IrpMaster.Iterate;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import org.harctoolbox.IrpMaster.Iterate.ValueSet;

public class RandomValueSet
extends ValueSet {
    long max;
    int index;
    int noRandoms;
    static Random rng;

    public static void initRng(int seed) {
        rng = seed > 0 ? new Random(seed) : new Random();
    }

    public static void initRng() {
        RandomValueSet.initRng(-1);
    }

    public String toString() {
        return "{" + RandomValueSet.formatThing("min", (int)this.min) + RandomValueSet.formatThing(", max", (int)this.max) + RandomValueSet.formatThing(", noRandoms", this.noRandoms) + "}";
    }

    public RandomValueSet(long min, long max, int noRandoms) {
        super(min);
        this.max = max;
        this.noRandoms = noRandoms;
        this.index = 0;
    }

    @Override
    public void reset() {
        this.index = 0;
    }

    @Override
    public Iterator<Long> iterator() {
        return new Iterator<Long>(){

            @Override
            public Long next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if (rng == null) {
                    throw new RuntimeException("Must call RandomValueSet.initRng() before using RandomValueSet");
                }
                ++RandomValueSet.this.index;
                RandomValueSet.this.current = rng.nextInt((int)RandomValueSet.this.max + 1);
                return RandomValueSet.this.current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported.");
            }

            @Override
            public boolean hasNext() {
                return RandomValueSet.this.index < RandomValueSet.this.noRandoms;
            }
        };
    }
}

