/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.IrpMaster.Iterate;

import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.IrpMaster.Iterate.IterationValueSet;
import org.harctoolbox.IrpMaster.Iterate.RandomValueSet;
import org.harctoolbox.IrpMaster.Iterate.ShiftValueSet;
import org.harctoolbox.IrpMaster.Iterate.SingletonValueSet;
import org.harctoolbox.IrpMaster.ParseException;
import org.harctoolbox.IrpMaster.UnassignedException;

public abstract class ValueSet
implements Iterable<Long> {
    protected long min;
    protected long current;

    protected static String formatThing(String prefix, int variable) {
        return (long)variable == -1L ? "" : prefix + "=" + variable;
    }

    protected ValueSet(long min) {
        this.min = min;
        this.current = -1L;
    }

    public void reset() {
        this.current = -1L;
    }

    public static ValueSet newValueSet(Long protocolMin, Long protocolMax, String s) throws UnassignedException, ParseException {
        if (s.contains("<<")) {
            String[] q = s.split("<<");
            long min = IrpUtils.parseLong(q[0], true);
            if (min == 0L) {
                throw new IllegalArgumentException("Shifting 0 in " + s + " senseless.");
            }
            long max = IrpUtils.parseUpper(q[0]);
            int shift = (int)IrpUtils.parseLong(q[1], true);
            return new ShiftValueSet(min, max, shift);
        }
        if (s.contains("++")) {
            String[] q = s.split("\\+\\+");
            if (q.length != 2) {
                throw new ParseException("Could not parse value set " + s);
            }
            long min = IrpUtils.parseLong(q[0], true);
            long max = IrpUtils.parseUpper(q[0]);
            int increment = (int)IrpUtils.parseLong(q[1], false);
            return new IterationValueSet(min, max, increment);
        }
        if (s.contains("#")) {
            if (protocolMin == null || protocolMax == null) {
                throw new UnassignedException("min or max not assigned");
            }
            String[] q = s.split("#");
            long min = q[0].trim().isEmpty() ? protocolMin : IrpUtils.parseLong(q[0], true);
            long max = q[0].trim().isEmpty() ? protocolMax : IrpUtils.parseUpper(q[0]);
            int noRandoms = (int)IrpUtils.parseLong(q[1], true);
            return new RandomValueSet(min, max, noRandoms);
        }
        if (s.startsWith("*")) {
            if (protocolMin == null || protocolMax == null) {
                throw new UnassignedException("min or max not assigned");
            }
            return new IterationValueSet(protocolMin, protocolMax, 1);
        }
        long min = IrpUtils.parseLong(s, true);
        long max = IrpUtils.parseUpper(s);
        return max == -1L ? new SingletonValueSet(min) : new IterationValueSet(min, max, 1);
    }

    public static void main(String[] args) {
        int seed = -1;
        int arg_i = 0;
        if (args[arg_i].equals("-s")) {
            seed = Integer.parseInt(args[++arg_i]);
            ++arg_i;
        }
        RandomValueSet.initRng(seed);
        ValueSet vs = null;
        try {
            vs = ValueSet.newValueSet(0L, 255L, args[arg_i]);
        }
        catch (ParseException | UnassignedException ex) {
            System.err.println(ex.getMessage());
        }
        System.out.println(vs);
        System.out.println();
        if (vs != null) {
            for (Long l : vs) {
                System.out.println(l);
            }
        }
    }
}

