/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.IrpMaster.Iterate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.harctoolbox.IrpMaster.Iterate.RandomValueSet;
import org.harctoolbox.IrpMaster.Iterate.ValueSet;
import org.harctoolbox.IrpMaster.ParseException;
import org.harctoolbox.IrpMaster.UnassignedException;

public class ValueSetList
implements Iterable<Long> {
    private ArrayList<ValueSet> valueSets = new ArrayList();
    private int currentSetIndex = -1;
    private Iterator<Long> setIterator = null;

    public void reset() {
        this.currentSetIndex = -1;
        this.setIterator = null;
        for (ValueSet valueSet : this.valueSets) {
            valueSet.reset();
        }
    }

    public ValueSetList(Long min, Long max, String str) throws UnassignedException, ParseException {
        String[] q;
        for (String q1 : q = str.split(",")) {
            this.valueSets.add(ValueSet.newValueSet(min, max, q1));
        }
    }

    @Override
    public Iterator<Long> iterator() {
        return new Iterator<Long>(){

            @Override
            public boolean hasNext() {
                return ValueSetList.this.valueSets.size() > 0 && ((long)ValueSetList.this.currentSetIndex == -1L || ValueSetList.this.setIterator.hasNext() || ValueSetList.this.currentSetIndex < ValueSetList.this.valueSets.size() - 1);
            }

            @Override
            public Long next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                if ((long)ValueSetList.this.currentSetIndex == -1L) {
                    ValueSetList.this.currentSetIndex = 0;
                }
                if (ValueSetList.this.setIterator != null && !ValueSetList.this.setIterator.hasNext()) {
                    ValueSetList.this.currentSetIndex++;
                    ValueSetList.this.setIterator = null;
                }
                if (ValueSetList.this.setIterator == null) {
                    ValueSetList.this.setIterator = ((ValueSet)ValueSetList.this.valueSets.get(ValueSetList.this.currentSetIndex)).iterator();
                }
                Long l = (Long)ValueSetList.this.setIterator.next();
                return l;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported.");
            }
        };
    }

    public String toString() {
        return this.valueSets.toString();
    }

    public static void main(String[] args) {
        int seed = -1;
        int arg_i = 0;
        if (args[arg_i].equals("-s")) {
            seed = Integer.parseInt(args[++arg_i]);
            ++arg_i;
        }
        RandomValueSet.initRng(seed);
        ValueSetList vsl = null;
        try {
            vsl = new ValueSetList(0L, 255L, args[arg_i]);
        }
        catch (ParseException | UnassignedException ex) {
            System.err.println(ex.getMessage());
        }
        System.out.println(vsl);
        if (vsl == null) {
            return;
        }
        for (Long l : vsl) {
            System.out.println(l);
        }
        System.out.println("----------------");
        vsl.reset();
        for (Long l : vsl) {
            System.out.println(l);
        }
    }
}

