/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.IrpMaster;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class LibraryLoader {
    private static List<String> loadedLibs = new ArrayList<String>();
    private static String subFolderName = (System.getProperty("os.name").startsWith("Windows") ? "Windows" : System.getProperty("os.name")) + '-' + System.getProperty("os.arch").toLowerCase(Locale.US);

    public static void loadLibrary(String appHome, String libraryName) throws UnsatisfiedLinkError {
        if (loadedLibs.contains(libraryName)) {
            return;
        }
        try {
            System.load(LibraryLoader.fileName(appHome, libraryName).getCanonicalPath());
        }
        catch (UnsatisfiedLinkError ex) {
            System.loadLibrary(libraryName);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        loadedLibs.add(libraryName);
    }

    public static File fileName(String appHome, String libraryName) {
        String stem = System.getProperty("harctoolbox.jniLibsHome") != null ? System.getProperty("harctoolbox.jniLibsHome") : appHome;
        String mappedName = System.mapLibraryName(libraryName);
        return new File(new File(stem, subFolderName), mappedName);
    }

    private LibraryLoader() {
    }
}

