/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.IrpMaster;

import java.util.Collection;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.IrSequence;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.IrpUtils;

public class ModulatedIrSequence
extends IrSequence {
    private static final double allowedFrequencyDeviation = 0.05;
    private static final double zeroModulationLimit = 1.0E-6;
    protected double frequency = 0.0;
    protected double dutyCycle = -1.0;

    public final double getFrequency() {
        return this.frequency;
    }

    public final double getDutyCycle() {
        return this.dutyCycle;
    }

    @Override
    public String toString() {
        return "{" + Integer.toString((int)Math.round(this.frequency)) + "," + super.toString() + "}";
    }

    private ModulatedIrSequence() {
    }

    public ModulatedIrSequence(IrSequence irSequence, double frequency, double dutyCycle) {
        this.data = irSequence.data;
        this.frequency = frequency;
        this.dutyCycle = dutyCycle;
    }

    public ModulatedIrSequence(IrSequence irSequence, double frequency) {
        this(irSequence, frequency, -1.0);
    }

    public ModulatedIrSequence(int[] durations, double frequency, double dutyCycle) throws IncompatibleArgumentException {
        this(new IrSequence(durations), frequency, dutyCycle);
    }

    public ModulatedIrSequence(int[] durations, double frequency) throws IncompatibleArgumentException {
        this(new IrSequence(durations), frequency, -1.0);
    }

    public ModulatedIrSequence(ModulatedIrSequence ... seqs) {
        int cumulatedLength = 0;
        double minf = Double.MAX_VALUE;
        double maxf = Double.MIN_VALUE;
        double mindc = Double.MAX_VALUE;
        double maxdc = Double.MIN_VALUE;
        for (ModulatedIrSequence seq : seqs) {
            minf = Math.min(minf, seq.frequency);
            maxf = Math.max(maxf, seq.frequency);
            mindc = Math.min(mindc, seq.frequency);
            maxdc = Math.max(maxdc, seq.frequency);
            cumulatedLength += seq.getLength();
        }
        this.dutyCycle = mindc > 0.0 ? (mindc + maxdc) / 2.0 : -1.0;
        this.frequency = minf > 0.0 ? (minf + maxf) / 2.0 : 0.0;
        this.data = new double[cumulatedLength];
        int beginIndex = 0;
        for (ModulatedIrSequence seq : seqs) {
            System.arraycopy(seq.data, 0, this.data, beginIndex, seq.data.length);
            beginIndex += seq.data.length;
        }
    }

    @Override
    public String toPrintString(boolean alternatingSigns, boolean noSigns, String separator) {
        return this.toPrintString(alternatingSigns, noSigns, separator, false);
    }

    public String toPrintString(boolean alternatingSigns, boolean noSigns, String separator, boolean includeFrequency) {
        return (this.isEmpty() || !includeFrequency ? "" : "f=" + Long.toString(Math.round(this.frequency)) + separator) + super.toPrintString(alternatingSigns, noSigns, separator);
    }

    @Override
    public String toPrintString(boolean alternatingSigns, boolean noSigns) {
        return this.toPrintString(alternatingSigns, noSigns, " ");
    }

    @Override
    public String toPrintString(boolean alternatingSigns) {
        return this.toPrintString(alternatingSigns, false);
    }

    @Override
    public String toPrintString() {
        return this.toPrintString(false, false, " ");
    }

    public final IrSignal toIrSignal() {
        return new IrSignal(this.frequency, this.dutyCycle, this, new IrSequence(), new IrSequence());
    }

    public IrSignal toIrSignal(int beginningLength, int repeatLength, int noRepeats) throws IncompatibleArgumentException {
        IrSequence intro = this.truncate(beginningLength);
        IrSequence repeat = this.subSequence(beginningLength, repeatLength);
        int startEnding = beginningLength + noRepeats * repeatLength;
        int lengthEnding = this.getLength() - startEnding;
        IrSequence ending = this.subSequence(startEnding, lengthEnding);
        return new IrSignal(this.frequency, this.dutyCycle, intro, repeat, ending);
    }

    public boolean isEqual(ModulatedIrSequence irSequence, double absoluteTolerance, double relativeTolerance, double frequencyTolerance) {
        return IrpUtils.isEqual(this.getFrequency(), irSequence.getFrequency(), 500.0, 0.0) && super.isEqual(irSequence, absoluteTolerance, relativeTolerance);
    }

    public final boolean isZeroModulated() {
        return this.frequency < 1.0E-6;
    }

    @Override
    public ModulatedIrSequence append(double delay) throws IncompatibleArgumentException {
        IrSequence irSequence = ((IrSequence)this).append(delay);
        return new ModulatedIrSequence(irSequence, this.frequency, this.dutyCycle);
    }

    public ModulatedIrSequence append(ModulatedIrSequence tail) throws IncompatibleArgumentException {
        if (this.isZeroModulated() ? !tail.isZeroModulated() : Math.abs(this.frequency - tail.getFrequency()) / this.frequency > 0.05) {
            throw new IncompatibleArgumentException("concationation not possible; modulation frequencies differ");
        }
        IrSequence irSequence = this.append((IrSequence)tail);
        return new ModulatedIrSequence(irSequence, this.frequency, this.dutyCycle);
    }

    public static ModulatedIrSequence concatenate(Collection<IrSequence> sequences, double frequency, double dutyCycle) {
        return new ModulatedIrSequence(IrSequence.concatenate(sequences), frequency, dutyCycle);
    }

    public final ModulatedIrSequence[] chop(double amount) {
        IrSequence[] irSequences = super.chop(amount);
        ModulatedIrSequence[] mods = new ModulatedIrSequence[irSequences.length];
        for (int i = 0; i < irSequences.length; ++i) {
            mods[i] = new ModulatedIrSequence(irSequences[i], this.frequency, this.dutyCycle);
        }
        return mods;
    }
}

