/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.IrpMaster;

import java.util.HashMap;
import java.util.Map;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.harctoolbox.IrpMaster.Debug;
import org.harctoolbox.IrpMaster.DomainViolationException;
import org.harctoolbox.IrpMaster.GeneralSpec;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.IrpLexer;
import org.harctoolbox.IrpMaster.IrpParser;
import org.harctoolbox.IrpMaster.ParameterSpec;
import org.harctoolbox.IrpMaster.ParameterSpecs;
import org.harctoolbox.IrpMaster.ParseException;
import org.harctoolbox.IrpMaster.Protocol;
import org.harctoolbox.IrpMaster.UnassignedException;
import org.harctoolbox.IrpMaster.UserComm;

public class NameEngine {
    private HashMap<String, CommonTree> map = new HashMap();

    public CommonTree get(String name) {
        Debug.debugNameEngine("NameEngine: " + name + (this.map.containsKey(name) ? " = " + this.map.get(name).toStringTree() : "-"));
        return this.map.get(name);
    }

    public void parseDefines(String str) throws ParseException {
        String[] s;
        for (String item : s = str.replaceAll("[{}]", "").split(",")) {
            this.define(item);
        }
    }

    private void define(String str) throws ParseException {
        String[] s = str.split("=");
        this.define(s[0], s[1]);
    }

    private void define(String name, CommonTree t) {
        this.map.put(name.trim(), t);
    }

    private void define(CommonTree t) {
        this.define(t.getChild(0).getText(), (CommonTree)t.getChild(1));
    }

    public void readDefinitions(CommonTree t) {
        for (int i = 0; i < t.getChildCount(); ++i) {
            this.define((CommonTree)t.getChild(i));
        }
    }

    public void readDefinitions(String str) {
        IrpLexer lex = new IrpLexer(new ANTLRStringStream(str));
        CommonTokenStream tokens = new CommonTokenStream(lex);
        IrpParser parser = new IrpParser(tokens);
        try {
            IrpParser.definitions_return r = parser.definitions();
            CommonTree AST2 = r.getTree();
            this.readDefinitions(AST2);
        }
        catch (RecognitionException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public void define(String name, String bare_expression) throws ParseException {
        IrpLexer lex = new IrpLexer(new ANTLRStringStream(bare_expression));
        CommonTokenStream tokens = new CommonTokenStream(lex);
        IrpParser parser = new IrpParser(tokens);
        try {
            IrpParser.bare_expression_return r = parser.bare_expression();
            this.map.put(name.trim(), r.getTree());
        }
        catch (RecognitionException ex) {
            throw new ParseException(ex);
        }
    }

    public void assign(String name, long value) {
        this.define(name, IrpParser.newIntegerTree(value));
    }

    public void loadDefaults(ParameterSpecs parameterSpecs, boolean initial) {
        for (ParameterSpec param : parameterSpecs.getParams()) {
            if (!initial && param.hasMemory() || param.getDefault() == null) continue;
            this.map.put(param.getName(), param.getDefault());
        }
    }

    public void loadActualParameters(HashMap<String, Long> ivs, ParameterSpecs paramSpecs) throws DomainViolationException {
        for (Map.Entry<String, Long> kvp : ivs.entrySet()) {
            String name = kvp.getKey();
            if (!paramSpecs.isEmpty()) {
                ParameterSpec ps = paramSpecs.getParameterSpec(name);
                if (ps == null) {
                    UserComm.warning("Parameter `" + name + "' unknown in ParameterSpecs.");
                } else if (!ps.isOK(kvp.getValue())) {
                    throw new DomainViolationException("Parameter " + name + " = " + kvp.getValue() + " outside of allowed domain (" + ps.domainAsString() + ").");
                }
            }
            this.assign(name, kvp.getValue());
        }
    }

    public void checkAssignments(ParameterSpecs paramSpecs) throws UnassignedException {
        for (String name : paramSpecs.getNames()) {
            if (this.map.containsKey(name)) continue;
            throw new UnassignedException("Parameter `" + name + "' has not been assigned.");
        }
    }

    public String evaluate(String name) throws UnassignedException {
        if (this.map.containsKey(name)) {
            return this.map.get(name).toStringTree();
        }
        throw new UnassignedException("Name `" + name + "' not defined.");
    }

    public boolean containsKey(String name) {
        return this.map.containsKey(name);
    }

    public String tryEvaluate(String name) {
        String result = null;
        try {
            result = this.evaluate(name);
        }
        catch (UnassignedException ex) {
            System.err.println(ex.getMessage());
        }
        return result;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (String name : this.map.keySet()) {
            str.append(name).append("=").append(this.map.get(name).toStringTree()).append(",");
        }
        return "{" + (str.length() == 0 ? "" : str.substring(0, str.length() - 1)) + "}";
    }

    public String notationString(String equals, String separator) {
        StringBuilder str = new StringBuilder();
        for (String name : this.map.keySet()) {
            if (name.startsWith("$") || this.map.get(name).toStringTree().startsWith("(")) continue;
            str.append(name).append(equals).append(this.map.get(name).toStringTree()).append(separator);
        }
        return str.length() == 0 ? "" : str.substring(0, str.length() - 1);
    }

    private static void usage(int code) {
        System.err.println("Usage:");
        System.err.println("\tNameEngine [<name>=<value>|{<name>=<expression>}]+");
        System.exit(code);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            NameEngine.usage(1);
        }
        Protocol prot = new Protocol(new GeneralSpec());
        try {
            prot.assign(args, 0);
        }
        catch (IncompatibleArgumentException ex) {
            System.err.println(ex.getMessage());
            NameEngine.usage(3);
        }
        System.out.println(prot.nameEngineString());
    }
}

