/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.IrpMaster;

import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.harctoolbox.IrpMaster.IrpLexer;
import org.harctoolbox.IrpMaster.IrpParser;
import org.harctoolbox.IrpMaster.ParseException;

public class ParameterSpec {
    private String name;
    private long min;
    private long max;
    private CommonTree deflt;
    private boolean memory = false;

    public String toString() {
        return this.name + (this.memory ? "@" : "") + ":" + this.min + ".." + this.max + (this.deflt != null ? "=" + this.deflt.toStringTree() : "");
    }

    public ParameterSpec(String name, int min, int max, boolean memory, int deflt) {
        this(name, min, max, memory, IrpParser.newIntegerTree(deflt));
    }

    public ParameterSpec(String name, int min, int max) {
        this(name, min, max, false);
    }

    public ParameterSpec(String name, int min, int max, boolean memory, CommonTree deflt) {
        this.name = name;
        this.min = min;
        this.max = max;
        this.memory = memory;
        this.deflt = deflt;
    }

    public ParameterSpec(String name, int min, int max, boolean memory) {
        this(name, min, max, memory, (CommonTree)null);
    }

    public ParameterSpec(String name, int min, int max, boolean memory, String bare_expression) throws ParseException {
        this.name = name;
        this.min = min;
        this.max = max;
        this.memory = memory;
        IrpLexer lex = new IrpLexer(new ANTLRStringStream(bare_expression));
        CommonTokenStream tokens = new CommonTokenStream(lex);
        IrpParser parser = new IrpParser(tokens);
        try {
            CommonTree ct;
            IrpParser.bare_expression_return r = parser.bare_expression();
            this.deflt = ct = r.getTree();
        }
        catch (RecognitionException ex) {
            throw new ParseException(ex);
        }
    }

    public ParameterSpec(CommonTree t) {
        this.load(t);
    }

    public ParameterSpec(String parameter_spec) throws ParseException {
        IrpLexer lex = new IrpLexer(new ANTLRStringStream(parameter_spec));
        CommonTokenStream tokens = new CommonTokenStream(lex);
        IrpParser parser = new IrpParser(tokens);
        try {
            IrpParser.parameter_spec_return r = parser.parameter_spec();
            CommonTree ct = r.getTree();
            this.load(ct);
        }
        catch (RecognitionException ex) {
            throw new ParseException(ex);
        }
    }

    private void load(CommonTree t) {
        this.memory = t.getText().equals("PARAMETER_SPEC_MEMORY");
        this.name = t.getChild(0).getText();
        this.min = Long.parseLong(t.getChild(1).getText());
        this.max = Long.parseLong(t.getChild(2).getText());
        this.deflt = t.getChildCount() >= 4 ? (CommonTree)t.getChild(3) : null;
    }

    public boolean isOK(long x) {
        return this.min <= x && x <= this.max;
    }

    public String domainAsString() {
        return this.min + ".." + this.max;
    }

    public String getName() {
        return this.name;
    }

    public CommonTree getDefault() {
        return this.deflt;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public boolean hasMemory() {
        return this.memory;
    }

    public static void main(String[] args) {
        ParameterSpec dev = null;
        ParameterSpec toggle = null;
        ParameterSpec func = null;
        try {
            dev = new ParameterSpec("d", 0, 255, false, "255-s");
            toggle = new ParameterSpec("t", 0, 1, true, 0);
            func = new ParameterSpec("F", 0, 1, false, 0);
            System.out.println(new ParameterSpec("Fx", 0, 1, false, 0));
            System.out.println(new ParameterSpec("Fx", 0, 1, false));
            System.out.println(new ParameterSpec("Fx", 0, 1));
            System.out.println(new ParameterSpec("D:0..31"));
            System.out.println(new ParameterSpec("D@:0..31=42"));
            System.out.println(new ParameterSpec("D:0..31=42*3+33"));
            System.out.println(dev);
            System.out.println(toggle);
            System.out.println(func);
            System.out.println(dev.isOK(-1L));
            System.out.println(dev.isOK(0L));
            System.out.println(dev.isOK(255L));
            System.out.println(dev.isOK(256L));
        }
        catch (ParseException ex) {
            System.out.println(ex.getMessage());
        }
    }
}

