/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.IrpMaster;

import java.util.ArrayList;
import org.harctoolbox.IrpMaster.BitField;
import org.harctoolbox.IrpMaster.BitSpec;
import org.harctoolbox.IrpMaster.BitStream;
import org.harctoolbox.IrpMaster.Debug;
import org.harctoolbox.IrpMaster.Duration;
import org.harctoolbox.IrpMaster.DurationType;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.IrSequence;
import org.harctoolbox.IrpMaster.PrimaryIrStreamItem;
import org.harctoolbox.IrpMaster.PrimitiveIrStreamItem;
import org.harctoolbox.IrpMaster.Protocol;
import org.harctoolbox.IrpMaster.UnassignedException;

public class PrimaryIrStream
extends PrimaryIrStreamItem {
    private ArrayList<PrimaryIrStreamItem> irStreamItems;
    private BitSpec bitSpec;
    private boolean hasAssignmentContent = false;

    public PrimaryIrStream(Protocol env) {
        super(env);
        this.irStreamItems = new ArrayList();
    }

    public PrimaryIrStream(Protocol env, boolean hasAssignmentContent) {
        this(env);
        this.hasAssignmentContent = hasAssignmentContent;
    }

    public PrimaryIrStream(Protocol env, ArrayList<PrimaryIrStreamItem> items, BitSpec bitSpec, int noAlternatives) {
        super(env);
        this.bitSpec = bitSpec;
        this.irStreamItems = items;
        this.noAlternatives = noAlternatives;
    }

    public PrimaryIrStream(Protocol env, PrimaryIrStream src, BitSpec bitSpec) {
        this(env, src, bitSpec, 0);
    }

    public PrimaryIrStream(Protocol env, PrimaryIrStream src, BitSpec bitSpec, int noAlternatives) {
        this(env, src != null ? src.irStreamItems : new ArrayList<PrimaryIrStreamItem>(), bitSpec, noAlternatives);
    }

    public String toString() {
        return this.irStreamItems.toString();
    }

    @Override
    public boolean isEmpty() {
        return this.irStreamItems.isEmpty() && !this.hasAssignmentContent;
    }

    public void concatenate(PrimaryIrStream irStream) {
        this.irStreamItems.addAll(irStream.irStreamItems);
    }

    public void assignBitSpecs() {
        this.assignBitSpecs(null);
    }

    public void assignBitSpecs(BitSpec parentBitSpec) {
        if (this.bitSpec == null) {
            this.bitSpec = parentBitSpec;
            Debug.debugBitSpec("BitSpec " + this.bitSpec + "was assigned to " + this);
        } else {
            this.bitSpec.assignBitSpecs(parentBitSpec);
        }
        for (PrimaryIrStreamItem item : this.irStreamItems) {
            if (!item.getClass().getSimpleName().equals("PrimaryIrStream")) continue;
            ((PrimaryIrStream)item).assignBitSpecs(this.bitSpec);
        }
    }

    @Override
    public ArrayList<PrimitiveIrStreamItem> evaluate(BitSpec bitSpec) throws IncompatibleArgumentException, UnassignedException {
        BitSpec bs = bitSpec == null || this.bitSpec != null ? this.bitSpec : bitSpec;
        this.debugBegin();
        ArrayList<PrimitiveIrStreamItem> list = new ArrayList<PrimitiveIrStreamItem>();
        BitStream bitStream = new BitStream(this.environment);
        for (PrimaryIrStreamItem item : this.irStreamItems) {
            if (item.getClass().getSimpleName().equals("BitField")) {
                bitStream.add((BitField)item);
                continue;
            }
            if (!bitStream.isEmpty()) {
                list.addAll(bitStream.evaluate(bs));
                bitStream = new BitStream(this.environment);
            }
            list.addAll(item.evaluate(bs));
        }
        if (!bitStream.isEmpty()) {
            list.addAll(bitStream.evaluate(bs));
        }
        this.debugEnd(list);
        return list;
    }

    public IrSequence toIrSequence() throws IncompatibleArgumentException, UnassignedException {
        ArrayList<PrimitiveIrStreamItem> durationList = this.evaluate(null);
        if (durationList.size() % 2 == 1) {
            durationList.add(new Duration(this.environment, 0.001, DurationType.gap));
        }
        int size = durationList.size();
        ArrayList<Double> data = new ArrayList<Double>(size);
        double elapsed = 0.0;
        boolean seenPositive = false;
        for (PrimitiveIrStreamItem item : durationList) {
            try {
                if (!Class.forName("org.harctoolbox.IrpMaster.Duration").isInstance(item)) {
                    throw new RuntimeException("Programming error detected: This cannot happen");
                }
                double duration = ((Duration)item).evaluate_sign(elapsed);
                if (duration > 0.0) {
                    seenPositive = true;
                }
                if (seenPositive) {
                    elapsed += Math.abs(duration);
                    data.add(duration);
                }
                if (!Class.forName("org.harctoolbox.IrpMaster.Extent").isInstance(item)) continue;
                elapsed = 0.0;
            }
            catch (ClassNotFoundException ex) {
                assert (false);
            }
        }
        return new IrSequence(data);
    }
}

