/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.IrpMaster;

import java.util.HashMap;
import org.harctoolbox.IrpMaster.DomainViolationException;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.InvalidRepeatException;
import org.harctoolbox.IrpMaster.IrSequence;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.IrpMaster.ParseException;
import org.harctoolbox.IrpMaster.Protocol;
import org.harctoolbox.IrpMaster.UnassignedException;
import org.harctoolbox.IrpMaster.UserComm;

public class Pronto {
    public static final int charsInDigit = 4;
    public static final double prontoConstant = 0.241246;
    private static final double dummyFrequency = 414514.6448024009;
    public static final String formattingCode = "%04X";
    private static final int learnedCode = 0;
    private static final int learnedZeroFrequencyCode = 256;
    private static final int rc5Code = 20480;
    private static final int rc5xCode = 20481;
    private static final int rc6Code = 24576;
    private static final int nec1Code = 36874;
    private static final int rc5Frequency = 115;
    private static final int rc5xFrequency = 115;
    private static final int rc6Frequency = 115;
    private static final int nec1Frequency = 108;
    private static final String rc5Irp = "{36k,msb,889}<1,-1|-1,1>((1:1,~F:1:6,T:1,D:5,F:6,^114m)+,T=1-T)[T@:0..1=0,D:0..31,F:0..127]";
    private static final String rc5xIrp = "{36k,msb,889}<1,-1|-1,1>(1:1,~S:1:6,T:1,D:5,-4,S:6,F:6,^114m,T=1-T)+ [D:0..31,S:0..127,F:0..63,T@:0..1=0]";
    private static final String rc6Irp = "{36k,444,msb}<-1,1|1,-1>(6,-2,1:1,0:3,<-2,2|2,-2>(T:1),D:8,F:8,^107m,T=1-T)+ [D:0..255,F:0..255,T@:0..1=0]";
    private static final String nec1Irp = "{38.4k,564}<1,-1|1,-3>(16,-8,D:8,S:8,F:8,~F:8,1,-78,(16,-4,1,-173)*) [D:0..255,S:0..255=255-D,F:0..255]";
    private IrSignal irSignal;

    public Pronto(IrSignal irSignal) throws IncompatibleArgumentException {
        this.irSignal = irSignal;
        if (irSignal.getEndingLength() != 0) {
            UserComm.warning("When computing the Pronto representation, a (non-empty) ending sequence was ignored");
        }
    }

    public static final String formatInteger(int n) {
        return String.format(formattingCode, n);
    }

    public static final int getProntoCode(double f) {
        return (int)Math.round(1000000.0 / ((f > 0.0 ? f : 414514.6448024009) * 0.241246));
    }

    public static final double getFrequency(int code) {
        return code == 0 ? -1.0 : 1000000.0 / ((double)code * 0.241246);
    }

    public final double getFrequency() {
        return this.irSignal.frequency;
    }

    public static final double getPulseTime(int code) {
        return code == 0 ? -1.0 : (double)code * 0.241246;
    }

    public static final int pulses(double us, double frequency) {
        return (int)Math.round(Math.abs(us) * (frequency > 0.0 ? frequency : 414514.6448024009) / 1000000.0);
    }

    public static final int[] toArray(double frequency, double[] sequence) {
        if (sequence.length % 2 == 1) {
            throw new RuntimeException("IR Sequence must be of even length.");
        }
        int[] data = new int[sequence.length];
        for (int i = 0; i < sequence.length; ++i) {
            data[i] = Pronto.pulses(sequence[i], frequency);
        }
        return data;
    }

    private static double[] usArray(int frequencyCode, int[] ccfArray, int beg, int end) {
        double pulseTime = Pronto.getPulseTime(frequencyCode);
        double[] data = new double[end - beg];
        for (int i = beg; i < end; ++i) {
            data[i - beg] = pulseTime * (double)ccfArray[i];
        }
        return data;
    }

    public static final IrSignal ccfSignal(int[] ccf) throws ParseException, IncompatibleArgumentException, UnassignedException, DomainViolationException, InvalidRepeatException {
        int repeatLength;
        int introLength;
        if (ccf.length < 4) {
            throw new IncompatibleArgumentException("CCF is invalid since less than 4 numbers long.");
        }
        if (ccf.length % 2 != 0) {
            throw new IncompatibleArgumentException("CCF is invalid since it has an odd number (" + ccf.length + ") of durations.");
        }
        int index = 0;
        int type = ccf[index++];
        int frequencyCode = ccf[index++];
        if (index + 2 * ((introLength = ccf[index++]) + (repeatLength = ccf[index++])) != ccf.length) {
            throw new IncompatibleArgumentException("Inconsistent length in CCF (claimed " + (introLength + repeatLength) + " pairs, was " + (ccf.length - 4) / 2 + " pairs).");
        }
        IrSignal irSignal = null;
        String irp = null;
        int dev = -1;
        int subdev = -1;
        int cmd = -1;
        int pass = -2;
        switch (type) {
            case 0: 
            case 256: {
                double[] intro = Pronto.usArray(frequencyCode, ccf, index, index + 2 * introLength);
                double[] repeat = Pronto.usArray(frequencyCode, ccf, index + 2 * introLength, ccf.length);
                IrSequence introSequence = new IrSequence(intro);
                IrSequence repeatSequence = new IrSequence(repeat);
                irSignal = new IrSignal(type == 0 ? Pronto.getFrequency(frequencyCode) : 0.0, -1.0, introSequence, repeatSequence, null);
                break;
            }
            case 20480: {
                if (repeatLength != 1) {
                    throw new IncompatibleArgumentException("wrong repeat length");
                }
                irp = rc5Irp;
                pass = 1;
                dev = ccf[index++];
                cmd = ccf[index++];
                break;
            }
            case 20481: {
                if (repeatLength != 2) {
                    throw new IncompatibleArgumentException("wrong repeat length");
                }
                irp = rc5xIrp;
                pass = 1;
                dev = ccf[index++];
                subdev = ccf[index++];
                cmd = ccf[index++];
                break;
            }
            case 24576: {
                if (repeatLength != 1) {
                    throw new IncompatibleArgumentException("wrong repeat length");
                }
                irp = rc6Irp;
                pass = 1;
                dev = ccf[index++];
                cmd = ccf[index++];
                break;
            }
            case 36874: {
                int cmd_chk;
                if (repeatLength != 1) {
                    throw new IncompatibleArgumentException("wrong repeat length");
                }
                irp = nec1Irp;
                dev = ccf[index] >> 8;
                subdev = ccf[index++] & 0xFF;
                cmd = ccf[index] >> 8;
                if (cmd == (cmd_chk = 255 - (ccf[index++] & 0xFF))) break;
                throw new IncompatibleArgumentException("checksum erroneous");
            }
            default: {
                throw new IncompatibleArgumentException("CCF type 0x" + Integer.toHexString(type) + " not supported");
            }
        }
        if (irSignal == null) {
            HashMap<String, Long> parameters = new HashMap<String, Long>();
            parameters.put("D", Long.valueOf(dev));
            if (subdev != -1) {
                parameters.put("S", Long.valueOf(subdev));
            }
            parameters.put("F", Long.valueOf(cmd));
            if (pass == 1) {
                parameters.put("T", 0L);
            }
            Protocol protocol = new Protocol(null, irp, null);
            irSignal = protocol.renderIrSignal(parameters, pass);
        }
        return irSignal;
    }

    public static final IrSignal ccfSignal(String ccfString) throws IrpMasterException {
        int[] ccf;
        try {
            ccf = Pronto.parseString(ccfString);
        }
        catch (NumberFormatException ex) {
            throw new IrpMasterException("Non-parseable CCF string: " + ccfString);
        }
        if (ccf == null) {
            throw new IrpMasterException("Invalid CCF string: " + ccfString);
        }
        return Pronto.ccfSignal(ccf);
    }

    public static final IrSignal ccfSignal(String[] array, int begin) throws IrpMasterException {
        int[] ccf;
        try {
            ccf = Pronto.parseStringArray(array, begin);
        }
        catch (NumberFormatException ex) {
            throw new IrpMasterException("Non-parseable CCF strings");
        }
        if (ccf == null) {
            throw new IrpMasterException("Invalid CCF strings");
        }
        return Pronto.ccfSignal(ccf);
    }

    public static final int[] parseString(String ccfString) throws NumberFormatException {
        String[] array = ccfString.trim().split("\\s+");
        return Pronto.parseStringArray(array, 0);
    }

    public static final int[] parseStringArray(String[] array, int begin) {
        int[] ccf = new int[array.length];
        for (int i = begin; i < array.length; ++i) {
            if (array[i].length() != 4 || array[i].charAt(0) == '+' || array[i].charAt(0) == '-') {
                return null;
            }
            try {
                ccf[i] = Integer.parseInt(array[i], 16);
                continue;
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return ccf;
    }

    public final int[] initArray() {
        return Pronto.toArray(this.irSignal.frequency, this.irSignal.introSequence.data);
    }

    public final int[] repeatArray() {
        return Pronto.toArray(this.irSignal.frequency, this.irSignal.repeatSequence.data);
    }

    public static final int[] toArray(double frequency, double[] intro, double[] repetition) {
        int i;
        if (intro.length % 2 == 1 || repetition.length % 2 == 1) {
            throw new RuntimeException("IR Sequences must be of even length.");
        }
        int[] data = new int[4 + intro.length + repetition.length];
        int index = 0;
        data[index++] = frequency > 0.0 ? 0 : 256;
        data[index++] = Pronto.getProntoCode(frequency);
        data[index++] = intro.length / 2;
        data[index++] = repetition.length / 2;
        for (i = 0; i < intro.length; ++i) {
            data[index++] = Pronto.pulses(intro[i], frequency);
        }
        for (i = 0; i < repetition.length; ++i) {
            data[index++] = Pronto.pulses(repetition[i], frequency);
        }
        return data;
    }

    public final int[] toArray() {
        int i;
        if (this.irSignal.getIntroLength() % 2 != 0 || this.irSignal.getRepeatLength() % 2 != 0) {
            throw new RuntimeException("IR Sequences must be of even length.");
        }
        int[] data = new int[4 + this.irSignal.getIntroLength() + this.irSignal.getRepeatLength()];
        int index = 0;
        data[index++] = this.irSignal.getFrequency() > 0.0 ? 0 : 256;
        data[index++] = Pronto.getProntoCode(this.irSignal.getFrequency());
        data[index++] = this.irSignal.getIntroLength() / 2;
        data[index++] = this.irSignal.getRepeatLength() / 2;
        for (i = 0; i < this.irSignal.getIntroLength(); ++i) {
            data[index++] = Pronto.pulses(this.irSignal.getIntroDouble(i), this.irSignal.getFrequency());
        }
        for (i = 0; i < this.irSignal.getRepeatLength(); ++i) {
            data[index++] = Pronto.pulses(this.irSignal.getRepeatDouble(i), this.irSignal.getFrequency());
        }
        return data;
    }

    public String toPrintString() {
        return Pronto.toPrintString(this.toArray());
    }

    public static String toPrintString(int[] array) {
        String s = "";
        for (int i = 0; i < array.length; ++i) {
            s = s + String.format((i > 0 ? " " : "") + formattingCode, array[i]);
        }
        return s;
    }

    public static String toPrintString(IrSignal irSignal) {
        String str = null;
        try {
            str = new Pronto(irSignal).toPrintString();
        }
        catch (IncompatibleArgumentException incompatibleArgumentException) {
            // empty catch block
        }
        return str;
    }

    public static final String shortCCFString(String protocolName, int device, int subdevice, int command) throws IncompatibleArgumentException {
        int[] ccf = Pronto.shortCCF(protocolName, device, subdevice, command);
        return ccf == null ? null : Pronto.toPrintString(ccf);
    }

    public static final int[] shortCCF(String protocolName, int device, int subdevice, int command) throws IncompatibleArgumentException {
        int index = 0;
        if (protocolName.equalsIgnoreCase("rc5")) {
            if (device > 31 || subdevice != -1 || command > 127) {
                throw new IncompatibleArgumentException("Invalid parameters");
            }
            int[] result = new int[6];
            result[index++] = 20480;
            result[index++] = 115;
            result[index++] = 0;
            result[index++] = 1;
            result[index++] = device;
            result[index++] = command;
            return result;
        }
        if (protocolName.equalsIgnoreCase("rc5x")) {
            if (device > 31 || subdevice > 127 || subdevice < 0 || command > 63) {
                throw new IncompatibleArgumentException("Invalid parameters");
            }
            int[] result = new int[8];
            result[index++] = 20481;
            result[index++] = 115;
            result[index++] = 0;
            result[index++] = 2;
            result[index++] = device;
            result[index++] = subdevice;
            result[index++] = command;
            result[index++] = 0;
            return result;
        }
        if (protocolName.equalsIgnoreCase("rc6")) {
            if (device > 255 || subdevice != -1 || command > 255) {
                throw new IncompatibleArgumentException("Invalid parameters");
            }
            int[] result = new int[6];
            result[index++] = 24576;
            result[index++] = 115;
            result[index++] = 0;
            result[index++] = 1;
            result[index++] = device;
            result[index++] = command;
            return result;
        }
        if (protocolName.equalsIgnoreCase("nec1")) {
            if (device > 255 || subdevice > 255 || command > 255) {
                throw new IncompatibleArgumentException("Invalid parameters");
            }
            int[] result = new int[6];
            result[index++] = 36874;
            result[index++] = 108;
            result[index++] = 0;
            result[index++] = 1;
            result[index++] = (device << 8) + (subdevice != -1 ? subdevice : 255 - device);
            result[index++] = (command << 8) + (255 - command);
            return result;
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            IrSignal irSignal = null;
            if (args.length == 1) {
                irSignal = Pronto.ccfSignal(args[0]);
            } else if (args[0].equals("-s")) {
                int index = 1;
                String protocol = args[index++];
                int device = Integer.parseInt(args[index++]);
                int subdevice = Integer.parseInt(args[index++]);
                int command = Integer.parseInt(args[index++]);
                System.out.println(Pronto.shortCCFString(protocol, device, subdevice, command));
                System.exit(0);
            } else {
                int[] ccf = new int[args.length];
                for (int i = 0; i < args.length; ++i) {
                    ccf[i] = Integer.parseInt(args[i], 16);
                }
                irSignal = Pronto.ccfSignal(ccf);
            }
            System.out.println(irSignal);
        }
        catch (IrpMasterException ex) {
            System.err.println(ex.getMessage());
        }
    }
}

