/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.IrpMaster;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.DOTTreeGenerator;
import org.antlr.stringtemplate.StringTemplate;
import org.harctoolbox.IrpMaster.ASTTraverser;
import org.harctoolbox.IrpMaster.BitDirection;
import org.harctoolbox.IrpMaster.Debug;
import org.harctoolbox.IrpMaster.DomainViolationException;
import org.harctoolbox.IrpMaster.GeneralSpec;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.InvalidRepeatException;
import org.harctoolbox.IrpMaster.IrSequence;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.IrpLexer;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.IrpMaster.IrpParser;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.IrpMaster.NameEngine;
import org.harctoolbox.IrpMaster.ParameterSpec;
import org.harctoolbox.IrpMaster.ParameterSpecs;
import org.harctoolbox.IrpMaster.ParseException;
import org.harctoolbox.IrpMaster.Pass;
import org.harctoolbox.IrpMaster.PrimaryIrStream;
import org.harctoolbox.IrpMaster.UnassignedException;
import org.harctoolbox.IrpMaster.UserComm;
import org.harctoolbox.IrpMaster.XmlExport;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Protocol {
    private String name;
    private String documentation;
    private String irpString;
    private CommonTree AST;
    private GeneralSpec generalSpec;
    private NameEngine nameEngine;
    private ParameterSpecs parameterSpecs;
    private CommonTree topBitspecIrsteam;
    private CommonTokenStream tokens;
    private boolean virgin = true;
    private int count = 0;
    private Document doc = null;
    private Element root = null;
    private Element currentElement = null;

    public long evaluateName(String name) throws UnassignedException, DomainViolationException {
        long result;
        Debug.debugNameEngine("evaluateName(" + name + ") called");
        CommonTree tree = this.nameEngine.get(name);
        if (tree == null) {
            throw new UnassignedException("Name `" + name + "' not assigned.");
        }
        try {
            result = ASTTraverser.expression(this, tree);
            Debug.debugExpressions("finished evaluating `" + name + "' = " + result + " without exceptions");
        }
        catch (StackOverflowError ex) {
            throw new UnassignedException("Name `" + name + "' appears to be recursively defined; stack overflow catched.");
        }
        return result;
    }

    public long evaluateName(String name, long dflt) {
        try {
            return this.evaluateName(name);
        }
        catch (DomainViolationException | UnassignedException ex) {
            return dflt;
        }
    }

    public long tryEvaluateName(String name) {
        try {
            return this.evaluateName(name);
        }
        catch (UnassignedException ex) {
            System.err.println("Variablename " + name + " not currently assigned.");
            return 0L;
        }
        catch (DomainViolationException ex) {
            System.err.println(ex.getMessage());
            return 0L;
        }
    }

    public void assign(String name, long value) {
        this.nameEngine.assign(name, value);
    }

    public void assign(String str) throws IncompatibleArgumentException {
        String s = str.trim();
        if (s.startsWith("{")) {
            this.nameEngine.readDefinitions(s);
        } else {
            String[] kw = s.split("=");
            if (kw.length != 2) {
                throw new IncompatibleArgumentException("Invalid assignment: " + s);
            }
            this.assign(kw[0], IrpUtils.parseLong(kw[1], false));
        }
    }

    public void assign(String[] args, int skip) throws IncompatibleArgumentException {
        for (int i = skip; i < args.length; ++i) {
            this.assign(args[i]);
        }
    }

    public BitDirection getBitDirection() {
        return this.generalSpec.getBitDirection();
    }

    public double getFrequency() {
        return this.generalSpec.getFrequency();
    }

    public double getUnit() {
        return this.generalSpec.getUnit();
    }

    public double getDutyCycle() {
        return this.generalSpec.getDutyCycle();
    }

    public long getParameterMin(String name) throws UnassignedException {
        ParameterSpec ps = this.parameterSpecs.getParameterSpec(name);
        if (ps == null) {
            throw new UnassignedException("Parameter " + name + " not assigned.");
        }
        return ps.getMin();
    }

    public long getParameterMax(String name) throws UnassignedException {
        ParameterSpec ps = this.parameterSpecs.getParameterSpec(name);
        if (ps == null) {
            throw new UnassignedException("Parameter " + name + " not assigned.");
        }
        return ps.getMax();
    }

    public boolean hasParameter(String name) {
        return this.parameterSpecs.getNames().contains(name);
    }

    public Set<String> getParameterNames() {
        return this.parameterSpecs.getNames();
    }

    public boolean hasParameterMemory(String name) throws UnassignedException {
        ParameterSpec parameterSpec = this.parameterSpecs.getParameterSpec(name);
        if (parameterSpec == null) {
            throw new UnassignedException("Parameter " + name + " not assigned.");
        }
        return parameterSpec.hasMemory();
    }

    public boolean hasAdvancedParameters() {
        for (String param : this.parameterSpecs.getNames()) {
            if (param.equals("F") || param.equals("D") || param.equals("S") || param.equals("T")) continue;
            return true;
        }
        return false;
    }

    public String getIrp() {
        return this.irpString;
    }

    public long getParameterDefault(String name, HashMap<String, Long> actualParameters) throws UnassignedException, DomainViolationException {
        ParameterSpec ps = this.parameterSpecs.getParameterSpec(name);
        if (ps == null) {
            throw new UnassignedException("Parameter " + name + " not assigned.");
        }
        CommonTree t = ps.getDefault();
        if (t == null) {
            return -1L;
        }
        Protocol newProtocol = new Protocol();
        try {
            newProtocol.nameEngine.loadActualParameters(actualParameters, this.parameterSpecs);
        }
        catch (DomainViolationException ex) {
            System.err.println(ex.getMessage());
        }
        return ASTTraverser.expression(newProtocol, t);
    }

    public boolean hasParameterDefault(String name) {
        ParameterSpec ps = this.parameterSpecs.getParameterSpec(name);
        return ps != null && ps.getDefault() != null;
    }

    public Protocol(GeneralSpec generalSpec) {
        if (generalSpec == null) {
            throw new RuntimeException("empty generalSpec");
        }
        this.generalSpec = generalSpec;
        this.nameEngine = new NameEngine();
    }

    public Protocol() {
        this(new GeneralSpec());
    }

    public Protocol(String name, String irpString, String documentation) throws UnassignedException, ParseException {
        IrpParser.protocol_return r;
        this.name = name;
        this.documentation = documentation;
        this.irpString = irpString;
        this.nameEngine = new NameEngine();
        IrpLexer lex = new IrpLexer(new ANTLRStringStream(irpString));
        this.tokens = new CommonTokenStream(lex);
        IrpParser parser = new IrpParser(this.tokens);
        try {
            r = parser.protocol();
        }
        catch (RecognitionException ex) {
            throw new ParseException(ex);
        }
        this.AST = r.getTree();
        block14: for (int i = 0; i < this.AST.getChildCount(); ++i) {
            CommonTree ch = (CommonTree)this.AST.getChild(i);
            switch (ch.getText()) {
                case "GENERALSPEC": {
                    this.generalSpec = new GeneralSpec(ch);
                    continue block14;
                }
                case "PARAMETER_SPECS": {
                    this.parameterSpecs = new ParameterSpecs(ch);
                    continue block14;
                }
                case "BITSPEC_IRSTREAM": {
                    this.topBitspecIrsteam = ch;
                    continue block14;
                }
                case "DEFINITIONS": {
                    continue block14;
                }
                default: {
                    throw new RuntimeException("This cannot happen");
                }
            }
        }
        if (this.parameterSpecs == null) {
            UserComm.warning("Parameter specs are missing from protocol. Runtime errors due to unassigned variables are possile. Also silent truncation of parameters can occur. Further messages on parameters will be suppressed.");
            this.parameterSpecs = new ParameterSpecs();
        }
        if (this.generalSpec == null) {
            throw new UnassignedException("GeneralSpec missing from protocol");
        }
        Debug.debugIrpParser("GeneralSpec: " + this.generalSpec);
        Debug.debugIrpParser("nameEngine: " + this.nameEngine);
        Debug.debugIrpParser("parameterSpec: " + this.parameterSpecs);
    }

    public String nameEngineString() {
        return this.nameEngine.toString();
    }

    public String notationString(String equals, String separator) {
        return this.nameEngine.notationString(equals, separator);
    }

    public String toString() {
        return this.name + ": " + this.AST.toStringTree();
    }

    public String toDOT() {
        StringTemplate st = new DOTTreeGenerator().toDOT(this.AST);
        return st.toString();
    }

    public void setupDOM() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.doc = builder.newDocument();
        }
        catch (ParserConfigurationException ex) {
            System.err.println(ex.getMessage());
        }
        this.root = this.doc.createElement("protocol");
        this.root.setAttribute("name", this.name);
        this.doc.appendChild(this.root);
        this.root.setAttribute("frequency", Long.toString(Math.round(this.generalSpec.getFrequency())));
        if (this.generalSpec.getDutyCycle() > 0.0) {
            this.root.setAttribute("dutycycle", Double.toString(this.generalSpec.getDutyCycle()));
        }
    }

    public void addSignal(HashMap<String, Long> actualParameters) {
        Element el = this.doc.createElement("signal");
        for (Map.Entry<String, Long> entry : actualParameters.entrySet()) {
            el.setAttribute(entry.getKey(), Long.toString(entry.getValue()));
        }
        this.root.appendChild(el);
        this.currentElement = el;
    }

    public void addXmlNode(String gid, String content) {
        Element el = this.doc.createElement(gid);
        el.setTextContent(content);
        this.currentElement.appendChild(el);
    }

    public void addRawSignalRepresentation(IrSignal irSignal) {
        Element raw_el = this.doc.createElement("raw");
        this.currentElement.appendChild(raw_el);
        this.insertXMLNode(raw_el, irSignal, Pass.intro);
        this.insertXMLNode(raw_el, irSignal, Pass.repeat);
        this.insertXMLNode(raw_el, irSignal, Pass.ending);
    }

    private void insertXMLNode(Element parent, IrSignal irSignal, Pass pass) {
        if (irSignal.getLength(pass) > 0) {
            Element el = this.doc.createElement(pass.name());
            parent.appendChild(el);
            for (int i = 0; i < irSignal.getLength(pass); ++i) {
                double time = irSignal.getDouble(pass, i);
                Element duration = this.doc.createElement(time > 0.0 ? "flash" : "gap");
                duration.setTextContent(Long.toString(Math.round(Math.abs(time))));
                el.appendChild(duration);
            }
        }
    }

    public void printDOM(OutputStream ostream) {
        new XmlExport(this.doc).printDOM(ostream, null);
    }

    public void printDOM(OutputStream ostream, Document stylesheet) {
        new XmlExport(this.doc).printDOM(ostream, stylesheet);
    }

    public Document toDOM() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        Document doc = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.newDocument();
        }
        catch (ParserConfigurationException ex) {
            System.err.println(ex.getMessage());
            return null;
        }
        Element root = doc.createElement("PROTOCOL");
        root.setAttribute("name", this.name);
        doc.appendChild(root);
        if (this.documentation != null) {
            Element docu = doc.createElement("DOCUMENTATION");
            docu.appendChild(doc.createCDATASection(this.documentation));
            root.appendChild(docu);
        }
        CommonTree t = this.AST;
        Element parent = root;
        this.parseTree(doc, t, parent);
        return doc;
    }

    private void parseTree(Document doc, CommonTree t, Element parent) {
        this.parseTree(doc, t, parent, 0);
    }

    private void parseTree(Document doc, CommonTree t, Element parent, int ignore) {
        for (int i = ignore; i < t.getChildCount(); ++i) {
            CommonTree child = (CommonTree)t.getChild(i);
            String label = child.getText();
            if ("+-*/%?".contains(label) || label.equals("**")) {
                label = "OPERATOR";
            }
            Element e = null;
            boolean isInteger = false;
            try {
                Integer.parseInt(label);
                isInteger = true;
            }
            catch (NumberFormatException ex) {
                isInteger = false;
            }
            if (isInteger) {
                e = doc.createElement("INT");
                e.setAttribute("value", label);
                parent.appendChild(e);
                continue;
            }
            if (label.equals("FREQUENCY") || label.equals("DUTYCYCLE") || label.equals("FLASH") || label.equals("GAP") || label.equals("EXTENT") || label.equals("UNIT")) {
                e = doc.createElement(label);
                parent.appendChild(e);
                if (child.getChild(0).getText().equals("FLOAT")) {
                    CommonTree val = (CommonTree)child.getChild(0);
                    e.setAttribute("value", val.getChild(0).getText() + "." + val.getChild(1).getText());
                } else {
                    e.setAttribute("value", child.getChild(0).getText());
                }
                if (child.getChildCount() < 2) continue;
                e.setAttribute("unit", child.getChild(1).getText());
                continue;
            }
            if (label.equals("PARAMETER_SPEC") || label.equals("PARAMETER_SPEC_MEMORY")) {
                e = doc.createElement(label);
                parent.appendChild(e);
                e.setAttribute("name", child.getChild(0).getText());
                e.setAttribute("min", child.getChild(1).getText());
                e.setAttribute("max", child.getChild(2).getText());
                if (child.getChildCount() < 4) continue;
                this.parseTree(doc, child, e, 3);
                continue;
            }
            if (label.equals("ASSIGNMENT")) {
                e = doc.createElement(label);
                parent.appendChild(e);
                e.setAttribute("name", child.getChild(0).getText());
                this.parseTree(doc, child, e, 1);
                continue;
            }
            if (label.equals("BITDIRECTION")) {
                e = doc.createElement(label);
                parent.appendChild(e);
                e.setAttribute("dir", child.getChild(0).getText());
                continue;
            }
            if (label.equals("REPEAT_MARKER")) {
                e = doc.createElement(label);
                parent.appendChild(e);
                e.setAttribute("type", child.getChild(0).getText());
                continue;
            }
            if (label.equals("OPERATOR")) {
                e = doc.createElement(label);
                e.setAttribute("type", child.getText());
                parent.appendChild(e);
                this.parseTree(doc, child, e);
                continue;
            }
            if (label.equals("PARAMETER_SPECS") || label.equals("GENERALSPEC") || label.equals("DEFINITIONS") || label.equals("DEFINITION") || label.equals("IRSTREAM") || label.equals("BARE_IRSTREAM") || label.equals("COMPLEMENT") || label.equals("BITFIELD") || label.equals("BITSPEC_IRSTREAM") || label.equals("BITSPEC")) {
                e = doc.createElement(label);
                parent.appendChild(e);
                this.parseTree(doc, child, e);
                continue;
            }
            e = doc.createElement("NAME");
            e.setAttribute("label", label);
            parent.appendChild(e);
            this.parseTree(doc, child, e);
        }
    }

    public void interactiveRender(UserComm userComm, LinkedHashMap actualVars) {
        int passNo = 0;
        boolean initial = true;
        boolean done = false;
        boolean finalState = false;
        userComm.printMsg(this.irpString);
        block9: while (!done) {
            try {
                PrimaryIrStream irStream = this.process(actualVars, passNo, true, initial);
                initial = false;
                finalState = false;
                userComm.printMsg(irStream.toString());
                userComm.printMsg(this.nameEngine.toString());
                if ((long)passNo == this.evaluateName("$final_state", -1L)) {
                    userComm.printMsg("Final state reached");
                    finalState = true;
                }
                String line = userComm.getLine("Enter one of `arsiq' for advance, repeat, start, initialize, quit >");
                switch (line.charAt(0)) {
                    case 'a': {
                        passNo = finalState ? 0 : passNo + 1;
                        continue block9;
                    }
                    case 'i': {
                        passNo = 0;
                        initial = true;
                        continue block9;
                    }
                    case 'q': {
                        done = true;
                        continue block9;
                    }
                    case 'r': {
                        continue block9;
                    }
                    case 's': {
                        passNo = 0;
                        continue block9;
                    }
                }
                userComm.errorMsg("Unknown command: " + line);
                done = true;
            }
            catch (IOException | IrpMasterException ex) {
                userComm.errorMsg(ex.getMessage());
                done = true;
            }
        }
    }

    public PrimaryIrStream process(HashMap<String, Long> actualVars, int passNo, boolean considerRepeatMin) throws DomainViolationException, UnassignedException, IncompatibleArgumentException, InvalidRepeatException {
        return this.process(actualVars, passNo, considerRepeatMin, this.virgin);
    }

    public PrimaryIrStream process(HashMap<String, Long> actualVars, Pass pass, boolean considerRepeatMin) throws DomainViolationException, UnassignedException, IncompatibleArgumentException, InvalidRepeatException {
        return this.process(actualVars, pass.toInt(), considerRepeatMin, this.virgin);
    }

    public PrimaryIrStream process(HashMap<String, Long> actualVars, int passNo, boolean considerRepeatMin, boolean initial) throws DomainViolationException, UnassignedException, IncompatibleArgumentException, InvalidRepeatException {
        for (int i = 0; i < this.AST.getChildCount(); ++i) {
            CommonTree ch = (CommonTree)this.AST.getChild(i);
            if (!ch.getText().equals("DEFINITIONS")) continue;
            this.nameEngine.readDefinitions(ch);
        }
        Debug.debugNameEngine(this.nameEngine.toString());
        Debug.debugParameters(this.parameterSpecs.toString());
        if (initial) {
            this.count = 0;
        }
        this.nameEngine.assign("$count", this.count);
        this.nameEngine.loadDefaults(this.parameterSpecs, initial);
        Debug.debugNameEngine(this.nameEngine.toString());
        Debug.debugParameters(actualVars.toString());
        this.nameEngine.loadActualParameters(actualVars, this.parameterSpecs);
        Debug.debugNameEngine(this.nameEngine.toString());
        this.nameEngine.checkAssignments(this.parameterSpecs);
        PrimaryIrStream irStream = ASTTraverser.bitspec_irstream(passNo, considerRepeatMin, this, this.topBitspecIrsteam);
        irStream.assignBitSpecs();
        ++this.count;
        this.nameEngine.assign("$count", this.count);
        Debug.debugASTParser("finished parsing AST without exceptions.");
        Debug.debugNameEngine(this.nameEngine.toString());
        Debug.debugIrStreams("ProcessAST: " + irStream);
        this.virgin = false;
        return irStream;
    }

    public IrSequence render(HashMap<String, Long> actualVars, int pass, boolean considerRepeatMins, boolean initialize) throws IncompatibleArgumentException, UnassignedException, DomainViolationException, InvalidRepeatException {
        PrimaryIrStream irStream = this.process(actualVars, pass, considerRepeatMins, initialize);
        return new IrSequence(irStream);
    }

    public IrSequence render(HashMap<String, Long> actualVars, Pass pass, boolean considerRepeatMins, boolean initialize) throws IncompatibleArgumentException, UnassignedException, DomainViolationException, InvalidRepeatException {
        PrimaryIrStream irStream = this.process(actualVars, pass.toInt(), considerRepeatMins, initialize);
        return new IrSequence(irStream);
    }

    public IrSignal renderIrSignal(HashMap<String, Long> actualVars, int pass, boolean considerRepeatMins) throws DomainViolationException, UnassignedException, IncompatibleArgumentException, InvalidRepeatException {
        this.virgin = true;
        IrSequence intro = pass == Pass.intro.toInt() || (long)pass == -2L ? this.render(actualVars, Pass.intro, considerRepeatMins, true) : null;
        IrSequence repeat = pass == Pass.repeat.toInt() || (long)pass == -2L ? this.render(actualVars, Pass.repeat, false, false) : null;
        IrSequence ending = pass == Pass.ending.toInt() || (long)pass == -2L ? this.render(actualVars, Pass.ending, false, false) : null;
        return new IrSignal(this.getFrequency(), this.getDutyCycle(), intro, repeat, ending);
    }

    public IrSignal renderIrSignal(HashMap<String, Long> actualVars, int pass) throws DomainViolationException, UnassignedException, IncompatibleArgumentException, InvalidRepeatException {
        return this.renderIrSignal(actualVars, pass, true);
    }

    public IrSignal renderIrSignal(HashMap<String, Long> actualVars) throws DomainViolationException, UnassignedException, IncompatibleArgumentException, InvalidRepeatException {
        return this.renderIrSignal(actualVars, -2);
    }

    public IrSignal renderIrSignal(HashMap<String, Long> actualVars, boolean considerRepeatMins) throws DomainViolationException, UnassignedException, IncompatibleArgumentException, InvalidRepeatException {
        return this.renderIrSignal(actualVars, -2, considerRepeatMins);
    }

    private static void assignIfValid(HashMap<String, Long> actualVars, String name, long value) {
        if (value != -1L) {
            actualVars.put(name, value);
        }
    }

    public IrSignal renderIrSignal(long device, long subdevice, long function) throws DomainViolationException, UnassignedException, IncompatibleArgumentException, InvalidRepeatException {
        return this.renderIrSignal(device, subdevice, function, -1L);
    }

    public IrSignal renderIrSignal(long device, long subdevice, long function, long toggle) throws DomainViolationException, UnassignedException, IncompatibleArgumentException, InvalidRepeatException {
        HashMap<String, Long> actualVars = new HashMap<String, Long>(3);
        Protocol.assignIfValid(actualVars, "D", device);
        Protocol.assignIfValid(actualVars, "S", subdevice);
        Protocol.assignIfValid(actualVars, "F", function);
        Protocol.assignIfValid(actualVars, "T", toggle);
        return this.renderIrSignal(actualVars);
    }

    public IrSignal renderIrSignal(int device, int subdevice, int function) throws DomainViolationException, UnassignedException, IncompatibleArgumentException, InvalidRepeatException {
        return this.renderIrSignal((long)device, (long)subdevice, (long)function);
    }

    public IrSequence tryRender(HashMap<String, Long> ivs, int pass, boolean considerRepeatMins, boolean initialize) {
        boolean success = false;
        IrSequence irSequence = null;
        try {
            irSequence = this.render(ivs, pass, considerRepeatMins, initialize);
        }
        catch (IrpMasterException ex) {
            System.err.println(ex.getMessage());
        }
        return irSequence;
    }

    public IrSequence tryRender(HashMap<String, Long> ivs, int pass, boolean considerRepeatMins) {
        return this.tryRender(ivs, pass, considerRepeatMins, this.virgin);
    }

    public static HashMap<String, Long> parseParams(String additionalParams) {
        HashMap<String, Long> params = new HashMap<String, Long>();
        String[] arr = additionalParams.split("[,=\\s;]+");
        for (int i = 0; i < arr.length / 2; ++i) {
            params.put(arr[2 * i], IrpUtils.parseLong(arr[2 * i + 1], false));
        }
        return params;
    }

    public static HashMap<String, Long> parseParams(int D, int S, int F, int T, String additionalParams) {
        HashMap<String, Long> params = Protocol.parseParams(additionalParams);
        Protocol.assignIfValid(params, "D", D);
        Protocol.assignIfValid(params, "S", S);
        Protocol.assignIfValid(params, "F", F);
        Protocol.assignIfValid(params, "T", T);
        return params;
    }

    public static HashMap<String, Long> parseParams(String[] args, int skip) throws IncompatibleArgumentException {
        return args[skip].contains("=") ? Protocol.parseNamedProtocolArgs(args, skip) : Protocol.parsePositionalProtocolArgs(args, skip);
    }

    private static HashMap<String, Long> parseNamedProtocolArgs(String[] args, int skip) throws IncompatibleArgumentException {
        HashMap<String, Long> params = new HashMap<String, Long>();
        for (int i = skip; i < args.length; ++i) {
            String[] str = args[i].split("=");
            if (str.length != 2) {
                throw new IncompatibleArgumentException("`" + args[i] + "' is not a parameter assignment");
            }
            String name = str[0].trim();
            long value = Long.parseLong(str[1]);
            params.put(name, value);
        }
        return params;
    }

    private static HashMap<String, Long> parsePositionalProtocolArgs(String[] args, int skip) throws IncompatibleArgumentException {
        LinkedHashMap<String, Long> params = new LinkedHashMap<String, Long>();
        int index = skip;
        switch (args.length - skip) {
            case 4: {
                params.put("D", Long.parseLong(args[index++]));
                params.put("S", Long.parseLong(args[index++]));
                params.put("F", Long.parseLong(args[index++]));
                params.put("T", Long.parseLong(args[index]));
                break;
            }
            case 3: {
                params.put("D", Long.parseLong(args[index++]));
                params.put("S", Long.parseLong(args[index++]));
                params.put("F", Long.parseLong(args[index]));
                break;
            }
            case 2: {
                params.put("D", Long.parseLong(args[index++]));
                params.put("F", Long.parseLong(args[index]));
                break;
            }
            case 1: {
                params.put("F", Long.parseLong(args[index]));
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new IncompatibleArgumentException("Too many parameters");
            }
        }
        return params;
    }
}

