/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.IrpMaster;

import org.harctoolbox.IrpMaster.Cleaner;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.IrSequence;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.ModulatedIrSequence;

public class RepeatFinder {
    private static double defaultMinRepeatLastGap = 20000.0;
    private static double defaultRelativeTolerance = 0.2;
    private static double defaultAbsoluteTolerance = 60.0;
    private double relativeTolerance;
    private double absoluteTolerance;
    private double minRepeatLastGap;
    private IrSequence irSequence;
    private RepeatFinderData repeatFinderData;

    public static double getDefaultMinRepeatLastGap() {
        return defaultMinRepeatLastGap;
    }

    public static void setDefaultMinRepeatLastGap(double aDefaultMinRepeatLastGap) {
        defaultMinRepeatLastGap = aDefaultMinRepeatLastGap;
    }

    public static double getDefaultRelativeTolerance() {
        return defaultRelativeTolerance;
    }

    public static void setDefaultRelativeTolerance(double aDefaultRelativeTolerance) {
        defaultRelativeTolerance = aDefaultRelativeTolerance;
    }

    public static double getDefaultAbsoluteTolerance() {
        return defaultAbsoluteTolerance;
    }

    public static void setDefaultAbsoluteTolerance(double aDefaultAbsoluteTolerance) {
        defaultAbsoluteTolerance = aDefaultAbsoluteTolerance;
    }

    public RepeatFinder(IrSequence irSequence, double absoluteTolerance, double relativeTolerance) {
        this.absoluteTolerance = absoluteTolerance;
        this.relativeTolerance = relativeTolerance;
        this.minRepeatLastGap = defaultMinRepeatLastGap;
        this.irSequence = irSequence;
        this.analyze();
    }

    public RepeatFinder(IrSequence irSequence) {
        this(irSequence, defaultAbsoluteTolerance, defaultRelativeTolerance);
    }

    public static IrSignal findRepeat(ModulatedIrSequence irSequence, double absoluteTolerance, double relativeTolerance) {
        RepeatFinder repeatFinder = new RepeatFinder(irSequence, absoluteTolerance, relativeTolerance);
        return repeatFinder.toIrSignal(irSequence);
    }

    public static IrSignal findRepeat(ModulatedIrSequence irSequence) {
        return RepeatFinder.findRepeat(irSequence, defaultAbsoluteTolerance, defaultRelativeTolerance);
    }

    public static IrSignal findRepeatClean(ModulatedIrSequence irSequence, double absoluteTolerance, double relativeTolerance) {
        RepeatFinder repeatFinder = new RepeatFinder(irSequence, absoluteTolerance, relativeTolerance);
        return repeatFinder.toIrSignalClean(irSequence);
    }

    public static IrSignal findRepeatClean(ModulatedIrSequence irSequence) {
        return RepeatFinder.findRepeatClean(irSequence, defaultAbsoluteTolerance, defaultRelativeTolerance);
    }

    private void analyze() {
        RepeatFinderData candidate = new RepeatFinderData();
        for (int length = this.irSequence.getNumberBursts() / 2; length >= 2; --length) {
            for (int beginning = 0; beginning < this.irSequence.getNumberBursts() - length; ++beginning) {
                RepeatFinderData newCandidate = this.countRepeats(2 * beginning, 2 * length);
                if (newCandidate.numberRepeats <= 1 || !(newCandidate.lastGap > this.minRepeatLastGap) || !(newCandidate.repeatsDuration > candidate.repeatsDuration - 0.1)) continue;
                candidate = newCandidate;
            }
        }
        this.repeatFinderData = candidate;
    }

    private RepeatFinderData countRepeats(int beginning, int length) {
        RepeatFinderData result = new RepeatFinderData(beginning, length, 0, 0);
        result.lastGap = Math.abs(this.irSequence.get(beginning + length - 1));
        if (result.lastGap < this.minRepeatLastGap) {
            return result;
        }
        int hits = 1;
        while (true) {
            boolean hit;
            if (!(hit = this.compareSubSequences(beginning, beginning + hits * length, length))) {
                result.numberRepeats = hits;
                result.endingLength = this.irSequence.getLength() - beginning - hits * length;
                result.repeatsDuration = this.irSequence.getDuration(beginning, hits * length);
                return result;
            }
            ++hits;
        }
    }

    private boolean compareSubSequences(int beginning, int compareStart, int length) {
        if (compareStart + length > this.irSequence.getLength()) {
            return false;
        }
        return this.irSequence.isEqual(beginning, compareStart, length, this.absoluteTolerance, this.relativeTolerance, this.minRepeatLastGap);
    }

    public double getRelativeTolerance() {
        return this.relativeTolerance;
    }

    public double getAbsoluteTolerance() {
        return this.absoluteTolerance;
    }

    public IrSequence getIrSequence() {
        return this.irSequence;
    }

    public IrSignal toIrSignal(ModulatedIrSequence irSequence) {
        return this.repeatFinderData.chopIrSequence(irSequence);
    }

    public IrSignal toIrSignalClean(ModulatedIrSequence irSequence) {
        return this.repeatFinderData.chopIrSequence(Cleaner.clean(irSequence, (int)this.absoluteTolerance, this.relativeTolerance));
    }

    public RepeatFinderData getRepeatFinderData() {
        return this.repeatFinderData;
    }

    public static class RepeatFinderData {
        private int beginLength;
        private int repeatLength;
        private int numberRepeats;
        private int endingLength;
        private double lastGap;
        private double repeatsDuration;

        private RepeatFinderData() {
            this(0, 0, 0, 0);
        }

        public RepeatFinderData(int beginLength, int repeatLength, int numberRepeats, int endingLength) {
            if (beginLength % 2 != 0 || repeatLength % 2 != 0 || endingLength % 2 != 0) {
                throw new IllegalArgumentException("Lengths and start must be even");
            }
            this.beginLength = beginLength;
            this.repeatLength = repeatLength;
            this.numberRepeats = numberRepeats;
            this.endingLength = endingLength;
            this.lastGap = 0.0;
            this.repeatsDuration = 0.0;
        }

        public String toString() {
            return "beginLength = " + this.beginLength + "; repeatLength = " + this.repeatLength + "; numberRepeats = " + this.numberRepeats + "; endingLength = " + this.endingLength + "; repeatsDuration = " + this.repeatsDuration;
        }

        public int getBeginLength() {
            return this.beginLength;
        }

        public int getNumberRepeats() {
            return this.numberRepeats;
        }

        public int getRepeatLength() {
            return this.repeatLength;
        }

        public int getEndingLength() {
            return this.endingLength;
        }

        public IrSignal chopIrSequence(ModulatedIrSequence irSequence) {
            try {
                return this.numberRepeats > 1 ? irSequence.toIrSignal(this.beginLength, this.repeatLength, this.numberRepeats) : irSequence.toIrSignal();
            }
            catch (IncompatibleArgumentException ex) {
                throw new InternalError();
            }
        }
    }
}

