/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.IrpMaster;

public class RepeatMarker {
    int min = 1;
    int max = 1;

    public RepeatMarker(String s) {
        String str = s.trim();
        if (str.isEmpty()) {
            this.min = 1;
            this.max = 1;
        } else if (str.charAt(0) == '*') {
            this.min = 0;
            this.max = Integer.MAX_VALUE;
        } else if (str.charAt(0) == '+') {
            this.min = 1;
            this.max = Integer.MAX_VALUE;
        } else if (str.endsWith("+")) {
            this.min = Integer.parseInt(str.substring(0, str.length() - 1));
            this.max = Integer.MAX_VALUE;
        } else {
            try {
                this.max = this.min = Integer.parseInt(str);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public RepeatMarker(int i) {
        this(i, ' ');
    }

    public RepeatMarker(int i, char c) {
        switch (c) {
            case '*': {
                this.min = 0;
                this.max = Integer.MAX_VALUE;
                break;
            }
            case '+': {
                this.min = i > 0 ? i : 1;
                this.max = Integer.MAX_VALUE;
                break;
            }
            case ' ': {
                this.min = i;
                this.max = i;
                break;
            }
            default: {
                throw new RuntimeException("Invalid alternative in RepeatMarker");
            }
        }
    }

    public RepeatMarker() {
        this.min = 1;
        this.max = 1;
    }

    public RepeatMarker(char ch) {
        this(Character.toString(ch));
    }

    public boolean isInfinite() {
        return this.max == Integer.MAX_VALUE;
    }

    public boolean is(int n) {
        return n == this.min && n == this.max;
    }

    public boolean is(String s) {
        int n;
        try {
            n = Integer.parseInt(s);
            if (n == this.min && n == this.max) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (s.endsWith("+")) {
            try {
                n = Integer.parseInt(s.substring(0, s.length() - 1));
                if (n == this.min && this.max == Integer.MAX_VALUE) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return s.equals("*") ? this.min == 0 && this.max == Integer.MAX_VALUE : (s.equals("+") ? this.min == 1 && this.max == Integer.MAX_VALUE : (s.equals(" ") ? this.min == 1 && this.max != 1 : (s.equals("n") ? this.min == this.max && this.max != Integer.MAX_VALUE : (s.equals("n+") ? this.min != Integer.MAX_VALUE && this.max == Integer.MAX_VALUE : false))));
    }

    public String toString() {
        return this.min == 1 && this.max == 1 ? "" : (this.min == 0 && this.max == Integer.MAX_VALUE ? "*" : (this.min == 1 && this.max == Integer.MAX_VALUE ? "+" : (this.min == this.max ? Integer.toString(this.min) : (this.max == Integer.MAX_VALUE ? Integer.toString(this.min) + "+" : "??"))));
    }

    public static void main(String[] args) {
        System.out.println(new RepeatMarker(""));
        System.out.println(new RepeatMarker('*'));
        System.out.println(new RepeatMarker("*"));
        System.out.println(new RepeatMarker('+'));
        System.out.println(new RepeatMarker("1+"));
        System.out.println(new RepeatMarker("0+"));
        System.out.println(new RepeatMarker("7"));
        System.out.println(new RepeatMarker("7+"));
        System.out.println(new RepeatMarker("\t7+   "));
    }
}

