/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.IrpMaster;

import com.hifiremote.exchangeir.UeiLearned;
import com.hifiremote.exchangeir.UeiLearnedImporter;
import org.harctoolbox.IrpMaster.DecodeIR;
import org.harctoolbox.IrpMaster.IrSequence;
import org.harctoolbox.IrpMaster.IrSignal;

public class UeiLearnedSignal {
    private static final int errLimit = 25;

    private UeiLearnedSignal() {
    }

    public static UeiLearned newUeiLearned(IrSignal irSignal) {
        return new UeiLearned(irSignal.toIntArray(), irSignal.getIntroBursts(), irSignal.getRepeatBursts(), irSignal.getEndingBursts(), 1, (int)irSignal.getFrequency(), 25);
    }

    public static IrSignal parseUeiLearned(String str) {
        UeiLearnedImporter importer = new UeiLearnedImporter(str);
        return UeiLearnedSignal.parseUeiLearned(importer);
    }

    public static IrSignal parseUeiLearned(int[] array) {
        UeiLearnedImporter importer = new UeiLearnedImporter(array);
        return UeiLearnedSignal.parseUeiLearned(importer);
    }

    private static IrSignal parseUeiLearned(UeiLearnedImporter importer) {
        int[] data = importer.getSignal();
        IrSignal irSignal = new IrSignal((double)importer.getFrequency(), -1.0, new IrSequence(data, 0, 2 * importer.getNoIntroBursts()), new IrSequence(data, 2 * importer.getNoIntroBursts(), 2 * importer.getNoRepeatBursts()), new IrSequence(data, 2 * (importer.getNoIntroBursts() + importer.getNoRepeatBursts()), 2 * importer.getNoEndingBursts()));
        return irSignal;
    }

    public static void main(String[] args) {
        StringBuilder str = new StringBuilder();
        for (String arg : args) {
            if (str.length() > 0) {
                str.append(" ");
            }
            str.append(arg);
        }
        IrSignal irSignal = UeiLearnedSignal.parseUeiLearned(str.toString());
        System.out.println(irSignal);
        DecodeIR.invoke(irSignal);
    }
}

