/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.IrpMaster;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import org.harctoolbox.IrpMaster.IrpUtils;

public class UserComm
implements Serializable {
    private boolean quiet = false;
    private static UserComm instance = new UserComm();
    private transient PrintStream logfile = null;

    public void setLogfile(PrintStream printStream) {
        this.logfile = printStream;
    }

    public void warningMsg(String msg) {
        if (!this.quiet) {
            System.err.println("WARNING: " + msg);
        }
        if (this.logfile != null) {
            this.logfile.println("WARNING: " + msg);
        }
    }

    public void errorMsg(String msg) {
        System.err.println("ERROR: " + msg);
        if (this.logfile != null) {
            this.logfile.println("ERROR: " + msg);
        }
    }

    public void exceptionMsg(Exception ex) {
        this.errorMsg(ex.getMessage());
    }

    public void debugMsg(String type, String msg) {
        System.out.println("Debug[" + type + "]: " + msg);
    }

    public void printMsg(String msg) {
        System.out.println(msg);
    }

    public String getLine(String prompt) throws IOException {
        if (prompt != null && !prompt.isEmpty()) {
            System.out.print(prompt);
        }
        BufferedReader isr = new BufferedReader(new InputStreamReader(System.in, IrpUtils.dumbCharset));
        return isr.readLine();
    }

    public static void setQuiet(boolean quiet) {
        UserComm.instance.quiet = quiet;
    }

    public static void warning(String msg) {
        instance.warningMsg(msg);
    }

    public static void error(String msg) {
        instance.errorMsg(msg);
    }

    public static void print(String msg) {
        instance.printMsg(msg);
    }

    public static void exception(Exception ex) {
        instance.exceptionMsg(ex);
    }

    public static void setLogging(PrintStream logfile) {
        instance.setLogfile(logfile);
    }

    public static void main(String[] args) {
        try {
            System.out.println(instance.getLine("Enter what you desire>"));
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
    }
}

