/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.IrpMaster;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.harctoolbox.IrpMaster.DecodeIR;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.IrpMaster.ModulatedIrSequence;

public class Wave {
    private static int debug = 0;
    private static int epsilon8Bit = 2;
    private static int epsilon16Bit = 257;
    private static JCommander argumentParser;
    private static CommandLineArgs commandLineArgs;
    private int noFrames = -1;
    private AudioFormat audioFormat;
    private byte[] buf;

    public static SourceDataLine getLine(AudioFormat audioFormat) throws LineUnavailableException {
        SourceDataLine line = AudioSystem.getSourceDataLine(audioFormat);
        line.open(audioFormat);
        return line;
    }

    private static void usage(int exitcode) {
        StringBuilder str = new StringBuilder(256);
        argumentParser.usage(str);
        str.append("\nparameters: <protocol> <deviceno> [<subdevice_no>] commandno [<toggle>]\n   or       <Pronto code>\n   or       <importfile>");
        (exitcode == 0 ? System.out : System.err).println(str);
        System.exit(exitcode);
    }

    public static void main(String[] args) {
        argumentParser = new JCommander(commandLineArgs);
        argumentParser.setProgramName("Wave");
        try {
            argumentParser.parse(args);
        }
        catch (ParameterException ex) {
            System.err.println(ex.getMessage());
            Wave.usage(1);
        }
        if (Wave.commandLineArgs.helpRequensted) {
            Wave.usage(0);
        }
        if (Wave.commandLineArgs.versionRequested) {
            System.out.println("IrpMaster version 1.3");
            System.out.println("JVM: " + System.getProperty("java.vendor") + " " + System.getProperty("java.version") + " " + System.getProperty("os.name") + "-" + System.getProperty("os.arch"));
            System.out.println();
            System.out.println("Copyright (C) 2011, 2012, 2013, 2014, 2015, 2016 Bengt Martensson.\n\nThis program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 3 of the License, or (at your option) any later version.\n\nThis program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.\n\nYou should have received a copy of the GNU General Public License along with this program. If not, see http://www.gnu.org/licenses/.");
            System.exit(0);
        }
        if (Wave.commandLineArgs.macrofile == null && commandLineArgs.parameters.isEmpty()) {
            System.err.println("Parameters missing");
            Wave.usage(1);
        }
        try {
            if (commandLineArgs.parameters.size() == 1) {
                String inputfile = (String)commandLineArgs.parameters.get(0);
                Wave wave = new Wave(new File(inputfile));
                ModulatedIrSequence seq = wave.analyze(!Wave.commandLineArgs.dontDivide);
                DecodeIR.invoke(seq);
                wave.dump(new File(inputfile + ".tsv"));
                if (Wave.commandLineArgs.play) {
                    wave.play();
                }
            } else {
                IrSignal irSignal = new IrSignal(Wave.commandLineArgs.irprotocolsIniFilename, 0, commandLineArgs.parameters.toArray(new String[commandLineArgs.parameters.size()]));
                File file = new File(Wave.commandLineArgs.outputfile);
                Wave wave = new Wave(irSignal.toModulatedIrSequence(true, Wave.commandLineArgs.noRepeats, true), Wave.commandLineArgs.sampleFrequency, Wave.commandLineArgs.sampleSize, Wave.commandLineArgs.stereo ? 2 : 1, false, Wave.commandLineArgs.omitTail, Wave.commandLineArgs.square, !Wave.commandLineArgs.dontDivide);
                wave.export(file);
                if (Wave.commandLineArgs.play) {
                    wave.play();
                }
            }
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException | IrpMasterException ex) {
            System.err.println(ex.getMessage());
            System.exit(3);
        }
    }

    private Wave() {
    }

    public Wave(File file) throws UnsupportedAudioFileException, IOException {
        AudioInputStream af = AudioSystem.getAudioInputStream(file);
        this.audioFormat = af.getFormat();
        this.noFrames = (int)af.getFrameLength();
        this.buf = new byte[this.noFrames * this.audioFormat.getFrameSize()];
        int n = af.read(this.buf, 0, this.buf.length);
        if (n != this.buf.length) {
            System.err.println("Too few bytes read: " + n + " < " + this.buf.length);
        }
    }

    public Wave(double freq, double[] data, int sampleFrequency, int sampleSize, int channels, boolean bigEndian, boolean omitTail, boolean square, boolean divide) throws IncompatibleArgumentException {
        if (data == null || data.length == 0) {
            throw new IncompatibleArgumentException("Cannot create wave file from zero array.");
        }
        double sf = (double)sampleFrequency / 1000000.0;
        int[] durationsInSamplePeriods = new int[omitTail ? data.length - 1 : data.length];
        int length = 0;
        for (int i = 0; i < durationsInSamplePeriods.length; ++i) {
            durationsInSamplePeriods[i] = (int)Math.round(Math.abs(sf * data[i]));
            length += durationsInSamplePeriods[i];
        }
        double c = (double)sampleFrequency / freq;
        this.buf = new byte[length * sampleSize / 8 * channels];
        int index = 0;
        for (int i = 0; i < data.length - 1; i += 2) {
            int j;
            for (j = 0; j < durationsInSamplePeriods[i]; ++j) {
                int val;
                double s;
                double t = (double)j / (divide ? 2.0 * c : c);
                double fraq = t - (double)((int)t);
                double d = square ? (fraq < 0.5 ? -1.0 : 1.0) : (s = Math.sin(Math.PI * 2 * fraq));
                if (sampleSize == 8) {
                    val = (int)Math.round(127.0 * s);
                    this.buf[index++] = (byte)val;
                    if (channels != 2) continue;
                    this.buf[index++] = (byte)(-val);
                    continue;
                }
                val = (int)Math.round(32767.0 * s);
                byte low = (byte)(val & 0xFF);
                byte high = (byte)(val >> 8);
                this.buf[index++] = bigEndian ? high : low;
                byte by = this.buf[index++] = bigEndian ? low : high;
                if (channels != 2) continue;
                val = -val;
                low = (byte)(val & 0xFF);
                high = (byte)(val >> 8);
                this.buf[index++] = bigEndian ? high : low;
                this.buf[index++] = bigEndian ? low : high;
            }
            if (omitTail && i >= data.length - 2) continue;
            for (j = 0; j < durationsInSamplePeriods[i + 1]; ++j) {
                for (int ch = 0; ch < channels; ++ch) {
                    this.buf[index++] = 0;
                    if (sampleSize != 16) continue;
                    this.buf[index++] = 0;
                }
            }
        }
        this.audioFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, sampleFrequency, sampleSize, channels, sampleSize / 8 * channels, sampleFrequency, bigEndian);
    }

    public Wave(ModulatedIrSequence irSequence, int sampleFrequency, int sampleSize, int channels, boolean bigEndian, boolean omitTail, boolean square, boolean divide) throws IncompatibleArgumentException {
        this(irSequence.getFrequency(), irSequence.toDoubles(), sampleFrequency, sampleSize, channels, bigEndian, omitTail, square, divide);
    }

    public Wave(ModulatedIrSequence irSequence, AudioFormat audioFormat, boolean omitTail, boolean square, boolean divide) throws IncompatibleArgumentException {
        this(irSequence, (int)audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.isBigEndian(), omitTail, square, divide);
    }

    private int[][] computeData() {
        int channels = this.audioFormat.getChannels();
        int sampleSize = this.audioFormat.getSampleSizeInBits();
        AudioFormat.Encoding encoding = this.audioFormat.getEncoding();
        boolean bigEndian = this.audioFormat.isBigEndian();
        int[][] data = new int[this.noFrames][channels];
        if (encoding == AudioFormat.Encoding.PCM_UNSIGNED && sampleSize != 8) {
            System.err.println("Case not yet implemented");
            return null;
        }
        for (int frame = 0; frame < this.noFrames; ++frame) {
            int ch;
            if (sampleSize == 8) {
                for (ch = 0; ch < channels; ++ch) {
                    int val = this.buf[channels * frame + ch];
                    if (encoding == AudioFormat.Encoding.PCM_UNSIGNED) {
                        val += val < 0 ? 128 : -128;
                    }
                    data[frame][ch] = val;
                }
                continue;
            }
            for (ch = 0; ch < channels; ++ch) {
                int value;
                int baseIndex = 2 * (channels * frame + ch);
                byte high = this.buf[bigEndian ? baseIndex : baseIndex + 1];
                int low = this.buf[bigEndian ? baseIndex + 1 : baseIndex];
                if (low < 0) {
                    low += 256;
                }
                data[frame][ch] = value = 256 * high + low;
            }
        }
        return data;
    }

    public ModulatedIrSequence analyze(boolean divide) {
        double sampleFrequency = this.audioFormat.getSampleRate();
        int channels = this.audioFormat.getChannels();
        System.err.println("Format is: " + this.audioFormat.toString() + ".");
        System.err.println(String.format("%d frames = %7.6f seconds.", this.noFrames, (double)this.noFrames / sampleFrequency));
        int[][] data = this.computeData();
        if (channels == 2) {
            int noDiffPhase = 0;
            int noDiffAntiphase = 0;
            int noNonNulls = 0;
            for (int i = 0; i < this.noFrames; ++i) {
                if (data[i][0] == 0 && data[i][1] == 0) continue;
                ++noNonNulls;
                if (data[i][0] != data[i][1]) {
                    ++noDiffPhase;
                }
                if (data[i][0] == -data[i][1]) continue;
                ++noDiffAntiphase;
            }
            System.err.println("This is a 2-channel file. Left and right channel are " + (noDiffPhase == 0 ? "perfectly in phase." : (noDiffAntiphase == 0 ? "perfectly in antiphase." : "neither completely in nor out of phase. Pairs in-phase:" + (noNonNulls - noDiffPhase) + ", pairs anti-phase: " + (noNonNulls - noDiffAntiphase) + " (out of " + noNonNulls + ").")));
            System.err.println("Subsequent analysis will be base on the left channel exclusively.");
        }
        ArrayList<Integer> durations = new ArrayList<Integer>(this.noFrames);
        int bestLength = -1;
        int bestStart = -1;
        boolean isInInterestingBlock = true;
        int last = -1111111;
        int epsilon = this.audioFormat.getSampleSizeInBits() == 8 ? epsilon8Bit : epsilon16Bit;
        int firstNonNullIndex = 0;
        while (data[firstNonNullIndex][0] == 0) {
            ++firstNonNullIndex;
        }
        if (firstNonNullIndex > 0) {
            System.err.println("The first " + firstNonNullIndex + " sample(s) are 0, ignored.");
        }
        int beg = firstNonNullIndex;
        for (int i = firstNonNullIndex; i < this.noFrames; ++i) {
            int currentLength;
            int value = data[i][0];
            if ((Math.abs(value) <= epsilon && Math.abs(last) <= epsilon || i == this.noFrames - 1) && isInInterestingBlock) {
                isInInterestingBlock = false;
                currentLength = i - 1 - beg;
                if (currentLength > bestLength) {
                    bestLength = currentLength;
                    bestStart = beg;
                }
                durations.add((int)Math.round((double)currentLength / sampleFrequency * 1000000.0));
                beg = i;
            } else if (Math.abs(value) > epsilon && !isInInterestingBlock) {
                isInInterestingBlock = true;
                currentLength = i - 1 - beg;
                durations.add((int)Math.round((double)currentLength / sampleFrequency * 1000000.0));
                beg = i;
            }
            last = value;
        }
        if (!isInInterestingBlock && this.noFrames - beg > 1) {
            durations.add((int)Math.round((double)(this.noFrames - beg) / sampleFrequency * 1000000.0));
        }
        if (durations.size() % 2 == 1) {
            durations.add(0);
        }
        int signchanges = 0;
        last = 0;
        for (int i = 0; i < bestLength; ++i) {
            int indx = i + bestStart;
            int value = data[indx][0];
            if (value == 0) continue;
            if (value * last < 0) {
                ++signchanges;
            }
            last = value;
        }
        double carrierFrequency = (double)(divide ? 2 : 1) * sampleFrequency * (double)signchanges / (double)(2 * bestLength);
        System.err.println("Carrier frequency estimated to " + Math.round(carrierFrequency) + " Hz.");
        int[] arr = new int[durations.size()];
        int ind = 0;
        for (Integer val : durations) {
            arr[ind++] = val;
            if (debug <= 0) continue;
            System.err.print(val + " ");
        }
        if (debug > 0) {
            System.err.println();
        }
        try {
            return new ModulatedIrSequence(arr, carrierFrequency);
        }
        catch (IncompatibleArgumentException ex) {
            return null;
        }
    }

    public void dump(File dumpfile) throws FileNotFoundException {
        int[][] data = this.computeData();
        double sampleRate = this.audioFormat.getSampleRate();
        int channels = this.audioFormat.getChannels();
        try (PrintStream stream = new PrintStream(dumpfile, "US-ASCII");){
            for (int i = 0; i < this.noFrames; ++i) {
                stream.print(String.format("%d\t%8.6f\t", i, (double)i / sampleRate));
                for (int ch = 0; ch < channels; ++ch) {
                    stream.print(data[i][ch] + (ch < channels - 1 ? "\t" : "\n"));
                }
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new InternalError();
        }
    }

    public void export(File file) {
        ByteArrayInputStream bs = new ByteArrayInputStream(this.buf);
        bs.reset();
        AudioInputStream ais = new AudioInputStream(bs, this.audioFormat, (long)this.buf.length / (long)this.audioFormat.getFrameSize());
        try {
            int result = AudioSystem.write(ais, AudioFileFormat.Type.WAVE, file);
            if (result <= this.buf.length) {
                System.err.println("Wrong number of bytes written: " + result + " < " + this.buf.length);
            }
        }
        catch (IOException e) {
            System.err.println(e.getMessage());
        }
    }

    public void play(SourceDataLine line) throws LineUnavailableException, IOException {
        line.start();
        int bytesWritten = line.write(this.buf, 0, this.buf.length);
        if (bytesWritten != this.buf.length) {
            throw new IOException("Not all bytes written");
        }
        line.drain();
    }

    public void play() throws LineUnavailableException, IOException {
        try (SourceDataLine line = AudioSystem.getSourceDataLine(this.audioFormat);){
            line.open(this.audioFormat);
            this.play(line);
        }
    }

    static {
        commandLineArgs = new CommandLineArgs();
    }

    private static final class CommandLineArgs {
        @Parameter(names={"-1", "--nodivide"}, description="Do not divide modulation frequency")
        boolean dontDivide = false;
        @Parameter(names={"-c", "--config"}, description="Path to IrpProtocols.ini")
        String irprotocolsIniFilename = "data/IrpProtocols.ini";
        @Parameter(names={"-h", "--help", "-?"}, description="Display help message")
        boolean helpRequensted = false;
        @Parameter(names={"-f", "--samplefrequency"}, description="Sample frequency in Hz")
        int sampleFrequency = 44100;
        @Parameter(names={"-m", "--macrofile"}, description="Macro filename")
        String macrofile = null;
        @Parameter(names={"-o", "--outfile"}, description="Output filename")
        String outputfile = "irpmaster.wav";
        @Parameter(names={"-p", "--play"}, description="Send the generated wave to the audio device of the local machine")
        boolean play = false;
        @Parameter(names={"-q", "--square"}, description="Modulate with square wave instead of sine")
        boolean square = false;
        @Parameter(names={"-r", "--repeats"}, description="Number of times to include the repeat sequence")
        int noRepeats = 0;
        @Parameter(names={"-s", "samplesize"}, description="Sample size in bits")
        int sampleSize = 8;
        @Parameter(names={"-S", "--stereo"}, description="Generate two channels in anti-phase")
        boolean stereo = false;
        @Parameter(names={"-t", "--omittail"}, description="Skip silence at end")
        boolean omitTail = false;
        @Parameter(names={"-v", "--version"}, description="Display version information")
        boolean versionRequested;
        @Parameter(description="[parameters]")
        private ArrayList<String> parameters = new ArrayList(64);

        private CommandLineArgs() {
        }
    }
}

