/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.IrpMaster;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.harctoolbox.IrpMaster.DecodeIR;
import org.harctoolbox.IrpMaster.IrSequence;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.Pronto;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlExport {
    public static final String flashTagName = "flash";
    public static final String gapTagName = "gap";
    public static final String decodeTagName = "decode";
    public static final String decodesTagName = "decodes";
    public static final String protocolAttributeName = "protocol";
    public static final String textTagName = "text";
    public static final String prontoTagName = "pronto";
    public static final String introTagName = "intro";
    public static final String repeatTagName = "repeat";
    public static final String endingTagName = "ending";
    public static final String parametersTagName = "parameters";
    public static final String parameterTagName = "parameter";
    public static final String parameterNameAttributeName = "name";
    public static final String parameterValueAttributeName = "value";
    public static final String irSignalTagName = "irsignal";
    public static final String nameAttributeName = "name";
    public static final String frequencyAttributeName = "frequency";
    public static final String dutyCycleAttributeName = "dutycycle";
    public static final String rawTagName = "raw";
    public static final String analyzerTagName = "analyzer";
    public static final String introBurstsLengthName = "nointrobursts";
    public static final String repeatBurstsLengthName = "norepeatbursts";
    public static final String endingBurstsLengthName = "noendingbursts";
    public static final String burstLengthAttributeName = "burstlength";
    public static final String commentAttributeName = "comment";
    private final Document doc;

    public XmlExport(Document doc) {
        this.doc = doc;
    }

    public XmlExport() {
        this.doc = XmlExport.newDocument();
    }

    public static Document newDocument() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        Document doc = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return doc;
    }

    public void printDOM(OutputStream ostr, Document stylesheet) {
        try {
            Transformer tr;
            TransformerFactory factory = TransformerFactory.newInstance();
            if (stylesheet == null) {
                tr = factory.newTransformer();
                tr.setOutputProperty("method", "xml");
            } else {
                tr = factory.newTransformer(new DOMSource(stylesheet));
            }
            tr.setOutputProperty("indent", "yes");
            tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            tr.transform(new DOMSource(this.doc), new StreamResult(ostr));
        }
        catch (TransformerConfigurationException e) {
            System.err.println(e.getMessage());
        }
        catch (TransformerException e) {
            System.err.println(e.getMessage());
        }
    }

    public void printDOM(OutputStream ostr) {
        this.printDOM(ostr, null);
    }

    public void printDOM(File file) throws FileNotFoundException, IOException {
        if (file == null) {
            this.printDOM(System.out);
        } else {
            try (FileOutputStream stream = new FileOutputStream(file);){
                this.printDOM(stream);
                System.err.println("File " + file + " written.");
            }
        }
    }

    public void setRoot(Element el) {
        this.doc.appendChild(el);
    }

    public Element toElement(String s, String tagname) {
        Element el = this.doc.createElement(tagname);
        el.setTextContent(s);
        return el;
    }

    public Element toElement(IrSequence irSequence, String tagname) {
        Element el = this.doc.createElement(tagname);
        el.setAttribute(burstLengthAttributeName, Integer.toString(irSequence.getNumberBursts()));
        for (int i = 0; i < irSequence.getNumberBursts(); ++i) {
            double time = irSequence.get(2 * i);
            el.appendChild(this.toElement(Long.toString(Math.round(Math.abs(time))), flashTagName));
            time = irSequence.get(2 * i + 1);
            el.appendChild(this.toElement(Long.toString(Math.round(Math.abs(time))), gapTagName));
        }
        return el;
    }

    public Element toElement(DecodeIR.DecodedSignal decode) {
        Element el = this.doc.createElement(decodeTagName);
        el.setAttribute(protocolAttributeName, decode.getProtocol());
        el.appendChild(this.toElement(decode.toString(), textTagName));
        Element parametersEl = this.doc.createElement(parametersTagName);
        el.appendChild(parametersEl);
        for (Map.Entry<String, Long> kvp : decode.getParameters().entrySet()) {
            Element paramEl = this.doc.createElement(parameterTagName);
            paramEl.setAttribute("name", kvp.getKey());
            paramEl.setAttribute(parameterValueAttributeName, Long.toString(kvp.getValue()));
            parametersEl.appendChild(paramEl);
        }
        return el;
    }

    public Element toElement(DecodeIR.DecodedSignal[] decodes) {
        if (decodes == null || decodes.length == 0) {
            return null;
        }
        Element el = this.doc.createElement(decodesTagName);
        for (DecodeIR.DecodedSignal decode : decodes) {
            el.appendChild(this.toElement(decode));
        }
        return el;
    }

    public Element toElement(IrSignal irSignal, String name, String comment, DecodeIR.DecodedSignal[] decodes, String analyze) {
        Element el = this.doc.createElement(irSignalTagName);
        el.setAttribute("name", name);
        el.setAttribute(frequencyAttributeName, Long.toString(Math.round(irSignal.getFrequency())));
        el.setAttribute(dutyCycleAttributeName, Double.toString(irSignal.getDutyCycle()));
        el.appendChild(this.toElement(decodes));
        el.appendChild(this.toElement(analyze, analyzerTagName));
        Element rawEl = this.doc.createElement(rawTagName);
        rawEl.setAttribute(introBurstsLengthName, Integer.toString(irSignal.getIntroBursts()));
        rawEl.setAttribute(repeatBurstsLengthName, Integer.toString(irSignal.getRepeatBursts()));
        rawEl.setAttribute(endingBurstsLengthName, Integer.toString(irSignal.getEndingBursts()));
        el.appendChild(rawEl);
        if (irSignal.getIntroLength() > 0) {
            rawEl.appendChild(this.toElement(irSignal.getIntroSequence(), introTagName));
        }
        if (irSignal.getRepeatLength() > 0) {
            rawEl.appendChild(this.toElement(irSignal.getRepeatSequence(), repeatTagName));
        }
        if (irSignal.getEndingLength() > 0) {
            rawEl.appendChild(this.toElement(irSignal.getEndingSequence(), endingTagName));
        }
        Element prontoEl = this.doc.createElement(prontoTagName);
        prontoEl.setTextContent(Pronto.toPrintString(irSignal));
        el.appendChild(prontoEl);
        return el;
    }

    public Element toElement(String protocolName, HashMap<String, Long> parameters, String name, String comment) {
        Element el = this.doc.createElement(irSignalTagName);
        el.setAttribute("name", name);
        el.setAttribute(commentAttributeName, comment);
        el.setAttribute(protocolAttributeName, protocolName);
        Element parametersEl = this.doc.createElement(parametersTagName);
        el.appendChild(parametersEl);
        for (Map.Entry<String, Long> kvp : parameters.entrySet()) {
            Element paramEl = this.doc.createElement(parameterTagName);
            paramEl.setAttribute("name", kvp.getKey());
            paramEl.setAttribute(parameterValueAttributeName, Long.toString(kvp.getValue()));
            parametersEl.appendChild(paramEl);
        }
        return el;
    }
}

