/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.IrpMaster;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlUtils {
    public static Document openXmlFile(File file, Schema schema, boolean isNamespaceAware, boolean isXIncludeAware) throws IOException, SAXParseException, SAXException {
        final String fname = file.getCanonicalPath();
        DocumentBuilder builder = XmlUtils.newDocumentBuilder(schema, isNamespaceAware, isXIncludeAware);
        builder.setErrorHandler(new ErrorHandler(){

            @Override
            public void error(SAXParseException exception) throws SAXParseException {
                throw new SAXParseException("Parse Error in file " + fname + ", line " + exception.getLineNumber() + ": " + exception.getMessage(), "", fname, exception.getLineNumber(), 0);
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXParseException {
                throw new SAXParseException("Parse Error in file " + fname + ", line " + exception.getLineNumber() + ": " + exception.getMessage(), "", fname, exception.getLineNumber(), 0);
            }

            @Override
            public void warning(SAXParseException exception) {
                System.err.println("Parse Warning: " + exception.getMessage() + exception.getLineNumber());
            }
        });
        Document docu = builder.parse(file);
        return docu;
    }

    public static Document openXmlFile(File file, File schemaFile, boolean isNamespaceAware, boolean isXIncludeAware) throws IOException, SAXParseException, SAXException {
        Schema schema = XmlUtils.readSchemaFromFile(schemaFile);
        return XmlUtils.openXmlFile(file, schema, isNamespaceAware, isXIncludeAware);
    }

    public static Document openXmlFile(File file) throws IOException, SAXParseException, SAXException {
        return XmlUtils.openXmlFile(file, (Schema)null, true, true);
    }

    public static Document openXmlReader(Reader reader, Schema schema, boolean isNamespaceAware, boolean isXIncludeAware) throws IOException, SAXParseException, SAXException {
        return XmlUtils.openXmlStream(new InputSource(reader).getByteStream(), schema, isNamespaceAware, isXIncludeAware);
    }

    public static Document openXmlStream(InputStream stream, Schema schema, boolean isNamespaceAware, boolean isXIncludeAware) throws IOException, SAXParseException, SAXException {
        DocumentBuilder builder = XmlUtils.newDocumentBuilder(schema, isNamespaceAware, isXIncludeAware);
        builder.setErrorHandler(new ErrorHandler(){

            @Override
            public void error(SAXParseException exception) throws SAXParseException {
                throw new SAXParseException("Parse Error in instream, line " + exception.getLineNumber() + ": " + exception.getMessage(), "", "instream", exception.getLineNumber(), 0);
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXParseException {
                throw new SAXParseException("Parse Error in instream, line " + exception.getLineNumber() + ": " + exception.getMessage(), "", "instream", exception.getLineNumber(), 0);
            }

            @Override
            public void warning(SAXParseException exception) {
                System.err.println("Parse Warning: " + exception.getMessage() + exception.getLineNumber());
            }
        });
        Document docu = builder.parse(stream);
        return docu;
    }

    private static DocumentBuilder newDocumentBuilder(Schema schema, boolean isNamespaceAware, boolean isXIncludeAware) throws SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(isNamespaceAware);
        factory.setXIncludeAware(isXIncludeAware);
        if (schema != null) {
            factory.setSchema(schema);
            factory.setValidating(false);
        }
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        return builder;
    }

    public static Document newDocument(boolean isNamespaceAware) {
        try {
            DocumentBuilder builder = XmlUtils.newDocumentBuilder(null, isNamespaceAware, false);
            return builder.newDocument();
        }
        catch (SAXException ex) {
            return null;
        }
    }

    public static Document newDocument() {
        return XmlUtils.newDocument(false);
    }

    public static HashMap<String, Element> createIndex(Element root, String tagName, String idName) {
        NodeList nodes = root.getElementsByTagName(tagName);
        HashMap<String, Element> index = new HashMap<String, Element>(nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element el = (Element)nodes.item(i);
            String key = el.getAttribute(idName);
            if (key.isEmpty()) continue;
            index.put(key, el);
        }
        return index;
    }

    public static void printDOM(OutputStream ostr, Document doc, String encoding) {
        try {
            Transformer tr = TransformerFactory.newInstance().newTransformer();
            if (encoding != null) {
                tr.setOutputProperty("encoding", encoding);
            }
            tr.setOutputProperty("indent", "yes");
            tr.setOutputProperty("method", "xml");
            tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            tr.transform(new DOMSource(doc), new StreamResult(ostr));
        }
        catch (TransformerConfigurationException ex) {
            System.err.println(ex.getMessage());
        }
        catch (TransformerException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public static void printDOM(File file, Document doc, String encoding) throws FileNotFoundException {
        XmlUtils.printDOM(file != null ? new FileOutputStream(file) : System.out, doc, encoding);
        System.err.println("File " + file + " written.");
    }

    public static void printDOM(File file, Document doc) throws FileNotFoundException {
        XmlUtils.printDOM(file, doc, null);
    }

    private static Schema readSchemaFromFile(File schemaFile) throws SAXException {
        return SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema").newSchema(schemaFile);
    }

    public static HashMap<String, Element> buildIndex(Element element, String tagName, String idName) {
        NodeList nl = element.getElementsByTagName(tagName);
        HashMap<String, Element> index = new HashMap<String, Element>(nl.getLength());
        for (int i = 0; i < nl.getLength(); ++i) {
            Element el = (Element)nl.item(i);
            String id = el.getAttribute(idName);
            if (id.isEmpty()) continue;
            index.put(id, el);
        }
        return index;
    }

    public static void main(String[] args) {
        try {
            Schema schema = args.length > 1 ? XmlUtils.readSchemaFromFile(new File(args[1])) : null;
            Document doc = XmlUtils.openXmlFile(new File(args[0]), schema, true, true);
            System.out.println(doc);
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
        catch (SAXParseException ex) {
            System.err.println(ex.getMessage());
        }
        catch (SAXException ex) {
            System.err.println(ex.getMessage());
        }
    }

    private XmlUtils() {
    }
}

