/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.devslashlirc;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.harctoolbox.devslashlirc.LircDeviceException;
import org.harctoolbox.devslashlirc.NonExistentTransmitterException;
import org.harctoolbox.devslashlirc.NotSupportedException;

public abstract class LircHardware
implements Closeable {
    public static final String libraryName = "devslashlirc";
    private static boolean libLoaded = false;
    protected long nativePointer;
    protected String deviceName;

    public static void loadLibrary() throws UnsatisfiedLinkError {
        LircHardware.loadLibrary(null);
    }

    public static void loadLibrary(File path) throws UnsatisfiedLinkError {
        if (!libLoaded) {
            if (path != null) {
                File libFile = path.isDirectory() ? new File(path, System.mapLibraryName(libraryName)) : path;
                try {
                    System.load(libFile.getCanonicalPath());
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            } else {
                System.loadLibrary(libraryName);
            }
            libLoaded = true;
        }
    }

    public static boolean isLibraryLoaded() {
        return libLoaded;
    }

    private LircHardware() {
        this.nativePointer = 0L;
    }

    protected LircHardware(String deviceName, long nativePointer) {
        this.nativePointer = nativePointer;
        this.deviceName = deviceName;
    }

    public void open() throws LircDeviceException {
        boolean status = this.openNative();
        if (!status) {
            throw new LircDeviceException("open failed");
        }
    }

    public final void setTransmitterMask(int mask) throws NotSupportedException, NonExistentTransmitterException, LircDeviceException {
        if (!this.canSetTransmitterMask()) {
            throw new NotSupportedException("Setting transmitter mask not supported");
        }
        int noTransmitters = this.getNumberTransmitters();
        if (noTransmitters > 0 && mask >= 1 << noTransmitters) {
            throw new NonExistentTransmitterException("No such transmitter");
        }
        boolean result = this.setTransmitterMaskNative(mask);
        if (!result) {
            throw new LircDeviceException("Error setting transmitters");
        }
    }

    public abstract int getNumberTransmitters();

    protected abstract boolean setTransmitterMaskNative(int var1);

    protected abstract boolean openNative();

    public abstract String getVersion();

    public abstract boolean canSend();

    public abstract boolean canSetTransmitterMask();

    public abstract boolean canRec();

    public abstract void setBeginTimeout(int var1);

    public abstract boolean isValid();

    public abstract String toString();
}

