/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.devslashlirc;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.harctoolbox.devslashlirc.IMode2;
import org.harctoolbox.devslashlirc.LircDevice;
import org.harctoolbox.devslashlirc.LircDeviceException;
import org.harctoolbox.devslashlirc.LircHardware;
import org.harctoolbox.devslashlirc.NotSupportedException;

public class Mode2LircDevice
extends LircDevice
implements IMode2 {
    private static final int defaultCaptureSize = 250;
    private static final int defaultEndTimeout = 200;

    private static native long newMode2LircDevice(String var0);

    private native int getRecResolutionNative();

    private native void setSendCarrierNative(int var1);

    private native void sendNative(int[] var1);

    private native int readNative();

    private native int[] receiveNative();

    public Mode2LircDevice(String deviceName, int beginTimeout, int captureSize, int endTimeout) {
        super(deviceName, beginTimeout, Mode2LircDevice.newMode2LircDevice(deviceName));
        this.setMaxCaptureLength(captureSize);
        this.setEndTimeout(endTimeout);
    }

    public Mode2LircDevice() throws LircDeviceException {
        this("/dev/lirc0", 5000, 250, 200);
    }

    public Mode2LircDevice(String deviceName) throws LircDeviceException {
        this(deviceName, 5000, 250, 200);
    }

    @Override
    protected native boolean openNative();

    @Override
    public native boolean canSetSendCarrier();

    @Override
    public native boolean canGetRecResolution();

    @Override
    public void send(int[] data) throws NotSupportedException {
        if (!this.canSend()) {
            throw new NotSupportedException("Hardware does not support sending");
        }
        this.sendNative(data);
    }

    @Override
    public void send(int[] data, int frequency) throws NotSupportedException {
        this.setSendCarrier(frequency);
        this.send(data);
    }

    @Override
    public int getRecResolution() throws NotSupportedException {
        if (!this.canGetRecResolution()) {
            throw new NotSupportedException("getResoultion not supported by driver");
        }
        return this.getRecResolutionNative();
    }

    @Override
    public void setSendCarrier(int frequency) throws NotSupportedException {
        if (!this.canSetSendCarrier()) {
            throw new NotSupportedException("setSendCarrier not supported by driver");
        }
        this.setSendCarrierNative(frequency);
    }

    public int read() throws NotSupportedException {
        if (!this.canRec()) {
            throw new NotSupportedException("Hardware does not support receiving");
        }
        return this.readNative();
    }

    @Override
    public int[] receive() throws NotSupportedException {
        if (!this.canRec()) {
            throw new NotSupportedException("Hardware does not support receiving");
        }
        return this.receiveNative();
    }

    public native void report();

    @Override
    public final native void setEndTimeout(int var1);

    @Override
    public final native void setMaxCaptureLength(int var1);

    @Override
    public String toString() {
        return "mode2 " + (this.canSetSendCarrier() ? " setCarr." : "") + (this.canGetRecResolution() ? " getRecRes." : "") + super.toString();
    }

    public static void main(String[] args) {
        int nec1_frequency = 38400;
        int[] nec1_122_29 = new int[]{9024, 4512, 564, 564, 564, 1692, 564, 564, 564, 1692, 564, 1692, 564, 1692, 564, 1692, 564, 564, 564, 1692, 564, 564, 564, 1692, 564, 564, 564, 564, 564, 564, 564, 564, 564, 1692, 564, 1692, 564, 564, 564, 1692, 564, 1692, 564, 1692, 564, 564, 564, 564, 564, 564, 564, 564, 564, 1692, 564, 564, 564, 564, 564, 564, 564, 1692, 564, 1692, 564, 1692, 564, 39756};
        LircHardware.loadLibrary();
        try (Mode2LircDevice device = new Mode2LircDevice("/dev/lirc0", 10000, 100, 222);){
            System.out.println(device.getVersion());
            device.open();
            device.report();
            System.out.println(device);
            System.out.println(">>>>>>>>>>>>>>>>>> Now shoot IR!");
            int[] result = device.receive();
            for (int i = 0; i < result.length; ++i) {
                System.out.print((i % 2 == 0 ? "+" : "-") + result[i] + " ");
            }
            System.out.println();
            device.setTransmitterMask(1);
            device.send(nec1_122_29, nec1_frequency);
        }
        catch (LircDeviceException ex) {
            Logger.getLogger(Mode2LircDevice.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

