/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.girr;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.harctoolbox.IrpMaster.DecodeIR;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.IrpMaster;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.IrpMaster.ParseException;
import org.harctoolbox.IrpMaster.Pronto;
import org.harctoolbox.IrpMaster.Protocol;
import org.harctoolbox.IrpMaster.UnassignedException;
import org.harctoolbox.IrpMaster.UnknownProtocolException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Command
implements Serializable {
    private static final String toggleAttributeName = "T";
    private static final String toggleParameterName = "T";
    private static final String linefeed = System.getProperty("line.separator", "\n");
    private static IrpMaster irpMaster;
    private transient Protocol protocol;
    private MasterType masterType;
    private String notes;
    private String name;
    private String protocolName;
    private HashMap<String, Long> parameters;
    private int frequency;
    private double dutyCycle;
    private String[] intro;
    private String[] repeat;
    private String[] ending;
    private String[] ccf;
    private String comment;
    private HashMap<String, String> otherFormats;

    static long parseParameter(String s) throws NumberFormatException {
        return s.startsWith("0x") ? Long.parseLong(s.substring(2), 16) : Long.parseLong(s);
    }

    public static void setIrpMaster(IrpMaster newIrpMaster) {
        irpMaster = newIrpMaster;
    }

    public static void setIrpMaster(String irpProtocolsIniPath) throws IOException, IncompatibleArgumentException {
        irpMaster = new IrpMaster(irpProtocolsIniPath);
    }

    private static String toPrintString(HashMap<String, Long> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringBuilder str = new StringBuilder(64);
        for (Map.Entry<String, Long> kvp : map.entrySet()) {
            str.append(kvp.getKey()).append("=").append(Long.toString(kvp.getValue())).append(" ");
        }
        return str.substring(0, str.length() - 1);
    }

    private static void processRaw(Document doc, Element element, String sequence, String tagName, boolean fatRaw) {
        Element el = Command.xmlExport(doc, sequence, tagName, fatRaw);
        if (el != null) {
            element.appendChild(el);
        }
    }

    private static Element xmlExport(Document doc, String sequence, String tagName, boolean fatRaw) {
        if (sequence == null || sequence.isEmpty()) {
            return null;
        }
        Element el = doc.createElementNS("http://www.harctoolbox.org/Girr", tagName);
        if (fatRaw) {
            Command.insertFatElements(doc, el, sequence);
        } else {
            el.setTextContent(sequence);
        }
        return el;
    }

    private static void insertFatElements(Document doc, Element el, String sequence) {
        String[] durations = sequence.split(" ");
        for (int i = 0; i < durations.length; ++i) {
            String duration = durations[i].replaceAll("[\\+-]", "");
            Element e = doc.createElementNS("http://www.harctoolbox.org/Girr", i % 2 == 0 ? "flash" : "gap");
            e.setTextContent(duration);
            el.appendChild(e);
        }
    }

    private static String parseSequence(Element element) {
        if (element.getElementsByTagName("flash").getLength() > 0) {
            StringBuilder str = new StringBuilder(64);
            NodeList nl = element.getChildNodes();
            block8: for (int i = 0; i < nl.getLength(); ++i) {
                if (nl.item(i).getNodeType() != 1) continue;
                Element el = (Element)nl.item(i);
                switch (el.getTagName()) {
                    case "flash": {
                        str.append(" +").append(el.getTextContent());
                        continue block8;
                    }
                    case "gap": {
                        str.append(" -").append(el.getTextContent());
                        continue block8;
                    }
                    default: {
                        throw new RuntimeException("Invalid tag name");
                    }
                }
            }
            return str.substring(1);
        }
        return element.getTextContent();
    }

    public Command(Element element, String inheritProtocol, HashMap<String, Long> inheritParameters) throws java.text.ParseException, IrpMasterException {
        this(MasterType.safeValueOf(element.getAttribute("master")), element.getAttribute("name"), element.getAttribute("comment"));
        this.protocolName = inheritProtocol;
        this.parameters = new HashMap(4);
        this.parameters.putAll(inheritParameters);
        this.otherFormats = new HashMap(1);
        NodeList nl = element.getElementsByTagName("notes");
        if (nl.getLength() > 0) {
            this.notes = nl.item(0).getTextContent();
        }
        try {
            String Fstring;
            NodeList paramsNodeList = element.getElementsByTagName("parameters");
            if (paramsNodeList.getLength() > 0) {
                Element params = (Element)paramsNodeList.item(0);
                String proto = params.getAttribute("protocol");
                if (!proto.isEmpty()) {
                    this.protocolName = proto;
                }
                nl = params.getElementsByTagName("parameter");
                for (int i = 0; i < nl.getLength(); ++i) {
                    Element el = (Element)nl.item(i);
                    this.parameters.put(el.getAttribute("name"), Command.parseParameter(el.getAttribute("value")));
                }
            }
            if (!(Fstring = element.getAttribute("F")).isEmpty()) {
                this.parameters.put("F", Command.parseParameter(Fstring));
            }
            if ((nl = element.getElementsByTagName("raw")).getLength() > 0) {
                this.intro = new String[nl.getLength()];
                this.repeat = new String[nl.getLength()];
                this.ending = new String[nl.getLength()];
                for (int i = 0; i < nl.getLength(); ++i) {
                    NodeList nodeList;
                    String dc;
                    int T;
                    Element el = (Element)nl.item(i);
                    try {
                        T = Integer.parseInt(el.getAttribute("T"));
                    }
                    catch (NumberFormatException ex) {
                        T = 0;
                    }
                    this.barfIfInvalidToggle(T, nl.getLength());
                    String freq = el.getAttribute("frequency");
                    if (!freq.isEmpty()) {
                        this.frequency = Integer.parseInt(freq);
                    }
                    if (!(dc = el.getAttribute("dutyCycle")).isEmpty()) {
                        this.dutyCycle = Double.parseDouble(dc);
                        if (this.dutyCycle <= 0.0 || this.dutyCycle >= 1.0) {
                            throw new java.text.ParseException("Invalid dutyCycle: " + this.dutyCycle + "; must be between 0 and 1.", -1);
                        }
                    }
                    if ((nodeList = el.getElementsByTagName("intro")).getLength() > 0) {
                        this.intro[T] = Command.parseSequence((Element)nodeList.item(0));
                    }
                    if ((nodeList = el.getElementsByTagName("repeat")).getLength() > 0) {
                        this.repeat[T] = Command.parseSequence((Element)nodeList.item(0));
                    }
                    if ((nodeList = el.getElementsByTagName("ending")).getLength() <= 0) continue;
                    this.ending[T] = Command.parseSequence((Element)nodeList.item(0));
                }
            }
            if ((nl = element.getElementsByTagName("ccf")).getLength() > 0) {
                this.ccf = new String[nl.getLength()];
                for (int i = 0; i < nl.getLength(); ++i) {
                    int T;
                    Element el = (Element)nl.item(i);
                    try {
                        T = Integer.parseInt(el.getAttribute("T"));
                    }
                    catch (NumberFormatException ex) {
                        T = 0;
                    }
                    this.barfIfInvalidToggle(T, nl.getLength());
                    this.ccf[T] = el.getTextContent();
                }
            }
            nl = element.getElementsByTagName("format");
            for (int i = 0; i < nl.getLength(); ++i) {
                Element el = (Element)nl.item(0);
                this.otherFormats.put(el.getAttribute("name"), el.getTextContent());
            }
        }
        catch (IllegalArgumentException ex) {
            throw new java.text.ParseException(ex.getClass().getSimpleName() + " " + ex.getMessage(), -1);
        }
        this.sanityCheck();
    }

    public Command(String name, String comment, IrSignal irSignal) {
        this(MasterType.raw, name, comment);
        this.generateRaw(irSignal);
    }

    public Command(String name, String comment, String protocolName, HashMap<String, Long> parameters) throws IrpMasterException {
        this(name, comment, protocolName, irpMaster.newProtocolOrNull(protocolName), parameters);
    }

    private Command(String name, String comment, String protocolName, Protocol protocol, HashMap<String, Long> parameters) throws IrpMasterException {
        this(MasterType.parameters, name, comment);
        this.parameters = (HashMap)parameters.clone();
        this.protocolName = protocolName;
        this.protocol = protocol;
        this.sanityCheck();
    }

    private Command(MasterType masterType, String name, String comment) {
        this.masterType = masterType;
        this.name = name;
        this.comment = comment;
        this.frequency = -1;
        this.dutyCycle = -1.0;
        this.ccf = null;
        this.intro = null;
        this.repeat = null;
        this.ending = null;
    }

    public Command(String name, String comment, String ccf) throws IrpMasterException {
        this(MasterType.ccf, name, comment);
        this.ccf = new String[1];
        this.ccf[0] = ccf;
        this.sanityCheck();
    }

    public Command(String name) {
        this(MasterType.empty, name, null);
    }

    public double getDutyCycle() {
        if (this.masterType == MasterType.parameters) {
            this.checkForProtocol();
            return this.protocol.getDutyCycle();
        }
        return this.dutyCycle;
    }

    public String getComment() {
        return this.comment;
    }

    public String getNotes() {
        return this.notes;
    }

    public MasterType getMasterType() {
        return this.masterType;
    }

    public String getName() {
        return this.name;
    }

    public String getProtocolName() throws IrpMasterException {
        this.checkForParameters();
        return this.protocolName;
    }

    public HashMap<String, Long> getParameters() throws IrpMasterException {
        this.checkForParameters();
        return this.parameters;
    }

    public double getFrequency() {
        if (this.masterType == MasterType.parameters) {
            this.checkForProtocol();
            return this.protocol.getFrequency();
        }
        return this.frequency;
    }

    private void checkForProtocol() {
        if (this.protocol == null) {
            try {
                this.protocol = irpMaster.newProtocol(this.protocolName);
            }
            catch (ParseException | UnassignedException | UnknownProtocolException irpMasterException) {
                // empty catch block
            }
        }
    }

    public String getIntro() throws IrpMasterException {
        return this.getIntro(0);
    }

    public String getIntro(int T) throws IrpMasterException {
        this.checkForRaw();
        this.barfIfInvalidToggle(T);
        return this.intro[T];
    }

    public String getRepeat() throws IrpMasterException {
        return this.getRepeat(0);
    }

    public String getRepeat(int T) throws IrpMasterException {
        this.checkForRaw();
        this.barfIfInvalidToggle(T);
        return this.repeat[T];
    }

    public String getEnding() throws IrpMasterException {
        return this.getEnding(0);
    }

    public String getEnding(int T) throws IrpMasterException {
        this.checkForRaw();
        this.barfIfInvalidToggle(T);
        return this.ending[T];
    }

    public String getCcf() throws IrpMasterException {
        return this.getCcf(0);
    }

    public String getCcf(int T) throws IrpMasterException {
        this.checkForCcf();
        this.barfIfInvalidToggle(T);
        return this.ccf[T];
    }

    private void barfIfInvalidToggle(int T) throws IllegalArgumentException {
        this.barfIfInvalidToggle(T, this.numberOfToggleValues());
    }

    private void barfIfInvalidToggle(int T, int noToggles) throws IllegalArgumentException {
        if (T < 0 || T >= noToggles) {
            throw new IllegalArgumentException("Illegal value of T = " + T);
        }
    }

    public Collection<String> getOtherFormats() {
        return this.otherFormats.keySet();
    }

    public String getFormat(String name) {
        return this.otherFormats != null ? this.otherFormats.get(name) : null;
    }

    public IrSignal toIrSignal() throws IrpMasterException {
        return this.toIrSignal(0);
    }

    public IrSignal toIrSignal(int T) throws IrpMasterException {
        this.barfIfInvalidToggle(T);
        return this.masterType == MasterType.parameters ? new IrSignal(irpMaster, this.protocolName, this.parameters) : (this.masterType == MasterType.raw ? new IrSignal((double)this.frequency, this.dutyCycle, this.intro[T], this.repeat[T], this.ending[T]) : new IrSignal(this.ccf[T]));
    }

    public String nameProtocolParameterString() {
        StringBuilder str = new StringBuilder(this.name != null ? this.name : "<no_name>");
        if (this.protocolName == null) {
            str.append(": <no decode>");
        } else {
            str.append(": ").append(this.protocolName);
            if (this.parameters.containsKey("D")) {
                str.append(" Device: ").append(this.parameters.get("D"));
            }
            if (this.parameters.containsKey("S")) {
                str.append(".").append(this.parameters.get("S"));
            }
            if (this.parameters.containsKey("F")) {
                str.append(" Function: ").append(this.parameters.get("F"));
            }
            for (Map.Entry<String, Long> kvp : this.parameters.entrySet()) {
                String parName = kvp.getKey();
                if (parName.equals("F") || parName.equals("D") || parName.equals("F")) continue;
                str.append(" ").append(parName).append("=").append(kvp.getValue());
            }
        }
        return str.toString();
    }

    public String prettyValueString() {
        if (this.masterType == MasterType.empty) {
            return "no information present";
        }
        try {
            this.checkForParameters();
        }
        catch (IrpMasterException ex) {
            return "Raw signal";
        }
        return this.parameters != null && !this.parameters.isEmpty() ? this.protocolName + ", " + Command.toPrintString(this.parameters) : (this.ccf != null ? this.ccf[0] : "Raw signal");
    }

    public String toPrintString() throws IrpMasterException {
        StringBuilder str = new StringBuilder(this.name != null ? this.name : "<unnamed>");
        str.append(": ");
        if (this.parameters != null) {
            str.append(this.protocolName).append(", ").append(Command.toPrintString(this.parameters));
        } else if (this.ccf != null) {
            str.append(this.getCcf());
        } else {
            str.append(this.toIrSignal().toPrintString(true));
        }
        return str.toString();
    }

    public String toString() {
        if (this.masterType == MasterType.empty) {
            return "no information present";
        }
        try {
            return this.toPrintString();
        }
        catch (IrpMasterException ex) {
            return this.name + ": (<erroneous signal>)";
        }
    }

    private void sanityCheck() throws IrpMasterException {
        boolean ccfOk;
        boolean protocolOk = this.protocolName != null && !this.protocolName.isEmpty();
        boolean parametersOk = this.parameters != null && !this.parameters.isEmpty();
        boolean rawOk = this.intro != null && this.intro[0] != null && !this.intro[0].isEmpty() || this.repeat != null && this.repeat[0] != null && !this.repeat[0].isEmpty();
        boolean bl = ccfOk = this.ccf != null && this.ccf[0] != null && !this.ccf[0].isEmpty();
        if (this.masterType == null) {
            MasterType masterType = protocolOk && parametersOk ? MasterType.parameters : (rawOk ? MasterType.raw : (this.masterType = ccfOk ? MasterType.ccf : null));
        }
        if (this.masterType == null) {
            throw new IrpMasterException("Command " + this.name + ": No usable data or parameters.");
        }
        if (this.masterType == MasterType.parameters && !protocolOk) {
            throw new IrpMasterException("Command " + this.name + ": MasterType is parameters, but no protocol found.");
        }
        if (this.masterType == MasterType.parameters && !parametersOk) {
            throw new IrpMasterException("Command " + this.name + ": MasterType is parameters, but no parameters found.");
        }
        if (this.masterType == MasterType.raw && !rawOk) {
            throw new IrpMasterException("Command " + this.name + ": MasterType is raw, but both intro- and repeat-sequence empty.");
        }
        if (this.masterType == MasterType.ccf && !ccfOk) {
            throw new IrpMasterException("Command " + this.name + ": MasterType is ccf, but no ccf found.");
        }
    }

    private void generateRawCcfAllT(HashMap<String, Long> parameters, boolean generateRaw, boolean generateCcf) throws IrpMasterException {
        if (this.numberOfToggleValues() == 1) {
            this.generateRawCcf(parameters, generateRaw, generateCcf);
        } else {
            for (int T = 0; T < this.numberOfToggleValues(); ++T) {
                this.generateRawCcfForceT(parameters, T, generateRaw, generateCcf);
            }
        }
    }

    private void generateRawCcfForceT(HashMap<String, Long> parameter, int T, boolean generateRaw, boolean generateCcf) throws IrpMasterException {
        HashMap params = (HashMap)this.parameters.clone();
        params.put("T", Long.valueOf(T));
        this.generateRawCcf(params, T, generateRaw, generateCcf);
    }

    private void generateRawCcf(HashMap<String, Long> parameter, boolean generateRaw, boolean generateCcf) throws IrpMasterException {
        if (this.protocol == null) {
            throw new IrpMasterException("Protocol " + this.protocolName + " unknown or unusable");
        }
        IrSignal irSignal = this.protocol.renderIrSignal(this.parameters);
        if (generateRaw) {
            this.generateRaw(irSignal);
        }
        if (generateCcf) {
            this.generateCcf(irSignal);
        }
    }

    private void generateRawCcf(HashMap<String, Long> parameters, int T, boolean generateRaw, boolean generateCcf) throws IrpMasterException {
        IrSignal irSignal = this.protocol.renderIrSignal(parameters);
        if (generateRaw) {
            this.generateRaw(irSignal, T);
        }
        if (generateCcf) {
            this.generateCcf(irSignal, T);
        }
    }

    private void generateDecode(IrSignal irSignal) {
        DecodeIR.DecodedSignal[] decodes = DecodeIR.decode(irSignal);
        if (decodes == null) {
            this.notes = "DecodeIR was attempted, but not found.";
        } else {
            if (decodes.length > 0 && !decodes[0].getProtocol().startsWith("Gap") && decodes[0].getParameters().size() > 0) {
                this.protocolName = decodes[0].getProtocol();
                this.parameters = decodes[0].getParameters();
            }
            if (decodes.length == 0) {
                this.notes = "DecodeIr was invoked, but found no decode.";
            } else if (decodes.length > 1 || decodes[0].getProtocol().startsWith("Gap") || decodes[0].getParameters().isEmpty()) {
                this.notes = decodes.length > 1 ? "Several decodes from DecodeIr:" : "Failed decodes from DecodeIr:";
                for (DecodeIR.DecodedSignal dec : decodes) {
                    this.notes = this.notes + linefeed + dec.toString();
                }
            }
        }
    }

    private void checkForParameters() throws IrpMasterException {
        if (this.parameters == null || this.parameters.isEmpty()) {
            this.generateDecode(this.toIrSignal());
        }
    }

    private void checkForRaw() throws IrpMasterException {
        if (this.intro != null || this.repeat != null || this.ending != null) {
            return;
        }
        if (this.masterType == MasterType.parameters) {
            this.generateRawCcfAllT(this.parameters, true, false);
        } else {
            IrSignal irSignal = new IrSignal(this.ccf[0]);
            this.generateRaw(irSignal);
        }
    }

    private void checkForCcf() throws IrpMasterException {
        if (this.ccf != null) {
            return;
        }
        if (this.masterType == MasterType.parameters) {
            this.generateRawCcfAllT(this.parameters, false, true);
        } else {
            IrSignal irSignal = new IrSignal((double)this.frequency, this.dutyCycle, this.intro[0], this.repeat[0], this.ending[0]);
            this.generateCcf(irSignal);
        }
    }

    public int numberOfToggleValues() {
        try {
            return this.masterType == MasterType.parameters && !this.parameters.containsKey("T") && this.protocol != null && this.protocol.hasParameter("T") && this.protocol.hasParameterMemory("T") ? (int)this.protocol.getParameterMax("T") + 1 : 1;
        }
        catch (UnassignedException ex) {
            throw new InternalError();
        }
    }

    private void generateRaw(IrSignal irSignal) {
        this.generateRaw(irSignal, 0);
    }

    private void generateRaw(IrSignal irSignal, int T) throws IllegalArgumentException {
        this.barfIfInvalidToggle(T);
        this.frequency = (int)Math.round(irSignal.getFrequency());
        this.dutyCycle = irSignal.getDutyCycle();
        if (this.intro == null) {
            this.intro = new String[this.numberOfToggleValues()];
        }
        this.intro[T] = irSignal.getIntroSequence().toPrintString(true, false, " ", false);
        if (this.repeat == null) {
            this.repeat = new String[this.numberOfToggleValues()];
        }
        this.repeat[T] = irSignal.getRepeatSequence().toPrintString(true, false, " ", false);
        if (this.ending == null) {
            this.ending = new String[this.numberOfToggleValues()];
        }
        this.ending[T] = irSignal.getEndingSequence().toPrintString(true, false, " ", false);
    }

    private void generateCcf(IrSignal irSignal) {
        this.generateCcf(irSignal, 0);
    }

    private void generateCcf(IrSignal irSignal, int T) throws IllegalArgumentException {
        this.barfIfInvalidToggle(T);
        if (this.ccf == null) {
            this.ccf = new String[this.numberOfToggleValues()];
        }
        this.ccf[T] = Pronto.toPrintString(irSignal);
    }

    public void addFormat(String name, String value) {
        if (this.otherFormats == null) {
            this.otherFormats = new HashMap(1);
        }
        this.otherFormats.put(name, value);
    }

    public void addFormat(CommandTextFormat format, int repeatCount) throws IrpMasterException {
        this.addFormat(format.getName(), format.format(this.toIrSignal(), repeatCount));
    }

    public Element xmlExport(Document doc, String title, boolean fatRaw, boolean generateRaw, boolean generateCcf, boolean generateParameters) {
        Element element = doc.createElementNS("http://www.harctoolbox.org/Girr", "command");
        if (title != null) {
            element.setAttribute("title", title);
        }
        element.setAttribute("name", this.name);
        MasterType actualMasterType = this.masterType;
        if (this.masterType == MasterType.raw && !generateRaw || this.masterType == MasterType.ccf && !generateCcf || this.masterType == MasterType.parameters && !generateParameters) {
            MasterType masterType = generateRaw ? MasterType.raw : (generateParameters ? MasterType.parameters : (actualMasterType = generateCcf ? MasterType.ccf : null));
        }
        if (actualMasterType != null) {
            element.setAttribute("master", actualMasterType.name());
        }
        if (this.comment != null) {
            element.setAttribute("comment", this.comment);
        }
        if (this.notes != null) {
            Element notesEl = doc.createElementNS("http://www.harctoolbox.org/Girr", "notes");
            notesEl.setTextContent(this.notes);
            element.appendChild(notesEl);
        }
        if (generateParameters) {
            try {
                this.checkForParameters();
                if (this.parameters != null) {
                    Element parametersEl = doc.createElementNS("http://www.harctoolbox.org/Girr", "parameters");
                    if (this.protocolName != null) {
                        parametersEl.setAttribute("protocol", this.protocolName.toLowerCase(Locale.US));
                    }
                    element.appendChild(parametersEl);
                    for (Map.Entry<String, Long> parameter : this.parameters.entrySet()) {
                        Element parameterEl = doc.createElementNS("http://www.harctoolbox.org/Girr", "parameter");
                        parameterEl.setAttribute("name", parameter.getKey());
                        parameterEl.setAttribute("value", parameter.getValue().toString());
                        parametersEl.appendChild(parameterEl);
                    }
                }
            }
            catch (IrpMasterException ex) {
                element.appendChild(doc.createComment("Parameters requested but could not be generated."));
            }
        }
        if (generateRaw) {
            try {
                this.checkForRaw();
                if (this.intro != null || this.repeat != null || this.ending != null) {
                    for (int T = 0; T < this.numberOfToggleValues(); ++T) {
                        Element rawEl = doc.createElementNS("http://www.harctoolbox.org/Girr", "raw");
                        rawEl.setAttribute("frequency", Integer.toString(this.frequency));
                        if (this.dutyCycle > 0.0) {
                            rawEl.setAttribute("dutyCycle", Double.toString(this.dutyCycle));
                        }
                        if (this.numberOfToggleValues() > 1) {
                            rawEl.setAttribute("T", Integer.toString(T));
                        }
                        element.appendChild(rawEl);
                        Command.processRaw(doc, rawEl, this.intro[T], "intro", fatRaw);
                        Command.processRaw(doc, rawEl, this.repeat[T], "repeat", fatRaw);
                        Command.processRaw(doc, rawEl, this.ending[T], "ending", fatRaw);
                    }
                }
            }
            catch (NullPointerException | IrpMasterException ex) {
                element.appendChild(doc.createComment("Raw signal requested but could not be generated."));
            }
        }
        if (generateCcf) {
            try {
                this.checkForCcf();
                if (this.ccf != null) {
                    for (int T = 0; T < this.numberOfToggleValues(); ++T) {
                        Element ccfEl = doc.createElementNS("http://www.harctoolbox.org/Girr", "ccf");
                        if (this.numberOfToggleValues() > 1) {
                            ccfEl.setAttribute("T", Integer.toString(T));
                        }
                        ccfEl.setTextContent(this.ccf[T]);
                        element.appendChild(ccfEl);
                    }
                }
            }
            catch (NullPointerException | IrpMasterException ex) {
                element.appendChild(doc.createComment("Pronto Hex requested but could not be generated."));
            }
        }
        if (this.otherFormats != null) {
            for (Map.Entry<String, String> format : this.otherFormats.entrySet()) {
                Element formatEl = doc.createElementNS("http://www.harctoolbox.org/Girr", "format");
                formatEl.setAttribute("name", format.getKey());
                formatEl.setTextContent(format.getValue());
                element.appendChild(formatEl);
            }
        }
        return element;
    }

    public static interface CommandTextFormat {
        public String getName();

        public String format(IrSignal var1, int var2);
    }

    public static enum MasterType {
        raw,
        ccf,
        parameters,
        empty;


        public static MasterType safeValueOf(String s) {
            try {
                return MasterType.valueOf(s);
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        }
    }
}

