/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.girr;

import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.girr.Command;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CommandSet {
    private String notes;
    private String protocol;
    private final String name;
    private final HashMap<String, Long> parameters;
    private final HashMap<String, Command> commands;

    CommandSet(Element element) throws ParseException {
        this.name = element.getAttribute("name");
        this.protocol = null;
        this.commands = new LinkedHashMap<String, Command>(4);
        this.parameters = new LinkedHashMap<String, Long>(4);
        NodeList nl = element.getElementsByTagName("notes");
        if (nl.getLength() > 0) {
            this.notes = nl.item(0).getTextContent();
        }
        nl = element.getChildNodes();
        for (int nodeNr = 0; nodeNr < nl.getLength(); ++nodeNr) {
            Element el;
            if (nl.item(nodeNr).getNodeType() != 1 || !(el = (Element)nl.item(nodeNr)).getTagName().equals("parameters")) continue;
            String newProtocol = el.getAttribute("protocol");
            if (!newProtocol.isEmpty()) {
                this.protocol = newProtocol;
            }
            NodeList paramList = el.getElementsByTagName("parameter");
            for (int i = 0; i < paramList.getLength(); ++i) {
                Element e = (Element)paramList.item(i);
                try {
                    this.parameters.put(e.getAttribute("name"), Command.parseParameter(e.getAttribute("value")));
                    continue;
                }
                catch (NumberFormatException ex) {
                    throw new ParseException("NumberFormatException " + ex.getMessage(), -1);
                }
            }
        }
        nl = element.getElementsByTagName("command");
        for (int i = 0; i < nl.getLength(); ++i) {
            try {
                Command irCommand = new Command((Element)nl.item(i), this.protocol, this.parameters);
                this.commands.put(irCommand.getName(), irCommand);
                continue;
            }
            catch (IrpMasterException irpMasterException) {
                // empty catch block
            }
        }
    }

    CommandSet(String name, String notes, HashMap<String, Command> commands, String protocol, HashMap<String, Long> parameters) {
        this.name = name != null ? name : "commandSet";
        this.notes = notes;
        this.commands = commands;
        this.protocol = protocol;
        this.parameters = parameters;
    }

    public HashMap<String, Command> getCommands() {
        return this.commands;
    }

    public Element xmlExport(Document doc, boolean fatRaw, boolean generateRaw, boolean generateCcf, boolean generateParameters) {
        Element element = doc.createElementNS("http://www.harctoolbox.org/Girr", "commandSet");
        element.setAttribute("name", this.name);
        if (this.notes != null) {
            Element notesEl = doc.createElementNS("http://www.harctoolbox.org/Girr", "notes");
            notesEl.setTextContent(this.notes);
            element.appendChild(notesEl);
        }
        if (this.parameters != null && generateParameters) {
            Element parametersEl = doc.createElementNS("http://www.harctoolbox.org/Girr", "parameters");
            parametersEl.setAttribute("protocol", this.protocol.toLowerCase(Locale.US));
            element.appendChild(parametersEl);
            for (Map.Entry<String, Long> parameter : this.parameters.entrySet()) {
                Element parameterEl = doc.createElementNS("http://www.harctoolbox.org/Girr", "parameter");
                parameterEl.setAttribute("name", parameter.getKey());
                parameterEl.setAttribute("value", parameter.getValue().toString());
                parametersEl.appendChild(parameterEl);
            }
        }
        if (this.commands != null) {
            for (Command command : this.commands.values()) {
                element.appendChild(command.xmlExport(doc, null, fatRaw, generateRaw, generateCcf, generateParameters));
            }
        }
        return element;
    }

    public void addFormat(Command.CommandTextFormat format, int repeatCount) {
        for (Command command : this.commands.values()) {
            try {
                command.addFormat(format, repeatCount);
            }
            catch (IrpMasterException irpMasterException) {}
        }
    }
}

