/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.girr;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.girr.Command;
import org.harctoolbox.girr.CommandSet;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Remote
implements Serializable {
    private MetaData metaData;
    private String comment;
    private String notes;
    private String protocol;
    private HashMap<String, Long> parameters;
    private HashMap<String, Command> commands;
    private HashMap<String, HashMap<String, String>> applicationParameters;

    private static HashMap<String, Command> commandToHashMap(Command command) {
        HashMap<String, Command> result = new HashMap<String, Command>(1);
        result.put(command.getName(), command);
        return result;
    }

    public Remote(Element element) throws ParseException {
        int i;
        this.metaData = new MetaData(element.getAttribute("name"), element.getAttribute("displayName"), element.getAttribute("manufacturer"), element.getAttribute("model"), element.getAttribute("deviceClass"), element.getAttribute("remoteName"));
        this.commands = new LinkedHashMap<String, Command>(32);
        this.applicationParameters = new LinkedHashMap<String, HashMap<String, String>>(4);
        this.comment = element.getAttribute("comment");
        NodeList nl = element.getElementsByTagName("applicationData");
        for (i = 0; i < nl.getLength(); ++i) {
            Element el = (Element)nl.item(i);
            NodeList nodeList = el.getElementsByTagName("appParameter");
            HashMap<String, String> map = new HashMap<String, String>(32);
            for (int index = 0; index < nodeList.getLength(); ++index) {
                Element par = (Element)nodeList.item(index);
                map.put(par.getAttribute("name"), par.getAttribute("value"));
            }
            this.applicationParameters.put(el.getAttribute("application"), map);
        }
        nl = element.getElementsByTagName("commandSet");
        for (i = 0; i < nl.getLength(); ++i) {
            CommandSet commandSet = new CommandSet((Element)nl.item(i));
            this.commands.putAll(commandSet.getCommands());
        }
    }

    public Remote(MetaData metaData, String comment, String notes, HashMap<String, Command> commands, HashMap<String, HashMap<String, String>> applicationParameters, String protocol, HashMap<String, Long> parameters) {
        this.metaData = metaData;
        this.comment = comment;
        this.notes = notes;
        this.commands = commands;
        this.applicationParameters = applicationParameters;
        this.protocol = protocol;
        this.parameters = parameters;
    }

    public Remote(MetaData metaData, String comment, String notes, HashMap<String, Command> commands, HashMap<String, HashMap<String, String>> applicationParameters) {
        this(metaData, comment, notes, commands, applicationParameters, null, null);
    }

    public Remote(IrSignal irSignal, String name, String comment, String deviceName) {
        this(new MetaData(deviceName), null, null, Remote.commandToHashMap(new Command(name, comment, irSignal)), null);
    }

    public Element xmlExport(Document doc, boolean fatRaw, boolean generateRaw, boolean generateCcf, boolean generateParameters) {
        Element element = doc.createElementNS("http://www.harctoolbox.org/Girr", "remote");
        element.setAttribute("name", this.metaData.name);
        if (this.metaData.displayName != null) {
            element.setAttribute("displayName", this.metaData.displayName);
        }
        if (this.metaData.manufacturer != null) {
            element.setAttribute("manufacturer", this.metaData.manufacturer);
        }
        if (this.metaData.model != null) {
            element.setAttribute("model", this.metaData.model);
        }
        if (this.metaData.deviceClass != null) {
            element.setAttribute("deviceClass", this.metaData.deviceClass);
        }
        if (this.metaData.remoteName != null) {
            element.setAttribute("remoteName", this.metaData.remoteName);
        }
        if (this.comment != null) {
            element.setAttribute("comment", this.comment);
        }
        if (this.notes != null) {
            Element notesEl = doc.createElementNS("http://www.harctoolbox.org/Girr", "notes");
            notesEl.setTextContent(this.notes);
            element.appendChild(notesEl);
        }
        if (this.applicationParameters != null) {
            for (Map.Entry entry : this.applicationParameters.entrySet()) {
                Element appEl = doc.createElementNS("http://www.harctoolbox.org/Girr", "applicationData");
                appEl.setAttribute("application", (String)entry.getKey());
                element.appendChild(appEl);
                for (Map.Entry param : ((HashMap)entry.getValue()).entrySet()) {
                    Element paramEl = doc.createElementNS("http://www.harctoolbox.org/Girr", "appParameter");
                    paramEl.setAttribute("name", (String)param.getKey());
                    paramEl.setAttribute("value", (String)param.getValue());
                    appEl.appendChild(paramEl);
                }
            }
        }
        CommandSet commandSet = new CommandSet(null, null, this.commands, this.protocol, this.parameters);
        element.appendChild(commandSet.xmlExport(doc, fatRaw, generateRaw, generateCcf, generateParameters));
        return element;
    }

    public void addFormat(Command.CommandTextFormat format, int repeatCount) {
        for (Command command : this.commands.values()) {
            try {
                command.addFormat(format, repeatCount);
            }
            catch (IrpMasterException irpMasterException) {}
        }
    }

    public boolean hasThisProtocol(String protocolName) throws IrpMasterException {
        for (Command command : this.commands.values()) {
            String prtcl = command.getProtocolName();
            if (prtcl != null && prtcl.equalsIgnoreCase(protocolName)) continue;
            return false;
        }
        return true;
    }

    public Command getCommand(String commandName) {
        return this.commands.get(commandName);
    }

    public MetaData getMetaData() {
        return this.metaData;
    }

    public String getName() {
        return this.metaData.name;
    }

    public String getDisplayName() {
        return this.metaData.displayName;
    }

    public String getComment() {
        return this.comment;
    }

    public HashMap<String, Command> getCommands() {
        return this.commands;
    }

    public HashMap<String, HashMap<String, String>> getApplicationParameters() {
        return this.applicationParameters;
    }

    public String getManufacturer() {
        return this.metaData.manufacturer;
    }

    public String getModel() {
        return this.metaData.model;
    }

    public String getDeviceClass() {
        return this.metaData.deviceClass;
    }

    public String getRemoteName() {
        return this.metaData.remoteName;
    }

    public String getNotes() {
        return this.notes;
    }

    public static class CompareNameCaseInsensitive
    implements Comparator<Remote>,
    Serializable {
        @Override
        public int compare(Remote o1, Remote o2) {
            return o1.metaData.name.compareToIgnoreCase(o2.metaData.name);
        }
    }

    public static class CompareNameCaseSensitive
    implements Comparator<Remote>,
    Serializable {
        @Override
        public int compare(Remote o1, Remote o2) {
            return o1.metaData.name.compareTo(o2.metaData.name);
        }
    }

    public static class MetaData
    implements Serializable {
        private String name;
        private String displayName;
        private String manufacturer;
        private String model;
        private String deviceClass;
        private String remoteName;

        public MetaData() {
            this.name = null;
            this.displayName = null;
            this.manufacturer = null;
            this.model = null;
            this.deviceClass = null;
            this.remoteName = null;
        }

        public MetaData(String name) {
            this();
            this.name = name;
        }

        public MetaData(String name, String displayName, String manufacturer, String model, String deviceClass, String remoteName) {
            this.name = name;
            this.displayName = displayName;
            this.manufacturer = manufacturer;
            this.model = model;
            this.deviceClass = deviceClass;
            this.remoteName = remoteName;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getManufacturer() {
            return this.manufacturer;
        }

        public String getModel() {
            return this.model;
        }

        public String getDeviceClass() {
            return this.deviceClass;
        }

        public String getRemoteName() {
            return this.remoteName;
        }
    }
}

