/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.girr;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.harctoolbox.IrpMaster.DecodeIR;
import org.harctoolbox.IrpMaster.IrSignal;
import org.harctoolbox.IrpMaster.IrpMasterException;
import org.harctoolbox.IrpMaster.XmlUtils;
import org.harctoolbox.girr.Command;
import org.harctoolbox.girr.Remote;
import org.harctoolbox.girr.XmlExporter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RemoteSet
implements Serializable {
    public static final String girrVersion = "1.0";
    private static String dateFormatString = "yyyy-MM-dd_HH:mm:ss";
    private String creatingUser;
    private String source;
    private String creationDate;
    private String tool;
    private String toolVersion;
    private String tool2;
    private String tool2Version;
    private String notes;
    private HashMap<String, Remote> remotes;

    public static void setDateFormatString(String aDateFormatString) {
        dateFormatString = aDateFormatString;
    }

    public static void main(String[] args) {
        try {
            Document doc = XmlUtils.openXmlFile(new File(args[0]), new File(args[1]), true, false);
            RemoteSet remoteList = new RemoteSet(doc);
            Document newdoc = remoteList.xmlExportDocument("This is a silly title", "xsl", "simplehtml.xsl", true, false, true, true, true);
            XmlExporter exporter = new XmlExporter(newdoc);
            exporter.printDOM(new File("junk.xml"));
        }
        catch (IOException | ParseException | SAXException ex) {
            System.err.println(ex.getMessage());
        }
    }

    public RemoteSet(Document doc) throws ParseException {
        this.remotes = new LinkedHashMap<String, Remote>(4);
        Element root = doc.getDocumentElement();
        NodeList nl = root.getElementsByTagName("adminData");
        if (nl.getLength() > 0) {
            Element adminData = (Element)nl.item(0);
            NodeList nodeList = adminData.getElementsByTagName("notes");
            if (nodeList.getLength() > 0) {
                this.notes = nodeList.item(0).getTextContent();
            }
            if ((nodeList = adminData.getElementsByTagName("creationData")).getLength() > 0) {
                Element creationdata = (Element)nodeList.item(0);
                this.creatingUser = creationdata.getAttribute("creatingUser");
                this.source = creationdata.getAttribute("source");
                this.creationDate = creationdata.getAttribute("creationDate");
                this.tool = creationdata.getAttribute("tool");
                this.toolVersion = creationdata.getAttribute("toolVersion");
                this.tool2 = creationdata.getAttribute("tool2");
                this.tool2Version = creationdata.getAttribute("tool2Version");
            }
        }
        nl = root.getElementsByTagName("remote");
        for (int i = 0; i < nl.getLength(); ++i) {
            Remote remote = new Remote((Element)nl.item(i));
            this.remotes.put(remote.getName(), remote);
        }
    }

    public RemoteSet(String creatingUser, String source, String creationDate, String tool, String toolVersion, String tool2, String tool2Version, String notes, HashMap<String, Remote> remotes) {
        this.creatingUser = creatingUser;
        this.source = source;
        this.creationDate = creationDate != null ? creationDate : new SimpleDateFormat(dateFormatString).format(new Date());
        this.tool = tool;
        this.toolVersion = toolVersion;
        this.tool2 = tool2;
        this.tool2Version = tool2Version;
        this.notes = notes;
        this.remotes = remotes;
    }

    public RemoteSet(String creatingUser, String source, String creationDate, String tool, String toolVersion, String tool2, String tool2Version, String notes, Remote remote) {
        this(creatingUser, source, creationDate, tool, toolVersion, tool2, tool2Version, notes, new HashMap<String, Remote>(1));
        this.remotes.put(remote.getName(), remote);
    }

    public RemoteSet(String creatingUser, String source, Remote remote) {
        this(creatingUser, source, null, "IrpMaster", "IrpMaster version 1.3", "DecodeIR", DecodeIR.getVersion(), null, remote);
    }

    public RemoteSet(String creatingUser, String source, HashMap<String, Remote> remotes) {
        this(creatingUser, source, null, "IrpMaster", "IrpMaster version 1.3", "DecodeIR", DecodeIR.getVersion(), null, remotes);
    }

    public RemoteSet(String source, String creatingUser, IrSignal irSignal, String name, String comment, String deviceName) {
        this(creatingUser, source, new Remote(irSignal, name, comment, deviceName));
    }

    public void append(RemoteSet remoteSet) {
        this.remotes.putAll(remoteSet.remotes);
    }

    public Element xmlExport(Document doc, String title, boolean fatRaw, boolean createSchemaLocation, boolean generateRaw, boolean generateCcf, boolean generateParameters) {
        Element element = doc.createElementNS("http://www.harctoolbox.org/Girr", "remotes");
        element.setAttribute("girrVersion", girrVersion);
        if (createSchemaLocation) {
            element.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            element.setAttribute("xsi:schemaLocation", "http://www.harctoolbox.org/Girr http://www.harctoolbox.org/schemas/girr_ns.xsd");
        }
        if (title != null) {
            element.setAttribute("title", title);
        }
        Element adminDataEl = doc.createElementNS("http://www.harctoolbox.org/Girr", "adminData");
        element.appendChild(adminDataEl);
        Element creationEl = doc.createElementNS("http://www.harctoolbox.org/Girr", "creationData");
        adminDataEl.appendChild(creationEl);
        if (this.creatingUser != null) {
            creationEl.setAttribute("creatingUser", this.creatingUser);
        }
        if (this.source != null) {
            creationEl.setAttribute("source", this.source);
        }
        if (this.creationDate != null) {
            creationEl.setAttribute("creationDate", this.creationDate);
        }
        if (this.tool != null) {
            creationEl.setAttribute("tool", this.tool);
        }
        if (this.toolVersion != null) {
            creationEl.setAttribute("toolVersion", this.toolVersion);
        }
        if (this.tool2 != null) {
            creationEl.setAttribute("tool2", this.tool2);
        }
        if (this.tool2Version != null) {
            creationEl.setAttribute("tool2Version", this.tool2Version);
        }
        if (this.notes != null) {
            Element notesEl = doc.createElementNS("http://www.harctoolbox.org/Girr", "notes");
            notesEl.setTextContent(this.notes);
            adminDataEl.appendChild(notesEl);
        }
        for (Remote remote : this.remotes.values()) {
            element.appendChild(remote.xmlExport(doc, fatRaw, generateRaw, generateCcf, generateParameters));
        }
        return element;
    }

    public Document xmlExportDocument(String title, String stylesheetType, String stylesheetUrl, boolean fatRaw, boolean createSchemaLocation, boolean generateRaw, boolean generateCcf, boolean generateParameters) {
        Element root = this.xmlExport(XmlExporter.newDocument(), title, fatRaw, createSchemaLocation, generateRaw, generateCcf, generateParameters);
        return XmlExporter.createDocument(root, stylesheetType, stylesheetUrl, createSchemaLocation);
    }

    public void addFormat(Command.CommandTextFormat format, int repeatCount) throws IrpMasterException {
        for (Remote remote : this.remotes.values()) {
            remote.addFormat(format, repeatCount);
        }
    }

    public ArrayList<Command> getAllCommands() {
        ArrayList<Command> allCommands = new ArrayList<Command>(32);
        for (Remote remote : this.remotes.values()) {
            allCommands.addAll(remote.getCommands().values());
        }
        return allCommands;
    }

    public String getCreatingUser() {
        return this.creatingUser;
    }

    public String getSource() {
        return this.source;
    }

    public String getCreationDate() {
        return this.creationDate;
    }

    public String getTool() {
        return this.tool;
    }

    public String getToolVersion() {
        return this.toolVersion;
    }

    public String getTool2() {
        return this.tool2;
    }

    public String getTool2Version() {
        return this.tool2Version;
    }

    public String getNotes() {
        return this.notes;
    }

    public Collection<Remote> getRemotes() {
        return this.remotes.values();
    }

    public Remote getRemote(String name) {
        return this.remotes.get(name);
    }
}

