/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.girr;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.harctoolbox.IrpMaster.XmlUtils;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

public class XmlExporter {
    static final String w3cSchemaNamespace = "http://www.w3.org/2001/XMLSchema-instance";
    static final String xsltNamespace = "http://www.w3.org/1999/XSL/Transform";
    public static final String girrNamespace = "http://www.harctoolbox.org/Girr";
    public static final String girrHomePage = "http://www.harctoolbox.org/Girr.html";
    public static final String girrSchemaLocationURL = "http://www.harctoolbox.org/schemas/girr_ns.xsd";
    public static final String girrNoNamespaceSchemaLocationURL = "http://www.harctoolbox.org/schemas/girr.xsd";
    private static boolean debug = false;
    private static final String girrComment = "This file is in the Girr (General IR Remote) format, see http://www.harctoolbox.org/Girr.html";
    private static final String defaultCharsetName = "UTF-8";
    private final Document document;

    public static void setDebug(boolean dbg) {
        debug = dbg;
    }

    public static Document createDocument(Element root, String stylesheetType, String stylesheetUrl, boolean createSchemaLocation) {
        Document document = root.getOwnerDocument();
        if (stylesheetType != null && stylesheetUrl != null && !stylesheetUrl.isEmpty()) {
            ProcessingInstruction pi = document.createProcessingInstruction("xml-stylesheet", "type=\"text/" + stylesheetType + "\" href=\"" + stylesheetUrl + "\"");
            document.appendChild(pi);
        }
        Comment comment = document.createComment(girrComment);
        document.appendChild(comment);
        document.appendChild(root);
        root.setAttribute("girrVersion", "1.0");
        if (createSchemaLocation) {
            root.setAttribute("xmlns:xsi", w3cSchemaNamespace);
            root.setAttribute("xmlns", girrNamespace);
            root.setAttribute("xsi:schemaLocation", girrSchemaLocationURL);
        }
        return document;
    }

    public static Document newDocument() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        Document doc = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.newDocument();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            // empty catch block
        }
        return doc;
    }

    public XmlExporter(Document doc) {
        this.document = doc;
    }

    public XmlExporter(Element root, String stylesheetType, String stylesheetUrl, boolean createSchemaLocation) {
        this(XmlExporter.createDocument(root, stylesheetType, stylesheetUrl, createSchemaLocation));
    }

    public void printDOM(OutputStream ostr, Document stylesheet, HashMap<String, String> parameters, boolean binary, String charsetName) throws IOException {
        if (debug) {
            XmlUtils.printDOM(new File("girr.girr"), this.document);
            XmlUtils.printDOM(new File("stylesheet.xsl"), stylesheet);
        }
        try {
            Transformer tr;
            TransformerFactory factory = TransformerFactory.newInstance();
            if (stylesheet == null) {
                tr = factory.newTransformer();
                tr.setOutputProperty("method", "xml");
                tr.setOutputProperty("encoding", charsetName);
            } else {
                NodeList nodeList;
                if (parameters != null) {
                    for (Map.Entry<String, String> kvp : parameters.entrySet()) {
                        Element e = stylesheet.createElementNS(xsltNamespace, "xsl:param");
                        e.setAttribute("name", kvp.getKey());
                        e.setAttribute("select", kvp.getValue());
                        stylesheet.getDocumentElement().insertBefore(e, stylesheet.getDocumentElement().getFirstChild());
                    }
                }
                if ((nodeList = stylesheet.getDocumentElement().getElementsByTagNameNS(xsltNamespace, "output")).getLength() > 0) {
                    Element e = (Element)nodeList.item(0);
                    e.setAttribute("encoding", charsetName);
                }
                if (debug) {
                    XmlUtils.printDOM(new File("stylesheet-params.xsl"), stylesheet);
                }
                tr = factory.newTransformer(new DOMSource(stylesheet));
            }
            tr.setOutputProperty("indent", "yes");
            tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            if (binary) {
                DOMResult domResult = new DOMResult();
                tr.transform(new DOMSource(this.document), domResult);
                Document newDoc = (Document)domResult.getNode();
                if (debug) {
                    XmlUtils.printDOM(new File("girr-binary.xml"), newDoc);
                }
                NodeList byteElements = newDoc.getDocumentElement().getElementsByTagName("byte");
                for (int i = 0; i < byteElements.getLength(); ++i) {
                    int val = Integer.parseInt(byteElements.item(i).getTextContent());
                    ostr.write(val);
                }
            } else {
                tr.transform(new DOMSource(this.document), new StreamResult(ostr));
            }
            if (parameters != null && stylesheet != null) {
                NodeList nl = stylesheet.getDocumentElement().getChildNodes();
                for (int i = nl.getLength() - 1; i >= 0; --i) {
                    Element e;
                    Node n = nl.item(i);
                    if (n.getNodeType() != 1 || !(e = (Element)n).getLocalName().equals("param") || !parameters.containsKey(e.getAttribute("name"))) continue;
                    stylesheet.getDocumentElement().removeChild(n);
                }
            }
        }
        catch (TransformerConfigurationException e) {
            System.err.println(e.getMessage());
        }
        catch (TransformerException e) {
            System.err.println(e.getMessage());
        }
    }

    public void printDOM(OutputStream ostr, String charsetName) throws IOException {
        this.printDOM(ostr, null, null, false, charsetName);
    }

    public void printDOM(File file, String charsetName) throws IOException {
        if (file == null) {
            this.printDOM(System.out, charsetName);
        } else {
            try (FileOutputStream stream = new FileOutputStream(file);){
                this.printDOM(stream, charsetName);
            }
        }
    }

    public void printDOM(File file) throws FileNotFoundException, IOException {
        this.printDOM(file, defaultCharsetName);
    }
}

