/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.guicomponents;

import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.harctoolbox.guicomponents.HarcPanel;
import org.harctoolbox.harchardware.beacon.AmxBeaconListener;

public class AmxBeaconListenerPanel
extends HarcPanel {
    private static final String helpText = "This pane displays a dynamic tree of nodes sending out an AMX beacon.";
    public static final String versionString = "0.1.0";
    public static final String aboutText = "AmxBeaconListener version 0.1.0.\nCopyright 2013 by Bengt Martensson.\n\nLicense: GPL3.\n\nProject home page: http://www.harctoolbox.org";
    private final transient AmxBeaconListener listener = new AmxBeaconListener(new Callbacker());
    private JScrollPane scrollPane;
    private JTree tree;

    @Override
    public String getHelpMessage() {
        return helpText;
    }

    @Override
    public String getAboutMessage() {
        return aboutText;
    }

    @Override
    public String getProgName() {
        return "AmxBeaconListener";
    }

    @Override
    public String getIconPath() {
        return "/icons/Crystal-Clear/22x22/actions/search.png";
    }

    @Override
    public void close() {
        this.listener.stop();
    }

    public AmxBeaconListenerPanel() {
        this.listener.start();
        this.initComponents();
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.tree = new JTree();
        DefaultMutableTreeNode treeNode1 = new DefaultMutableTreeNode("Nodes");
        this.tree.setModel(new DefaultTreeModel(treeNode1));
        this.scrollPane.setViewportView(this.tree);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, GroupLayout.Alignment.TRAILING, -1, 400, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 225, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, GroupLayout.Alignment.TRAILING, -1, 225, Short.MAX_VALUE)));
    }

    private class Callbacker
    implements AmxBeaconListener.Callback {
        Callbacker() {
        }

        @Override
        public void func(HashMap<InetAddress, AmxBeaconListener.Node> hm) {
            DefaultMutableTreeNode root = new DefaultMutableTreeNode("Nodes");
            for (AmxBeaconListener.Node n : hm.values()) {
                DefaultMutableTreeNode node = this.doNode(n);
                root.add(node);
            }
            DefaultTreeModel treeModel = new DefaultTreeModel(root);
            AmxBeaconListenerPanel.this.tree.setModel(treeModel);
        }

        private DefaultMutableTreeNode doNode(AmxBeaconListener.Node node) {
            DefaultMutableTreeNode n = new DefaultMutableTreeNode(node.getInetAddress().getHostName());
            for (Map.Entry<String, String> kvp : node.getTable().entrySet()) {
                DefaultMutableTreeNode leaf = new DefaultMutableTreeNode(kvp.getKey() + ": " + kvp.getValue());
                n.add(leaf);
            }
            return n;
        }
    }
}

