/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.guicomponents;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.LineUnavailableException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.harctoolbox.IrpMaster.IncompatibleArgumentException;
import org.harctoolbox.IrpMaster.ModulatedIrSequence;
import org.harctoolbox.IrpMaster.Wave;
import org.harctoolbox.harchardware.ir.IrAudioDevice;

public class AudioParametersBean
extends JPanel {
    private static final AudioFormat.Encoding encoding = AudioFormat.Encoding.PCM_SIGNED;
    private static final boolean bigEndian = false;
    private static final boolean divideCarrier = true;
    private static final boolean square = true;
    private boolean verbose = false;
    private int sampleSize = 8;
    private JComboBox<String> channelsComboBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JCheckBox omitTrailingGapCheckBox;
    private JComboBox<String> sampleFrequencyComboBox;
    private JComboBox<String> sampleSizeComboBox;

    public AudioParametersBean() {
        this.initComponents();
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public boolean getBigEndian() {
        return false;
    }

    public boolean getDivideCarrier() {
        return true;
    }

    public boolean getSquare() {
        return true;
    }

    public int getChannels() {
        return Integer.parseInt((String)this.channelsComboBox.getSelectedItem());
    }

    public int getSampleFrequency() {
        return Integer.parseInt((String)this.sampleFrequencyComboBox.getSelectedItem());
    }

    public boolean getOmitTrailingGap() {
        return this.omitTrailingGapCheckBox.isSelected();
    }

    public AudioFormat getAudioFormat() {
        return new AudioFormat(encoding, this.getSampleFrequency(), this.getSampleSize(), this.getChannels(), this.getSampleSize() / 8 * this.getChannels(), this.getSampleFrequency(), this.getBigEndian());
    }

    public Wave newWave(ModulatedIrSequence irSequence) throws IncompatibleArgumentException {
        return new Wave(irSequence, this.getAudioFormat(), this.getOmitTrailingGap(), this.getSquare(), this.getDivideCarrier());
    }

    public IrAudioDevice newIrAudioDevice() {
        return new IrAudioDevice(this.getSampleFrequency(), this.getChannels(), this.getOmitTrailingGap(), this.verbose);
    }

    public void export(File file, ModulatedIrSequence irSequence) throws IncompatibleArgumentException {
        this.newWave(irSequence).export(file);
    }

    public void play(ModulatedIrSequence irSequence) throws LineUnavailableException, IncompatibleArgumentException, IOException {
        this.newWave(irSequence).play();
    }

    private void initComponents() {
        this.sampleFrequencyComboBox = new JComboBox();
        this.channelsComboBox = new JComboBox();
        this.omitTrailingGapCheckBox = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.sampleSizeComboBox = new JComboBox();
        this.jLabel3 = new JLabel();
        this.sampleFrequencyComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"44100", "48000", "96000", "192000"}));
        this.sampleFrequencyComboBox.setSelectedIndex(1);
        this.sampleFrequencyComboBox.setToolTipText("Sample frequency of the generated signal.");
        this.channelsComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2"}));
        this.channelsComboBox.setToolTipText("Number of channnels in generated signal. Normal is one channel. If two, the second channel is just exactly the opposite of the first.");
        this.omitTrailingGapCheckBox.setMnemonic('O');
        this.omitTrailingGapCheckBox.setText("Omit trailing gap");
        this.omitTrailingGapCheckBox.setToolTipText("If true, the last silence is left out of the generated wave signal.");
        this.jLabel1.setText("Sample freq.");
        this.jLabel2.setText("# Channels");
        this.sampleSizeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"8", "16"}));
        this.sampleSizeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AudioParametersBean.this.sampleSizeComboBoxActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Bits");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sampleFrequencyComboBox, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.channelsComboBox, 0, -1, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(9, 9, 9).addComponent(this.sampleSizeComboBox, -2, -1, -2).addGap(18, 18, 18).addComponent(this.omitTrailingGapCheckBox)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sampleFrequencyComboBox, -2, -1, -2).addComponent(this.channelsComboBox, -2, -1, -2).addComponent(this.omitTrailingGapCheckBox).addComponent(this.sampleSizeComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void sampleSizeComboBoxActionPerformed(ActionEvent evt) {
        this.sampleSize = Integer.parseInt((String)this.sampleSizeComboBox.getSelectedItem());
    }
}

