/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.guicomponents;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import org.harctoolbox.guicomponents.SelectFile;

public class Console
extends JScrollPane {
    private IErrorFunction errorFunction;
    private final JMenuItem consoleClearMenuItem;
    private final JMenuItem consoleCopyMenuItem;
    private final JMenuItem consoleCopySelectionMenuItem;
    private final JMenuItem consolePrintMenuItem;
    private final JPopupMenu consolePopupMenu;
    private final JMenuItem consoleSaveMenuItem;
    private final JTextArea consoleTextArea;
    private transient PrintStream consolePrintStream;

    public void setErrorFunction(IErrorFunction errorFunction) {
        this.errorFunction = errorFunction;
    }

    public void clear() {
        this.consoleTextArea.setText(null);
    }

    public void save(File file) throws FileNotFoundException {
        try (PrintStream ps = new PrintStream((OutputStream)new FileOutputStream(file), true, "US-ASCII");){
            ps.println(this.consoleTextArea.getText());
        }
        catch (UnsupportedEncodingException ex) {
            throw new InternalError();
        }
    }

    public String getText() {
        return this.consoleTextArea.getText();
    }

    public String getSelectedText() {
        return this.consoleTextArea.getSelectedText();
    }

    public void copySelectionToClipboard() {
        new CopyClipboardText().toClipboard(this.getSelectedText());
    }

    public void copyToClipboard() {
        new CopyClipboardText().toClipboard(this.getText());
    }

    public void setStdOut() {
        System.setOut(this.consolePrintStream);
    }

    public void setStdErr() {
        System.setErr(this.consolePrintStream);
    }

    public void println(String str) {
        this.consolePrintStream.println(str);
    }

    private void consoleClearMenuItemActionPerformed(ActionEvent evt) {
        this.clear();
    }

    private void consoleTextAreaMousePressed(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.consolePopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void consoleTextAreaMouseReleased(MouseEvent evt) {
        this.consoleTextAreaMousePressed(evt);
    }

    private void consoleCopyMenuItemActionPerformed(ActionEvent evt) {
        this.copyToClipboard();
    }

    private void consoleCopySelectionMenuItemActionPerformed(ActionEvent evt) {
        this.copySelectionToClipboard();
    }

    private void consoletextSaveMenuItemActionPerformed(ActionEvent evt) {
        try {
            File file = SelectFile.selectFile((Component)this, "Save console text as...", null, true, false, "Text file", "txt");
            if (file != null) {
                this.save(file);
            }
        }
        catch (FileNotFoundException ex) {
            this.errorFunction.err(ex, "File not found");
        }
    }

    private void consoletextPrintMenuItemActionPerformed(ActionEvent evt) {
        File file;
        try {
            file = File.createTempFile("console", ".txt");
        }
        catch (IOException ex) {
            this.errorFunction.err(ex, "");
            return;
        }
        try (PrintStream pos = new PrintStream((OutputStream)new FileOutputStream(file), true, "US-ASCII");){
            pos.println(this.getText());
        }
        catch (IOException ex) {
            this.errorFunction.err(ex, "");
            return;
        }
        try {
            Desktop.getDesktop().print(file);
            file.deleteOnExit();
        }
        catch (UnsupportedOperationException ex) {
            this.errorFunction.err("Desktop does not support printing. Print the file " + file.getAbsolutePath() + " manually.");
        }
        catch (IOException ex) {
            this.errorFunction.err(ex, "");
        }
    }

    public Console() {
        block2: {
            this.errorFunction = null;
            this.consolePrintStream = null;
            this.errorFunction = new SimpleErrorFunction(this.consolePrintStream);
            this.consolePopupMenu = new JPopupMenu();
            this.consoleClearMenuItem = new JMenuItem();
            JPopupMenu.Separator jSeparator5 = new JPopupMenu.Separator();
            this.consoleCopySelectionMenuItem = new JMenuItem();
            this.consoleCopyMenuItem = new JMenuItem();
            JPopupMenu.Separator jSeparator8 = new JPopupMenu.Separator();
            this.consolePrintMenuItem = new JMenuItem();
            JPopupMenu.Separator jSeparator9 = new JPopupMenu.Separator();
            this.consoleSaveMenuItem = new JMenuItem();
            this.consoleClearMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
            this.consoleClearMenuItem.setIcon(new ImageIcon(Console.class.getResource("/icons/Crystal-Clear/22x22/actions/eraser.png")));
            this.consoleClearMenuItem.setText("Clear");
            this.consoleClearMenuItem.setToolTipText("Discard the content of the console window.");
            this.consoleClearMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Console.this.consoleClearMenuItemActionPerformed(evt);
                }
            });
            this.consolePopupMenu.add(this.consoleClearMenuItem);
            this.consolePopupMenu.add(jSeparator5);
            this.consoleCopySelectionMenuItem.setIcon(new ImageIcon(Console.class.getResource("/icons/Crystal-Clear/22x22/actions/editcopy.png")));
            this.consoleCopySelectionMenuItem.setText("Copy selection");
            this.consoleCopySelectionMenuItem.setToolTipText("Copy currently selected text to the clipboard.");
            this.consoleCopySelectionMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Console.this.consoleCopySelectionMenuItemActionPerformed(evt);
                }
            });
            this.consolePopupMenu.add(this.consoleCopySelectionMenuItem);
            this.consoleCopyMenuItem.setText("Copy all");
            this.consoleCopyMenuItem.setToolTipText("Copy the content of the console to the clipboard.");
            this.consoleCopyMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Console.this.consoleCopyMenuItemActionPerformed(evt);
                }
            });
            this.consolePopupMenu.add(this.consoleCopyMenuItem);
            this.consolePopupMenu.add(jSeparator8);
            this.consoleSaveMenuItem.setIcon(new ImageIcon(Console.class.getResource("/icons/Crystal-Clear/22x22/actions/filesaveas.png")));
            this.consoleSaveMenuItem.setText("Save...");
            this.consoleSaveMenuItem.setToolTipText("Save the content of the console to a text file.");
            this.consoleSaveMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Console.this.consoletextSaveMenuItemActionPerformed(evt);
                }
            });
            this.consolePopupMenu.add(this.consoleSaveMenuItem);
            this.consolePopupMenu.add(jSeparator9);
            this.consolePrintMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/icons/Crystal-Clear/22x22/apps/printer.png")));
            this.consolePrintMenuItem.setText("Print...");
            this.consolePrintMenuItem.setToolTipText("Print the content of the console to a printer.");
            this.consolePrintMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    Console.this.consoletextPrintMenuItemActionPerformed(evt);
                }
            });
            this.consolePopupMenu.add(this.consolePrintMenuItem);
            this.consoleTextArea = new JTextArea();
            this.consoleTextArea.setEditable(false);
            this.consoleTextArea.setColumns(20);
            this.consoleTextArea.setLineWrap(true);
            this.consoleTextArea.setRows(5);
            this.consoleTextArea.setToolTipText("This is the console, where errors and messages go. Press right mouse button for menu.");
            this.consoleTextArea.setWrapStyleWord(true);
            this.consoleTextArea.setCursor(new Cursor(0));
            this.consoleTextArea.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    Console.this.consoleTextAreaMousePressed(evt);
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    Console.this.consoleTextAreaMouseReleased(evt);
                }
            });
            super.setViewportView(this.consoleTextArea);
            try {
                this.consolePrintStream = new PrintStream((OutputStream)new FilteredStream(new ByteArrayOutputStream()), false, "US-ASCII");
            }
            catch (UnsupportedEncodingException ex) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    private static class CopyClipboardText
    implements ClipboardOwner {
        private CopyClipboardText() {
        }

        @Override
        public void lostOwnership(Clipboard c, Transferable t) {
        }

        public void toClipboard(String str) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(str), this);
        }
    }

    private class FilteredStream
    extends FilterOutputStream {
        FilteredStream(OutputStream aStream) {
            super(aStream);
        }

        @Override
        public void write(byte[] b) throws IOException {
            String aString = new String(b, "US-ASCII");
            Console.this.consoleTextArea.append(aString);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            String aString = new String(b, off, len, "US-ASCII");
            Console.this.consoleTextArea.append(aString);
            Console.this.consoleTextArea.setCaretPosition(Console.this.consoleTextArea.getDocument().getLength());
        }
    }

    private static class SimpleErrorFunction
    implements IErrorFunction {
        PrintStream consolePrintStream;

        SimpleErrorFunction(PrintStream consolePrintStream) {
            this.consolePrintStream = consolePrintStream;
        }

        @Override
        public void err(Exception ex, String message) {
            this.err(ex.getMessage() + ". " + message);
        }

        @Override
        public void err(String str) {
            this.consolePrintStream.println(str);
        }
    }

    public static interface IErrorFunction
    extends Serializable {
        public void err(Exception var1, String var2);

        public void err(String var1);
    }
}

