/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.guicomponents;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.harctoolbox.guicomponents.GuiUtils;

public class CopyClipboardText
implements ClipboardOwner {
    private GuiUtils guiUtils = null;

    public static String getSelection() {
        return new CopyClipboardText(null).fromSystemSelection();
    }

    public CopyClipboardText(GuiUtils guiUtils) {
        this.guiUtils = guiUtils;
    }

    @Override
    public void lostOwnership(Clipboard c, Transferable t) {
    }

    public void toClipboard(String str) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(str), this);
    }

    public String fromClipboard() {
        try {
            return (String)Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this).getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException | IOException ex) {
            if (this.guiUtils != null) {
                this.guiUtils.error(ex);
            } else {
                System.err.println(ex);
            }
            return null;
        }
    }

    public String fromSystemSelection() {
        Clipboard selection = Toolkit.getDefaultToolkit().getSystemSelection();
        if (selection == null) {
            return null;
        }
        try {
            return (String)selection.getContents(this).getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException | IOException ex) {
            if (this.guiUtils != null) {
                this.guiUtils.error(ex);
            } else {
                System.err.println(ex);
            }
            return null;
        }
    }
}

