/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.guicomponents;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import org.harctoolbox.guicomponents.GuiUtils;
import org.harctoolbox.guicomponents.ISendingReceivingBean;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.ir.DevLirc;
import org.harctoolbox.harchardware.ir.LircTransmitter;

public class DevLircBean
extends JPanel
implements ISendingReceivingBean {
    private static final String notInitialized = "not initialized";
    private String portName;
    private String propsString;
    private GuiUtils guiUtils;
    private transient DevLirc hardware;
    private boolean listenable;
    private boolean enableSending;
    private final transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private JLabel jLabel1;
    private JToggleButton openToggleButton;
    private JComboBox<String> portComboBox;
    private JLabel propsLabel;
    private JButton refreshButton;
    private JComboBox<String> transmitterComboBox;
    private JLabel transmitterLabel;
    private JLabel versionLiteralLabel;

    public DevLircBean() {
        this(null, null, true);
    }

    public DevLircBean(GuiUtils guiUtils) {
        this(guiUtils, null, true);
    }

    public DevLircBean(GuiUtils guiUtils, String initialPort, boolean enableSending) {
        DefaultComboBoxModel<String> model;
        this.initComponents();
        this.enableSending = enableSending;
        this.guiUtils = guiUtils;
        this.listenable = false;
        try {
            model = new DefaultComboBoxModel<String>(DevLircBean.candidates());
        }
        catch (IOException | LinkageError ex) {
            model = new DefaultComboBoxModel<String>(new String[]{initialPort != null ? initialPort : notInitialized});
        }
        this.portComboBox.setModel(model);
        boolean hit = false;
        if (initialPort != null) {
            for (int i = 0; i < model.getSize(); ++i) {
                if (!initialPort.equalsIgnoreCase(model.getElementAt(i))) continue;
                hit = true;
                this.portComboBox.setSelectedIndex(i);
                break;
            }
        }
        String actualPort = initialPort;
        if (!hit && model.getSize() > 0) {
            this.portComboBox.setSelectedIndex(0);
            actualPort = this.portComboBox.getItemAt(0);
        }
        this.setPortName(actualPort);
    }

    private static String[] candidates() throws IOException {
        File[] candidatesFile = DevLirc.getCandidates();
        String[] candidates = new String[candidatesFile.length];
        for (int i = 0; i < candidatesFile.length; ++i) {
            candidates[i] = candidatesFile[i].getCanonicalPath();
        }
        return candidates;
    }

    private void conditionallyEnableOpen() {
        this.openToggleButton.setEnabled(this.hardware != null && this.portComboBox.getSelectedItem() != null);
    }

    public String getPortName() {
        return this.portName;
    }

    public final void setPortName(String portName) {
        if (portName == null || portName.isEmpty()) {
            return;
        }
        this.conditionallyEnableOpen();
        String oldPort = this.portName;
        this.portName = portName;
        this.propertyChangeSupport.firePropertyChange("PROP_PORTNAME", oldPort, portName);
    }

    public void setHardware(DevLirc hardware) {
        this.hardware = hardware;
        this.conditionallyEnableOpen();
        this.openToggleButton.setSelected(hardware.isValid());
    }

    public LircTransmitter getTransmitter() {
        return this.hardware.canSetTransmitter() ? new LircTransmitter((String)this.transmitterComboBox.getSelectedItem()) : new LircTransmitter();
    }

    private void setProps(String version) {
        String oldVersion = this.propsString;
        this.propsString = version;
        this.propsLabel.setEnabled(this.hardware.isValid());
        this.versionLiteralLabel.setEnabled(this.hardware.isValid());
        this.propsLabel.setText(version);
        this.propertyChangeSupport.firePropertyChange("PROP_PROPS", oldVersion, version);
    }

    private void setProps() {
        this.setProps(this.hardware.isValid() ? this.hardware.toString() : "<not connected>");
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport == null) {
            super.addPropertyChangeListener(listener);
        } else {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void setup(String desiredPort) throws IOException {
        ComboBoxModel<String> model = this.portComboBox.getModel();
        if (model == null || model.getSize() == 0 || model.getSize() == 1 && ((String)this.portComboBox.getSelectedItem()).equals(notInitialized)) {
            this.setupPortComboBox();
        }
        this.portComboBox.setSelectedItem(desiredPort != null ? desiredPort : this.portName);
    }

    private void setupPortComboBox() throws IOException {
        if (this.hardware != null) {
            this.hardware.close();
        }
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(DevLircBean.candidates());
        this.portComboBox.setModel(model);
    }

    public boolean isListenable() {
        return this.listenable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openClose(boolean opening) throws IOException, HarcHardwareException {
        boolean oldIsOpen = this.hardware.isValid();
        try {
            if (opening) {
                this.hardware.open();
                this.listenable = true;
                if (this.hardware.canSetTransmitter()) {
                    String[] stringArray;
                    if (this.hardware.getNumberTransmitters() > 1) {
                        stringArray = this.hardware.getTransmitterNames();
                    } else {
                        String[] stringArray2 = new String[9];
                        stringArray2[0] = "default";
                        stringArray2[1] = "1";
                        stringArray2[2] = "2";
                        stringArray2[3] = "3";
                        stringArray2[4] = "4";
                        stringArray2[5] = "5";
                        stringArray2[6] = "6";
                        stringArray2[7] = "7";
                        stringArray = stringArray2;
                        stringArray2[8] = "8";
                    }
                    DefaultComboBoxModel<String> transmitterComboBoxModel = new DefaultComboBoxModel<String>(stringArray);
                    this.transmitterComboBox.setModel(transmitterComboBoxModel);
                }
            } else {
                this.listenable = false;
                this.hardware.close();
            }
            this.enableStuff(opening && this.hardware.isValid());
            this.setProps();
            this.propertyChangeSupport.firePropertyChange("PROP_ISOPEN", oldIsOpen, this.hardware.isValid());
        }
        catch (Throwable throwable) {
            this.enableStuff(opening && this.hardware.isValid());
            this.setProps();
            this.propertyChangeSupport.firePropertyChange("PROP_ISOPEN", oldIsOpen, this.hardware.isValid());
            throw throwable;
        }
    }

    private void enableStuff(boolean isOpen) {
        this.portComboBox.setEnabled(!isOpen);
        boolean enableTransmitters = this.enableSending && isOpen && this.hardware.canSetTransmitter();
        this.transmitterLabel.setEnabled(enableTransmitters);
        this.transmitterComboBox.setEnabled(enableTransmitters);
    }

    private Cursor setBusyCursor() {
        Cursor oldCursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        return oldCursor;
    }

    private void resetCursor(Cursor cursor) {
        this.setCursor(cursor);
    }

    private void initComponents() {
        this.portComboBox = new JComboBox();
        this.refreshButton = new JButton();
        this.jLabel1 = new JLabel();
        this.openToggleButton = new JToggleButton();
        this.versionLiteralLabel = new JLabel();
        this.propsLabel = new JLabel();
        this.transmitterComboBox = new JComboBox();
        this.transmitterLabel = new JLabel();
        this.setPreferredSize(new Dimension(800, 80));
        this.portComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{notInitialized}));
        this.portComboBox.setToolTipText("Device name to use");
        this.portComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DevLircBean.this.portComboBoxActionPerformed(evt);
            }
        });
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Crystal-Clear/22x22/actions/reload.png")));
        this.refreshButton.setText("Refresh");
        this.refreshButton.setToolTipText("Reload list of available /dev/lirc devices");
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DevLircBean.this.refreshButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Device");
        this.openToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Crystal-Clear/22x22/actions/connect_creating.png")));
        this.openToggleButton.setText("Open");
        this.openToggleButton.setToolTipText("Open or close connection to device.");
        this.openToggleButton.setEnabled(false);
        this.openToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DevLircBean.this.openToggleButtonActionPerformed(evt);
            }
        });
        this.versionLiteralLabel.setText("Detected properties");
        this.versionLiteralLabel.setToolTipText("Version of the firmware on the device, if supported by the device. Verifies that the connection is working.");
        this.versionLiteralLabel.setEnabled(false);
        this.propsLabel.setHorizontalAlignment(2);
        this.propsLabel.setText("--");
        this.propsLabel.setToolTipText("Properties of the device, as reported from it.");
        this.propsLabel.setBorder(new SoftBevelBorder(1));
        this.propsLabel.setEnabled(false);
        this.propsLabel.setHorizontalTextPosition(4);
        this.transmitterComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"default", "1", "2", "3", "4"}));
        this.transmitterComboBox.setToolTipText("The transmitter to use to send the command");
        this.transmitterComboBox.setEnabled(false);
        this.transmitterLabel.setText("xmitter");
        this.transmitterLabel.setEnabled(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.refreshButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.portComboBox, 0, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 107, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.transmitterLabel, -2, 66, -2).addGroup(layout.createSequentialGroup().addComponent(this.transmitterComboBox, -2, 72, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.openToggleButton))).addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.propsLabel, -2, 356, -2).addComponent(this.versionLiteralLabel)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.transmitterLabel, -2, 24, -2).addComponent(this.versionLiteralLabel)).addGap(4, 4, 4).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.openToggleButton).addComponent(this.propsLabel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.transmitterComboBox, -2, -1, -2).addComponent(this.portComboBox, -2, -1, -2).addComponent(this.refreshButton))).addContainerGap(-1, Short.MAX_VALUE)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshButtonActionPerformed(ActionEvent evt) {
        Cursor oldCursor = this.setBusyCursor();
        try {
            this.setupPortComboBox();
            this.conditionallyEnableOpen();
        }
        catch (IOException ex) {
            this.guiUtils.error(ex);
        }
        finally {
            this.resetCursor(oldCursor);
        }
    }

    private void portComboBoxActionPerformed(ActionEvent evt) {
        this.setPortName((String)this.portComboBox.getSelectedItem());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openToggleButtonActionPerformed(ActionEvent evt) {
        Cursor oldCursor = this.setBusyCursor();
        boolean opening = this.openToggleButton.isSelected();
        try {
            this.openClose(opening);
        }
        catch (IOException | HarcHardwareException ex) {
            this.guiUtils.error(ex);
        }
        finally {
            this.openToggleButton.setSelected(this.hardware.isValid());
            this.resetCursor(oldCursor);
        }
    }
}

