/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.guicomponents;

import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.UnsupportedCommOperationException;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.guicomponents.GuiUtils;
import org.harctoolbox.guicomponents.ISendingReceivingBean;
import org.harctoolbox.harchardware.HarcHardwareException;
import org.harctoolbox.harchardware.comm.LocalSerialPort;
import org.harctoolbox.harchardware.comm.LocalSerialPortBuffered;
import org.harctoolbox.harchardware.comm.TcpSocketPort;
import org.harctoolbox.harchardware.ir.GirsClient;
import org.harctoolbox.irscrutinizer.Props;

public class GirsClientBean
extends JPanel
implements ISendingReceivingBean {
    public static final String PROP_IPNAME = "PROP_IPNAME";
    public static final String PROP_TYPE = "PROP_TYPE";
    private static final int defaultPingTimeout = 5000;
    private static final int defaultBaudRate = 115200;
    private static final int defaultPortNumber = 33333;
    private static final int defaultSerialTimeout = 12000;
    private static final Type defaultType = Type.serial;
    private static final String defaultPortName = "/dev/arduino";
    private static final String defaultHost = "localhost";
    private static final String notInitialized = "not initialized";
    private static final String notConnected = "not connected";
    private String portName;
    private int baudRate;
    private GuiUtils guiUtils;
    private transient GirsClient<?> hardware;
    private int portNumber;
    private String ipName;
    private int pingTimeout;
    private Type type;
    private final Props properties;
    private final transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private JComboBox<String> baudComboBox;
    private JLabel baudRateLabel;
    private JButton browseButton;
    private JPanel ethernetPanel;
    private JLabel ipLabel;
    private JTextField ipNameTextField;
    private JLabel modulesLabel;
    private JTextField modulesTextField;
    private JToggleButton openToggleButton;
    private JButton pingButton;
    private JComboBox<String> portComboBox;
    private JLabel portNumberLabel;
    private JTextField portNumberTextField;
    private JButton refreshButton;
    private JPanel serialPanel;
    private JLabel serialPortLabel;
    private JTabbedPane serialTcpTabbedPane;
    private JComboBox<String> typeComboBox;
    private JLabel typeLabel;
    private JCheckBox useReceiveForCaptureCheckBox;
    private JLabel versionLabel;
    private JTextField versionTextField;

    public void initHardware() throws HarcHardwareException, IOException {
        if (this.hardware != null) {
            if (this.hardware.isValid()) {
                return;
            }
            this.hardware.close();
            this.enableStuff(false);
            this.setVersion();
        }
        boolean verbose = this.properties.getVerbose();
        switch (this.getType()) {
            case serial: {
                try {
                    LocalSerialPortBuffered comm = new LocalSerialPortBuffered(this.getPortName(), this.getBaudRate(), 12000, verbose);
                    this.hardware = new GirsClient<LocalSerialPortBuffered>(comm);
                }
                catch (NoSuchPortException | PortInUseException | UnsupportedCommOperationException | IOException | HarcHardwareException ex) {
                    this.guiUtils.error(ex);
                }
                break;
            }
            case tcp: {
                try {
                    TcpSocketPort comm = new TcpSocketPort(this.ipName, this.portNumber, 12000, verbose, TcpSocketPort.ConnectionMode.keepAlive);
                    this.hardware = new GirsClient<TcpSocketPort>(comm);
                }
                catch (IOException | HarcHardwareException ex) {
                    this.guiUtils.error(ex);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Type " + (Object)((Object)this.getType()) + " not yet supported");
            }
        }
    }

    public GirsClientBean() {
        this(null, null);
    }

    public GirsClientBean(GuiUtils guiUtils, Props properties) {
        DefaultComboBoxModel<String> model;
        this.guiUtils = guiUtils;
        this.properties = properties;
        this.pingTimeout = 5000;
        this.initComponents();
        String initialPort = properties != null ? properties.getGirsClientSerialPortName() : defaultPortName;
        try {
            ArrayList<String> portList = LocalSerialPort.getSerialPortNames(true);
            model = new DefaultComboBoxModel<String>(portList.toArray(new String[portList.size()]));
        }
        catch (IOException | LinkageError ex) {
            model = new DefaultComboBoxModel<String>(new String[]{initialPort != null ? initialPort : notInitialized});
        }
        this.portComboBox.setModel(model);
        boolean hit = false;
        if (initialPort != null) {
            for (int i = 0; i < model.getSize(); ++i) {
                if (!initialPort.equalsIgnoreCase(model.getElementAt(i))) continue;
                hit = true;
                this.portComboBox.setSelectedIndex(i);
                break;
            }
        }
        String actualPort = initialPort;
        if (!hit && model.getSize() > 0) {
            this.portComboBox.setSelectedIndex(0);
            actualPort = this.portComboBox.getItemAt(0);
        }
        this.setPortName(actualPort);
        this.setBaudRate(properties != null ? properties.getGirsClientSerialPortBaudRate() : 115200);
        this.setIpName(properties != null ? properties.getGirsClientIPName() : defaultHost);
        this.setPortNumber(properties != null ? properties.getGirsClientPortNumber() : 33333);
        this.setType(properties != null ? Type.valueOf(properties.getGirsClientType()) : defaultType);
        if (properties != null) {
            properties.addVerboseChangeListener(new Props.IPropertyChangeListener(){

                @Override
                public void propertyChange(String name, Object oldValue, Object newValue) {
                    if (GirsClientBean.this.hardware != null) {
                        GirsClientBean.this.hardware.setVerbosity((Boolean)newValue);
                    }
                }
            });
        }
    }

    private void setType(Type type) {
        Type oldType = this.type;
        this.type = type;
        this.propertyChangeSupport.firePropertyChange(PROP_TYPE, (Object)oldType, (Object)type);
        if (this.properties != null) {
            this.properties.setGirsClientType(type.toString());
        }
    }

    public Type getType() {
        return this.type;
    }

    public String getPortName() {
        return this.portName;
    }

    private void setPortName(String portName) {
        if (portName == null || portName.isEmpty()) {
            return;
        }
        String oldPort = this.portName;
        this.portName = portName;
        this.propertyChangeSupport.firePropertyChange("PROP_PORTNAME", oldPort, portName);
        if (this.properties != null) {
            this.properties.setGirsClientSerialPortName(portName);
        }
    }

    public int getBaudRate() {
        return this.baudRate;
    }

    private void setBaudRate(int baudRate) {
        int oldBaud = this.baudRate;
        this.baudRate = baudRate;
        this.baudComboBox.setSelectedItem(Integer.toString(baudRate));
        this.propertyChangeSupport.firePropertyChange("PROP_BAUD", oldBaud, baudRate);
        if (this.properties != null) {
            this.properties.setGirsClientSerialPortBaudRate(baudRate);
        }
    }

    public String getVersion() {
        return this.isValid() ? this.versionTextField.getText() : null;
    }

    private void setVersion(String version) {
        this.versionLabel.setEnabled(this.hardware.isValid());
        this.versionTextField.setEnabled(this.hardware.isValid());
        this.versionTextField.setText(version);
    }

    private void setVersion() {
        try {
            this.setVersion(this.hardware.isValid() ? this.hardware.getVersion() : notConnected);
            this.setModules(this.hardware.isValid() ? this.hardware.getModules() : null);
        }
        catch (IOException ex) {
            this.setVersion(notConnected);
            this.setModules(null);
        }
    }

    private void setModules(List<String> modules) {
        this.modulesTextField.setText(modules == null ? "" : IrpUtils.join(modules, " "));
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport == null) {
            super.addPropertyChangeListener(listener);
        } else {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    private void setupPortComboBox(boolean useCached) throws IOException {
        if (this.hardware != null) {
            this.hardware.close();
        }
        ArrayList<String> portNames = LocalSerialPort.getSerialPortNames(useCached);
        portNames.add(0, "");
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(portNames.toArray(new String[portNames.size()]));
        this.portComboBox.setModel(model);
    }

    private void setIpName(String name) {
        this.ipNameTextField.setText(name);
        String old = this.ipName;
        this.ipName = name;
        this.propertyChangeSupport.firePropertyChange(PROP_IPNAME, old, name);
        if (this.properties != null) {
            this.properties.setGirsClientIPName(name);
        }
    }

    private void setPortNumber(int val) {
        this.portNumberTextField.setText(Integer.toString(val));
        int old = this.portNumber;
        this.portNumber = val;
        this.propertyChangeSupport.firePropertyChange("PROP_PORTNAME", old, val);
        if (this.properties != null) {
            this.properties.setGirsClientPortNumber(val);
        }
    }

    public void setPingTimeout(int val) {
        this.pingTimeout = val;
    }

    public GirsClient<?> getHardware() {
        return this.hardware;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPingable(boolean useGui) {
        Cursor oldCursor = this.setBusyCursor();
        boolean success = false;
        try {
            success = InetAddress.getByName(this.ipName).isReachable(this.pingTimeout);
            if (useGui) {
                this.guiUtils.info(this.ipName + (success ? " is reachable" : " is not reachable (using Java's isReachable)"));
            }
        }
        catch (IOException ex) {
            if (useGui) {
                this.guiUtils.info(this.ipName + " is not reachable (using Java's isReachable): " + ex.getMessage());
            }
        }
        finally {
            this.resetCursor(oldCursor);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openClose(boolean opening) throws IOException, HarcHardwareException {
        Cursor oldCursor = this.setBusyCursor();
        boolean oldIsOpen = this.hardware.isValid();
        try {
            if (opening) {
                this.initHardware();
                this.hardware.open();
                this.hardware.setUseReceiveForCapture(this.useReceiveForCaptureCheckBox.isSelected());
            } else {
                this.hardware.close();
            }
            this.propertyChangeSupport.firePropertyChange("PROP_ISOPEN", oldIsOpen, this.hardware.isValid());
            this.resetCursor(oldCursor);
            this.enableStuff(opening && this.hardware.isValid());
            this.setVersion();
        }
        catch (Throwable throwable) {
            this.resetCursor(oldCursor);
            this.enableStuff(opening && this.hardware.isValid());
            this.setVersion();
            throw throwable;
        }
    }

    private void enableStuff(boolean isOpen) {
        this.serialTcpTabbedPane.setEnabled(!isOpen);
        this.refreshButton.setEnabled(!isOpen);
        this.baudComboBox.setEnabled(!isOpen);
        this.baudRateLabel.setEnabled(!isOpen);
        this.portComboBox.setEnabled(!isOpen);
        this.serialPortLabel.setEnabled(!isOpen);
        this.ipNameTextField.setEnabled(!isOpen);
        this.ipLabel.setEnabled(!isOpen);
        this.portNumberTextField.setEnabled(!isOpen);
        this.portNumberLabel.setEnabled(!isOpen);
        this.typeLabel.setEnabled(!isOpen);
        this.modulesTextField.setEnabled(isOpen);
        this.modulesLabel.setEnabled(isOpen);
        this.openToggleButton.setSelected(isOpen);
    }

    private Cursor setBusyCursor() {
        Cursor oldCursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        return oldCursor;
    }

    private void resetCursor(Cursor cursor) {
        this.setCursor(cursor);
    }

    private void initComponents() {
        this.serialTcpTabbedPane = new JTabbedPane();
        this.serialPanel = new JPanel();
        this.refreshButton = new JButton();
        this.portComboBox = new JComboBox();
        this.baudComboBox = new JComboBox();
        this.serialPortLabel = new JLabel();
        this.baudRateLabel = new JLabel();
        this.ethernetPanel = new JPanel();
        this.ipLabel = new JLabel();
        this.ipNameTextField = new JTextField();
        this.portNumberLabel = new JLabel();
        this.portNumberTextField = new JTextField();
        this.browseButton = new JButton();
        this.pingButton = new JButton();
        this.typeComboBox = new JComboBox();
        this.typeLabel = new JLabel();
        this.openToggleButton = new JToggleButton();
        this.versionLabel = new JLabel();
        this.versionTextField = new JTextField();
        this.modulesTextField = new JTextField();
        this.modulesLabel = new JLabel();
        this.useReceiveForCaptureCheckBox = new JCheckBox();
        this.setPreferredSize(new Dimension(800, 120));
        this.serialPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                GirsClientBean.this.serialPanelComponentShown(evt);
            }
        });
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Crystal-Clear/22x22/actions/reload.png")));
        this.refreshButton.setText("Refresh");
        this.refreshButton.setToolTipText("Reload list of available serial ports.");
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GirsClientBean.this.refreshButtonActionPerformed(evt);
            }
        });
        this.portComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{notInitialized}));
        this.portComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GirsClientBean.this.portComboBoxActionPerformed(evt);
            }
        });
        this.baudComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"115200", "57600", "38400", "19200", "9600", "4800", "2400", "1200"}));
        this.baudComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GirsClientBean.this.baudComboBoxActionPerformed(evt);
            }
        });
        this.serialPortLabel.setText("Serial Port");
        this.baudRateLabel.setText("bits/s");
        GroupLayout serialPanelLayout = new GroupLayout(this.serialPanel);
        this.serialPanel.setLayout(serialPanelLayout);
        serialPanelLayout.setHorizontalGroup(serialPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(serialPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.refreshButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(serialPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.portComboBox, -2, 200, -2).addComponent(this.serialPortLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(serialPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.baudRateLabel).addComponent(this.baudComboBox, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        serialPanelLayout.setVerticalGroup(serialPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, serialPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(serialPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.serialPortLabel).addComponent(this.baudRateLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(serialPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.refreshButton).addComponent(this.portComboBox, -2, -1, -2).addComponent(this.baudComboBox, -2, -1, -2)).addContainerGap()));
        this.serialTcpTabbedPane.addTab("Serial", this.serialPanel);
        this.ethernetPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                GirsClientBean.this.ethernetPanelComponentShown(evt);
            }
        });
        this.ipLabel.setText("IP Name/Address");
        this.ipNameTextField.setText("192.168.1.29");
        this.ipNameTextField.setToolTipText("IP-Name or -address of host");
        this.ipNameTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GirsClientBean.this.ipNameTextFieldActionPerformed(evt);
            }
        });
        this.portNumberLabel.setText("Port");
        this.portNumberTextField.setText("33333");
        this.portNumberTextField.setToolTipText("Port Number");
        this.portNumberTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GirsClientBean.this.portNumberTextFieldActionPerformed(evt);
            }
        });
        this.browseButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Crystal-Clear/22x22/apps/browser.png")));
        this.browseButton.setMnemonic('B');
        this.browseButton.setText("Browse");
        this.browseButton.setToolTipText("Browse WWW server at host");
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GirsClientBean.this.browseButtonActionPerformed(evt);
            }
        });
        this.pingButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Crystal-Clear/22x22/apps/bell.png")));
        this.pingButton.setMnemonic('P');
        this.pingButton.setText("Ping");
        this.pingButton.setToolTipText("Try to ping host");
        this.pingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GirsClientBean.this.pingButtonActionPerformed(evt);
            }
        });
        this.typeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"tcp", "udp", "http"}));
        this.typeComboBox.setToolTipText("Socket type");
        this.typeComboBox.setEnabled(false);
        this.typeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GirsClientBean.this.typeComboBoxActionPerformed(evt);
            }
        });
        this.typeLabel.setText("Type");
        GroupLayout ethernetPanelLayout = new GroupLayout(this.ethernetPanel);
        this.ethernetPanel.setLayout(ethernetPanelLayout);
        ethernetPanelLayout.setHorizontalGroup(ethernetPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ethernetPanelLayout.createSequentialGroup().addContainerGap().addGroup(ethernetPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ipLabel).addComponent(this.ipNameTextField, -2, 158, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(ethernetPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.portNumberTextField, -2, 56, -2).addComponent(this.portNumberLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(ethernetPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ethernetPanelLayout.createSequentialGroup().addComponent(this.typeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pingButton)).addComponent(this.typeLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        ethernetPanelLayout.setVerticalGroup(ethernetPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, ethernetPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(ethernetPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ipLabel).addComponent(this.portNumberLabel).addComponent(this.typeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(ethernetPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ipNameTextField, -2, -1, -2).addComponent(this.portNumberTextField, -2, -1, -2).addComponent(this.typeComboBox, -2, -1, -2).addComponent(this.browseButton).addComponent(this.pingButton)).addContainerGap()));
        this.serialTcpTabbedPane.addTab("Ethernet", this.ethernetPanel);
        this.openToggleButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Crystal-Clear/22x22/actions/connect_creating.png")));
        this.openToggleButton.setText("Open");
        this.openToggleButton.setToolTipText("Open or close connection to device.");
        this.openToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GirsClientBean.this.openToggleButtonActionPerformed(evt);
            }
        });
        this.versionLabel.setText("Version");
        this.versionLabel.setEnabled(false);
        this.versionTextField.setEditable(false);
        this.versionTextField.setEnabled(false);
        this.modulesTextField.setEditable(false);
        this.modulesTextField.setEnabled(false);
        this.modulesLabel.setText("Modules:");
        this.modulesLabel.setEnabled(false);
        this.useReceiveForCaptureCheckBox.setText("Use receive for capture");
        this.useReceiveForCaptureCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GirsClientBean.this.useReceiveForCaptureCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.serialTcpTabbedPane, -2, 535, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.versionLabel, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.versionTextField)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.openToggleButton, -2, 108, -2).addComponent(this.useReceiveForCaptureCheckBox)).addGap(0, 54, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addComponent(this.modulesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.modulesTextField))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.openToggleButton).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.versionTextField, -2, -1, -2).addComponent(this.versionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.useReceiveForCaptureCheckBox)).addComponent(this.serialTcpTabbedPane, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.modulesTextField, -2, -1, -2).addComponent(this.modulesLabel)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshButtonActionPerformed(ActionEvent evt) {
        Cursor oldCursor = this.setBusyCursor();
        try {
            this.setupPortComboBox(false);
        }
        catch (IOException ex) {
            this.guiUtils.error(ex);
        }
        finally {
            this.resetCursor(oldCursor);
        }
    }

    private void portComboBoxActionPerformed(ActionEvent evt) {
        this.setPortName((String)this.portComboBox.getSelectedItem());
    }

    private void baudComboBoxActionPerformed(ActionEvent evt) {
        this.setBaudRate(Integer.parseInt((String)this.baudComboBox.getSelectedItem()));
    }

    private void ipNameTextFieldActionPerformed(ActionEvent evt) {
        this.setIpName(this.ipNameTextField.getText());
    }

    private void portNumberTextFieldActionPerformed(ActionEvent evt) {
        try {
            int val = Integer.parseInt(this.portNumberTextField.getText());
            this.setPortNumber(val);
        }
        catch (NumberFormatException ex) {
            this.guiUtils.error("Cannot parse " + this.portNumberTextField.getText());
        }
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        try {
            Desktop.getDesktop().browse(URI.create("http://" + this.ipName));
        }
        catch (IOException ex) {
            this.guiUtils.error(ex);
        }
    }

    private void pingButtonActionPerformed(ActionEvent evt) {
        this.setIpName(this.ipNameTextField.getText());
        this.isPingable(true);
    }

    private void typeComboBoxActionPerformed(ActionEvent evt) {
        this.setType(Type.valueOf((String)this.typeComboBox.getSelectedItem()));
    }

    private void openToggleButtonActionPerformed(ActionEvent evt) {
        try {
            this.openClose(this.openToggleButton.isSelected());
        }
        catch (IOException | HarcHardwareException ex) {
            this.guiUtils.error(ex);
        }
        finally {
            this.openToggleButton.setSelected(this.hardware.isValid());
        }
    }

    private void serialPanelComponentShown(ComponentEvent evt) {
        this.setType(Type.serial);
    }

    private void ethernetPanelComponentShown(ComponentEvent evt) {
        this.setType(Type.valueOf((String)this.typeComboBox.getSelectedItem()));
    }

    private void useReceiveForCaptureCheckBoxActionPerformed(ActionEvent evt) {
        if (this.hardware.isValid()) {
            this.hardware.setUseReceiveForCapture(this.useReceiveForCaptureCheckBox.isSelected());
        }
    }

    public static enum Type {
        serial,
        tcp,
        upd,
        http;

    }
}

