/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.guicomponents;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.harctoolbox.guicomponents.GlobalCacheManager;
import org.harctoolbox.guicomponents.GuiUtils;
import org.harctoolbox.harchardware.ir.GlobalCache;
import org.harctoolbox.harchardware.ir.NoSuchTransmitterException;

public class GlobalCacheIrSenderSelector
extends JPanel {
    private GuiUtils guiUtils;
    private transient GlobalCache globalCache = null;
    private boolean verbose;
    private int timeout;
    private InetAddress inetAddress;
    private int module;
    private int port;
    private boolean senderSupport;
    private final transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    public static final String PROP_GLOBALCACHE = "PROP_GLOBALCACHE";
    public static final String PROP_IPNAME = "PROP_IPNAME";
    public static final String PROP_MODULE = "PROP_MODULE";
    public static final String PROP_PORT = "PROP_PORT";
    private static final int defaultTimeout = 5000;
    private JButton addButton;
    private JButton globalCacheBrowseButton;
    private JComboBox<String> globalCacheIpComboBox;
    private JLabel globalCacheVersionLabel;
    private JLabel jLabel1;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JComboBox<String> moduleComboBox;
    private JLabel moduleLabel;
    private JComboBox<String> portComboBox;
    private JLabel portLabel;
    private JButton stopButton;
    private JLabel typeLabel;

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    private void setGlobalCache(InetAddress globalCacheInetAddress) throws UnknownHostException, IOException {
        String[] modules;
        if (globalCacheInetAddress == null) {
            return;
        }
        if (this.globalCache != null && this.globalCache.isValid() && globalCacheInetAddress.equals(InetAddress.getByName(this.globalCache.getIp()))) {
            return;
        }
        String oldIpName = this.getIpName();
        this.closeGlobalCache();
        this.globalCache = null;
        this.typeLabel.setText("<unknown>");
        this.moduleComboBox.setEnabled(false);
        this.portComboBox.setEnabled(false);
        this.globalCache = new GlobalCache(globalCacheInetAddress.getHostName(), this.verbose, this.timeout);
        if (!this.globalCache.isValid()) {
            throw new IOException("Set up of GlobalCache@" + globalCacheInetAddress.getHostName() + " failed.");
        }
        this.inetAddress = globalCacheInetAddress;
        GlobalCacheManager.getInstance().addManualGlobalCache(this.inetAddress);
        this.setup();
        int index = GlobalCacheManager.getInstance().getIndex(globalCacheInetAddress);
        String type = GlobalCacheManager.getInstance().getType(index);
        this.typeLabel.setText(type);
        this.globalCacheBrowseButton.setEnabled(true);
        ArrayList<Integer> irModules = this.globalCache.getIrModules();
        this.port = 1;
        if (irModules.isEmpty()) {
            modules = new String[]{"-"};
        } else {
            modules = new String[irModules.size()];
            for (int i = 0; i < irModules.size(); ++i) {
                modules[i] = Integer.toString(irModules.get(i));
            }
            this.setModule(irModules.get(0));
        }
        this.moduleComboBox.setModel(new DefaultComboBoxModel<String>(modules));
        this.moduleComboBox.setEnabled(true);
        this.portComboBox.setEnabled(true);
        this.globalCacheVersionLabel.setText(this.globalCache.getVersion());
        this.globalCacheIpComboBox.setSelectedIndex(index);
        this.globalCacheIpComboBox.repaint();
        this.propertyChangeSupport.firePropertyChange(PROP_IPNAME, oldIpName, this.getIpName());
    }

    private void setGlobalCache(int index) throws UnknownHostException, IOException {
        this.setGlobalCache(GlobalCacheManager.getInstance().getInetAddress(index));
    }

    private void closeGlobalCache() throws IOException {
        if (this.globalCache != null) {
            this.globalCache.close();
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyChangeSupport != null) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public String getIpName() {
        return this.inetAddress != null ? this.inetAddress.getHostName() : null;
    }

    public final void setIpName(String ipName) throws UnknownHostException, IOException {
        if (ipName == null || ipName.isEmpty() || ipName.equals(this.getIpName())) {
            return;
        }
        this.inetAddress = InetAddress.getByName(ipName);
        this.setGlobalCache(this.inetAddress);
    }

    private void setup() {
        DefaultComboBoxModel<String> cbm = new DefaultComboBoxModel<String>(GlobalCacheManager.getInstance().getAllNames());
        this.globalCacheIpComboBox.setModel(cbm);
        int index = GlobalCacheManager.getInstance().getIndex(this.inetAddress);
        this.globalCacheIpComboBox.setSelectedIndex(index);
        this.globalCacheIpComboBox.repaint();
    }

    public int getModule() {
        return this.module;
    }

    public void setModule(int module) {
        if (this.senderSupport) {
            int oldModule = this.module;
            this.module = module;
            this.propertyChangeSupport.firePropertyChange(PROP_MODULE, oldModule, module);
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        if (this.senderSupport) {
            int oldPort = this.port;
            this.port = port;
            this.propertyChangeSupport.firePropertyChange(PROP_PORT, oldPort, port);
        }
    }

    public GlobalCache.GlobalCacheIrTransmitter getTransmitter() throws NoSuchTransmitterException {
        return this.globalCache.newTransmitter(this.module, this.port);
    }

    public GlobalCacheIrSenderSelector(GuiUtils guiUtils, boolean verbose, int timeout, boolean senderSupport) {
        this.guiUtils = guiUtils;
        this.verbose = verbose;
        this.timeout = timeout;
        this.senderSupport = senderSupport;
        this.initComponents();
        this.moduleLabel.setVisible(senderSupport);
        this.moduleComboBox.setVisible(senderSupport);
        this.portLabel.setVisible(senderSupport);
        this.portComboBox.setVisible(senderSupport);
        this.stopButton.setVisible(senderSupport);
        this.setup();
        GlobalCacheManager.getInstance().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                GlobalCacheIrSenderSelector.this.setup();
            }
        });
    }

    public GlobalCacheIrSenderSelector() {
        this(null, false, 5000, true);
        this.port = 1;
        this.globalCache = null;
    }

    public void setGuiUtils(GuiUtils guiUtils) {
        this.guiUtils = guiUtils;
    }

    public boolean isStopEnabled() {
        return this.stopButton.isEnabled();
    }

    public void setStopEnabled(boolean value) {
        this.stopButton.setEnabled(value);
    }

    public GlobalCache getGlobalCache() {
        return this.globalCache;
    }

    private void initComponents() {
        this.globalCacheIpComboBox = new JComboBox();
        this.moduleComboBox = new JComboBox();
        this.portComboBox = new JComboBox();
        this.stopButton = new JButton();
        this.globalCacheBrowseButton = new JButton();
        this.jLabel1 = new JLabel();
        this.moduleLabel = new JLabel();
        this.portLabel = new JLabel();
        this.jLabel4 = new JLabel();
        this.typeLabel = new JLabel();
        this.addButton = new JButton();
        this.jLabel5 = new JLabel();
        this.globalCacheVersionLabel = new JLabel();
        this.globalCacheIpComboBox.setToolTipText("Used to select between several Global Cach\u00e9 units.");
        this.globalCacheIpComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GlobalCacheIrSenderSelector.this.globalCacheIpComboBoxActionPerformed(evt);
            }
        });
        this.moduleComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3", "4", "5"}));
        this.moduleComboBox.setMinimumSize(new Dimension(60, 24));
        this.moduleComboBox.setPreferredSize(new Dimension(60, 24));
        this.moduleComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GlobalCacheIrSenderSelector.this.moduleComboBoxActionPerformed(evt);
            }
        });
        this.portComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "2", "3"}));
        this.portComboBox.setMinimumSize(new Dimension(60, 24));
        this.portComboBox.setPreferredSize(new Dimension(60, 24));
        this.portComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GlobalCacheIrSenderSelector.this.portComboBoxActionPerformed(evt);
            }
        });
        this.stopButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Crystal-Clear/22x22/actions/stop.png")));
        this.stopButton.setText("Stop IR");
        this.stopButton.setToolTipText("Stop presently not implemented.");
        this.stopButton.setEnabled(false);
        this.globalCacheBrowseButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Crystal-Clear/22x22/apps/browser.png")));
        this.globalCacheBrowseButton.setText("Browse");
        this.globalCacheBrowseButton.setToolTipText("Visit the GlobalCache with browser");
        this.globalCacheBrowseButton.setEnabled(false);
        this.globalCacheBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GlobalCacheIrSenderSelector.this.globalCacheBrowseButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("IP Name/Address");
        this.moduleLabel.setText("Module");
        this.portLabel.setText("Port");
        this.jLabel4.setText("Reported Global Cach\u00e9 type:");
        this.typeLabel.setText("<unknown>");
        this.addButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Crystal-Clear/22x22/actions/edit_add.png")));
        this.addButton.setText("Add...");
        this.addButton.setToolTipText("The IP-Address or -name of Global Cach\u00e9 units not supporting the beacon can be entered here.");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GlobalCacheIrSenderSelector.this.addButtonActionPerformed(evt);
            }
        });
        this.jLabel5.setText("Firmware version:");
        this.globalCacheVersionLabel.setText("<unknown>");
        this.globalCacheVersionLabel.setToolTipText("Firmware version as reported by the device.");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.globalCacheIpComboBox, -2, 180, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.moduleLabel).addComponent(this.moduleComboBox, -2, 60, -2)).addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.portComboBox, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stopButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.globalCacheBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.addButton)).addComponent(this.portLabel))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.typeLabel, -2, 146, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.globalCacheVersionLabel))).addGap(9, 9, 9)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(13, 13, 13).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.moduleLabel).addComponent(this.portLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.globalCacheIpComboBox, -2, -1, -2).addComponent(this.moduleComboBox, -2, -1, -2).addComponent(this.portComboBox, -2, -1, -2).addComponent(this.stopButton).addComponent(this.globalCacheBrowseButton).addComponent(this.addButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.typeLabel).addComponent(this.jLabel5).addComponent(this.globalCacheVersionLabel)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void globalCacheBrowseButtonActionPerformed(ActionEvent evt) {
        if (this.globalCache != null) {
            this.guiUtils.browse(this.globalCache.getUri(null, null));
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        String ip = this.guiUtils.getInput("Enter GlobalCache IP-Name or -address", "GlobalCache entry", "192.168.1.70");
        try {
            if (ip != null) {
                GlobalCacheManager.getInstance().addManualGlobalCache(InetAddress.getByName(ip));
                this.setGlobalCache(InetAddress.getByName(ip));
            }
        }
        catch (UnknownHostException ex) {
            this.guiUtils.error(ex);
        }
        catch (IOException ex) {
            this.guiUtils.error(ex);
        }
    }

    private void globalCacheIpComboBoxActionPerformed(ActionEvent evt) {
        try {
            this.setGlobalCache(this.globalCacheIpComboBox.getSelectedIndex());
        }
        catch (UnknownHostException ex) {
            this.guiUtils.error(ex);
        }
        catch (IOException ex) {
            this.guiUtils.error(ex);
        }
    }

    private void moduleComboBoxActionPerformed(ActionEvent evt) {
        this.setModule(Integer.parseInt((String)this.moduleComboBox.getSelectedItem()));
    }

    private void portComboBoxActionPerformed(ActionEvent evt) {
        this.setPort(Integer.parseInt((String)this.portComboBox.getSelectedItem()));
    }
}

