/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.guicomponents;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.harctoolbox.harchardware.beacon.AmxBeaconListener;
import org.harctoolbox.harchardware.ir.GlobalCache;

public final class GlobalCacheManager {
    private static final GlobalCacheManager instance = new GlobalCacheManager();
    public static final String PROP_GCMANAGER_NAME = "globalcacheManager";
    private boolean debug = false;
    private AmxBeaconListener beaconListener = null;
    private ArrayList<InetAddress> automaticGlobalCaches = new ArrayList(4);
    private ArrayList<String> automaticGlobalCacheTypes = new ArrayList(4);
    private final ArrayList<InetAddress> manualGlobalCaches = new ArrayList(4);
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public static GlobalCacheManager getInstance() {
        return instance;
    }

    private GlobalCacheManager() {
        Callbacker callback = new Callbacker();
        this.beaconListener = GlobalCache.newListener(callback, this.debug);
    }

    private int sillyHashCode() {
        return this.automaticGlobalCaches.hashCode() + 1000 * this.manualGlobalCaches.hashCode();
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
        if (this.beaconListener != null) {
            this.beaconListener.setDebug(debug);
        }
    }

    public String getType(int index) {
        if (index < this.manualGlobalCaches.size()) {
            return "manually entered";
        }
        return this.automaticGlobalCacheTypes.get(index - this.manualGlobalCaches.size());
    }

    public InetAddress getInetAddress(int index) {
        if (index < 0) {
            return null;
        }
        if (index < this.manualGlobalCaches.size()) {
            return this.manualGlobalCaches.get(index);
        }
        return this.automaticGlobalCaches.get(index - this.manualGlobalCaches.size());
    }

    public int getIndex(InetAddress inetAddress) {
        int index;
        for (index = 0; index < this.manualGlobalCaches.size(); ++index) {
            if (!this.manualGlobalCaches.get(index).equals(inetAddress)) continue;
            return index;
        }
        for (index = 0; index < this.automaticGlobalCaches.size(); ++index) {
            if (!this.automaticGlobalCaches.get(index).equals(inetAddress)) continue;
            return index + this.manualGlobalCaches.size();
        }
        return -1;
    }

    public boolean addManualGlobalCache(String ipName) throws IOException {
        return this.addManualGlobalCache(InetAddress.getByName(ipName));
    }

    public boolean addManualGlobalCache(InetAddress inetAddress) {
        if (inetAddress == null || this.manualGlobalCaches.contains(inetAddress) || this.automaticGlobalCaches.contains(inetAddress)) {
            return false;
        }
        int oldValue = this.sillyHashCode();
        this.manualGlobalCaches.add(inetAddress);
        this.propertyChangeSupport.firePropertyChange(PROP_GCMANAGER_NAME, oldValue, this.sillyHashCode());
        return true;
    }

    public boolean removeManualGlobalCache(InetAddress inetAddress) {
        int oldValue = this.sillyHashCode();
        if (!this.manualGlobalCaches.contains(inetAddress)) {
            return false;
        }
        this.manualGlobalCaches.remove(inetAddress);
        this.propertyChangeSupport.firePropertyChange(PROP_GCMANAGER_NAME, oldValue, this.sillyHashCode());
        return true;
    }

    public InetAddress[] getManual() {
        return this.manualGlobalCaches.toArray(new InetAddress[this.manualGlobalCaches.size()]);
    }

    public InetAddress[] getAutomatic() {
        return this.automaticGlobalCaches.toArray(new InetAddress[this.automaticGlobalCaches.size()]);
    }

    public String[] getAllNames() {
        String[] result = new String[this.manualGlobalCaches.size() + this.automaticGlobalCaches.size()];
        for (int i = 0; i < this.manualGlobalCaches.size(); ++i) {
            result[i] = this.manualGlobalCaches.get(i).getHostName();
        }
        System.arraycopy(this.getAutomaticPrettyNames(), 0, result, this.manualGlobalCaches.size(), this.automaticGlobalCaches.size());
        return result;
    }

    public String[] getAutomaticPrettyNames() {
        String[] result = new String[this.automaticGlobalCaches.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.automaticGlobalCacheTypes.get(i) + " (" + this.automaticGlobalCaches.get(i).getHostName() + ")";
        }
        return result;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    private class Callbacker
    implements AmxBeaconListener.Callback {
        Callbacker() {
        }

        @Override
        public void func(HashMap<InetAddress, AmxBeaconListener.Node> nodes) {
            int oldValue = GlobalCacheManager.this.sillyHashCode();
            GlobalCacheManager.this.automaticGlobalCaches = new ArrayList(4);
            GlobalCacheManager.this.automaticGlobalCacheTypes = new ArrayList(4);
            for (Map.Entry<InetAddress, AmxBeaconListener.Node> node : nodes.entrySet()) {
                GlobalCacheManager.this.automaticGlobalCaches.add(node.getKey());
                GlobalCacheManager.this.automaticGlobalCacheTypes.add(node.getValue().get("-Model"));
                GlobalCacheManager.this.removeManualGlobalCache(node.getKey());
            }
            int newValue = GlobalCacheManager.this.sillyHashCode();
            GlobalCacheManager.this.propertyChangeSupport.firePropertyChange(GlobalCacheManager.PROP_GCMANAGER_NAME, oldValue, newValue);
        }
    }
}

