/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.guicomponents;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.MenuElement;
import org.harctoolbox.guicomponents.GlobalCacheManager;
import org.harctoolbox.guicomponents.GuiUtils;

public class GlobalCacheManagerMenu
implements Serializable {
    public static final String PROP_GC_ADDR = "PROP_GC_ADDR";
    private final JMenu globalCacheMenu;
    private JRadioButton[] globalCacheRadioButtons = new JRadioButton[0];
    private ButtonGroup buttonGroup = null;
    private final GuiUtils guiUtils;
    private InetAddress globalCacheInetAddress;
    private final boolean verbose;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public GlobalCacheManagerMenu(JMenu globalCacheMenu, GuiUtils guiUtils, ButtonGroup buttonGroup, String initialSelection, boolean verbose) {
        this.guiUtils = guiUtils;
        this.globalCacheInetAddress = null;
        this.verbose = verbose;
        this.globalCacheMenu = globalCacheMenu;
        this.buttonGroup = buttonGroup;
        this.setup();
        GlobalCacheManager.getInstance().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                GlobalCacheManagerMenu.this.setup();
            }
        });
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    protected void setGlobalCache(InetAddress inetAddress) {
        if (this.verbose) {
            this.guiUtils.info("Selected GlobalCache @ " + inetAddress.getHostName());
        }
        GlobalCacheManager.getInstance().addManualGlobalCache(inetAddress);
        InetAddress oldName = this.globalCacheInetAddress;
        this.globalCacheInetAddress = inetAddress;
        this.propertyChangeSupport.firePropertyChange(PROP_GC_ADDR, oldName, inetAddress);
    }

    protected void addGlobalCache(int position, String prettyName, final InetAddress inetAddress, String tooltip) {
        JRadioButton menuItem = new JRadioButton(prettyName);
        menuItem.setToolTipText(tooltip);
        this.globalCacheRadioButtons[position] = menuItem;
        this.buttonGroup.add(menuItem);
        this.globalCacheMenu.add(menuItem);
        menuItem.setSelected(inetAddress.equals(this.globalCacheInetAddress));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GlobalCacheManagerMenu.this.setGlobalCache(inetAddress);
            }
        });
    }

    protected final void setup() {
        for (MenuElement menuElement : this.globalCacheMenu.getSubElements()) {
            if (!AbstractButton.class.isInstance(menuElement)) continue;
            this.buttonGroup.remove((AbstractButton)((Object)menuElement));
        }
        this.globalCacheMenu.removeAll();
        this.globalCacheRadioButtons = new JRadioButton[GlobalCacheManager.getInstance().getAutomatic().length + GlobalCacheManager.getInstance().getManual().length];
        InetAddress[] automaticGlobalCaches = GlobalCacheManager.getInstance().getAutomatic();
        InetAddress[] manualGlobalCaches = GlobalCacheManager.getInstance().getManual();
        int index = 0;
        for (InetAddress ipName : manualGlobalCaches) {
            this.addGlobalCache(index++, ipName.getHostName(), ipName, "Manually entered GlobalCache.");
        }
        if (automaticGlobalCaches.length > 0 && manualGlobalCaches.length > 0) {
            this.globalCacheMenu.add(new JPopupMenu.Separator());
        }
        String[] stringArray = GlobalCacheManager.getInstance().getAutomaticPrettyNames();
        for (int i = 0; i < automaticGlobalCaches.length; ++i) {
            this.addGlobalCache(index++, stringArray[i], automaticGlobalCaches[i], "Automatically discovered GlobalCache.");
        }
        this.globalCacheMenu.add(new JPopupMenu.Separator());
        JMenuItem manualAddMenuItem = new JMenuItem("Add manually...");
        manualAddMenuItem.setMnemonic('A');
        this.globalCacheMenu.add(manualAddMenuItem);
        manualAddMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    String ip = GlobalCacheManagerMenu.this.guiUtils.getInput("Enter GlobalCache IP-Name or -address", "GlobalCache entry", "192.168.1.70");
                    if (ip != null) {
                        GlobalCacheManager.getInstance().addManualGlobalCache(InetAddress.getByName(ip));
                    }
                }
                catch (UnknownHostException ex) {
                    GlobalCacheManagerMenu.this.guiUtils.error(ex);
                }
            }
        });
        this.globalCacheMenu.repaint();
        this.globalCacheMenu.getParent().repaint();
    }
}

