/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.guicomponents;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.harctoolbox.IrpMaster.IrpUtils;
import org.harctoolbox.guicomponents.HelpPopup;

public class GuiUtils
implements Serializable {
    private final int maxGuiMessageLength;
    private boolean usePopupsForErrors = false;
    private boolean usePopupsForHelp = false;
    private boolean offerStackTrace = false;
    private final String programName;
    private final JFrame frame;
    private boolean verbose = false;

    public GuiUtils(JFrame frame, String programName, int maxGuiMessageLength) {
        this.maxGuiMessageLength = maxGuiMessageLength;
        this.programName = programName;
        this.frame = frame;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setOfferStackTrace(boolean offerStackTrace) {
        this.offerStackTrace = offerStackTrace;
    }

    public void setUsePopupsForErrors(boolean usePopupsForErrors) {
        this.usePopupsForErrors = usePopupsForErrors;
    }

    public void setUsePopupsForHelp(boolean usePopupsForHelp) {
        this.usePopupsForHelp = usePopupsForHelp;
    }

    private String truncate(String message) {
        return message == null || message.length() <= this.maxGuiMessageLength ? message : message.substring(0, this.maxGuiMessageLength - 3) + "...";
    }

    public void info(String message) {
        if (this.usePopupsForErrors) {
            JOptionPane.showMessageDialog(this.frame, this.truncate(message), this.programName + " information", 1, new ImageIcon(GuiUtils.class.getResource("/icons/Crystal-Clear/48x48/actions/info.png")));
        } else {
            System.err.println(message);
        }
    }

    public static void fatal(Exception ex, int errorcode) {
        GuiUtils.fatal(ex, errorcode, null);
    }

    public static void fatal(Exception ex, int errorcode, EmergencyFixer fixer) {
        String message = ex.getClass().getSimpleName() + ": " + ex.getMessage();
        if (System.console() != null) {
            System.err.println(message);
        }
        JOptionPane.showMessageDialog(null, message, "Fatal error", 0);
        if (fixer != null) {
            String finalMessage;
            boolean answer = GuiUtils.confirm(null, fixer.getQuestion());
            if (answer) {
                fixer.fix();
            }
            String string = finalMessage = answer ? fixer.getYesMessage() : fixer.getNoMessage();
            if (finalMessage != null) {
                JOptionPane.showMessageDialog(null, finalMessage, null, 1, new ImageIcon(GuiUtils.class.getResource("/icons/Crystal-Clear/48x48/actions/info.png")));
            }
        }
        ex.printStackTrace();
        System.exit(errorcode);
    }

    public void trace(String message) {
        System.err.println(message);
    }

    public void message(String message) {
        System.err.println(message);
    }

    public void warning(String message) {
        if (this.usePopupsForErrors) {
            JOptionPane.showMessageDialog(this.frame, this.truncate(message), this.programName + " warning", 2, new ImageIcon(GuiUtils.class.getResource("/icons/Crystal-Clear/48x48/apps/error.png")));
        } else {
            System.err.println("Warning: " + message);
        }
    }

    public void error(String message) {
        this.error(message, false);
    }

    private boolean error(String message, boolean offerStackTrace) {
        int ans = 0;
        if (this.usePopupsForErrors) {
            if (offerStackTrace) {
                Object[] options = new Object[]{"OK", "Print stack trace"};
                ans = JOptionPane.showOptionDialog(this.frame, this.truncate(message), this.programName + " error", 0, 0, new ImageIcon(GuiUtils.class.getResource("/icons/Crystal-Clear/48x48/apps/error.png")), options, options[0]);
            } else {
                JOptionPane.showMessageDialog(this.frame, this.truncate(message), this.programName + " error", 0, new ImageIcon(GuiUtils.class.getResource("/icons/Crystal-Clear/48x48/apps/error.png")));
            }
        } else {
            System.err.println("Error: " + message);
            ans = offerStackTrace ? 1 : 0;
        }
        return ans > 0;
    }

    public void error(Throwable ex) {
        this.error(ex, ex.getMessage());
    }

    public void error(Throwable ex, String message) {
        String errorMessage = ex instanceof ParseException ? ex.getClass().getSimpleName() + " on line " + ((ParseException)ex).getErrorOffset() + ": " + message : ex.getClass().getSimpleName() + ": " + message;
        boolean result = this.error(errorMessage, this.offerStackTrace);
        if (result) {
            ex.printStackTrace(System.err);
        }
    }

    public String getInput(String message, String title, String defaultAnswer) {
        return (String)JOptionPane.showInputDialog(this.frame, message, title, 3, null, null, defaultAnswer);
    }

    public Integer getIntegerInput(String message, int oldValue) {
        String s = this.getInput(message, "Parameter input", Integer.toString(oldValue));
        return s != null ? Integer.valueOf(Integer.parseInt(s)) : null;
    }

    public Long getLongInput(String message, long oldValue) {
        String s = this.getInput(message, "Parameter input", Long.toString(oldValue));
        return s == null ? null : Long.valueOf(s.trim().isEmpty() ? -1L : IrpUtils.parseLong(s, false));
    }

    public Double getDoubleInput(String message, double oldValue) {
        String s = this.getInput(message, "Parameter input", Double.toString(oldValue));
        return s != null ? Double.valueOf(Double.parseDouble(s)) : null;
    }

    public boolean confirm(String message) {
        return GuiUtils.confirm(this.frame, message);
    }

    private static boolean confirm(JFrame frame, String message) {
        return JOptionPane.showConfirmDialog(frame, message, "Confirmation requested", 2) == 0;
    }

    public void mail(String address, String subject, String body) throws URISyntaxException, IOException {
        URI uri = new URI("mailto:" + address + "?subject=" + subject + "&body=" + body);
        Desktop.getDesktop().mail(uri);
    }

    public void browse(File file) throws MalformedURLException, URISyntaxException {
        this.browse(file.toURI());
    }

    public void browse(URI uri) {
        block5: {
            if (!Desktop.isDesktopSupported()) {
                this.error("Desktop not supported");
                return;
            }
            if (uri == null || uri.toString().isEmpty()) {
                this.error("No URI.");
                return;
            }
            try {
                if (this.verbose) {
                    this.trace("Browsing URI \"" + uri.toString() + "\"");
                }
                Desktop.getDesktop().browse(uri);
            }
            catch (IOException ex) {
                boolean stacktrace = this.error("Could not start browser using uri \"" + uri.toString() + "\".", this.offerStackTrace);
                if (!stacktrace) break block5;
                ex.printStackTrace(System.err);
            }
        }
    }

    public void open(File file) {
        if (!Desktop.isDesktopSupported()) {
            this.error("Desktop not supported");
            return;
        }
        if (!file.canRead()) {
            this.error("Cannot read file " + file.toString());
            return;
        }
        try {
            Desktop.getDesktop().open(file);
            if (this.verbose) {
                this.trace("open file \"" + file.toString() + "\"");
            }
        }
        catch (IllegalArgumentException ex) {
            this.error(ex);
        }
        catch (IOException ex) {
            this.error("File \"" + file.toString() + "\" has no associated application or the associated application failed.");
        }
    }

    public void edit(File file) {
        if (!Desktop.isDesktopSupported()) {
            this.error("Desktop not supported");
            return;
        }
        if (Desktop.getDesktop().isSupported(Desktop.Action.EDIT)) {
            try {
                Desktop.getDesktop().edit(file);
                if (this.verbose) {
                    this.trace("edit file \"" + file.toString() + "\"");
                }
            }
            catch (IOException ex) {
                if (this.verbose) {
                    this.trace("edit file \"" + file.toString() + "\" failed, trying open...");
                }
                this.open(file);
            }
            catch (UnsupportedOperationException ex) {
                this.error("Edit not supported.");
            }
        } else {
            this.open(file);
        }
    }

    public void editOrOpen(File file) {
        if (!Desktop.isDesktopSupported()) {
            this.error("Desktop not supported");
            return;
        }
        if (Desktop.getDesktop().isSupported(Desktop.Action.EDIT)) {
            this.edit(file);
        } else {
            this.open(file);
        }
    }

    public void browseOrEdit(String urlOrFilename) {
        try {
            URL url = new URL(urlOrFilename);
            this.browse(url.toURI());
        }
        catch (MalformedURLException | URISyntaxException ex) {
            this.editOrOpen(new File(urlOrFilename));
        }
    }

    public void help(String helpText) {
        if (this.usePopupsForHelp) {
            HelpPopup.newHelpPopup(this.frame, helpText);
        } else {
            System.err.println(helpText);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkUpToDate(String currentVersionUrl, String versionString) {
        BufferedReader in = null;
        String current = null;
        try {
            URL url = new URL(currentVersionUrl);
            in = new BufferedReader(new InputStreamReader(url.openStream(), "US-ASCII"));
            String line = in.readLine();
            if (line == null || line.isEmpty()) {
                this.error("Problem getting current version");
                boolean bl = false;
                return bl;
            }
            current = line.trim();
            this.info(current.equals(versionString) ? "You are using the latest version of " + this.programName + ", " + versionString : "Current official version is " + current + ", your version is " + versionString + ".");
        }
        catch (IOException ex) {
            this.error("Problem getting current version: " + ex.getMessage());
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                this.error("Problem closing version check Url: " + ex.getMessage());
            }
        }
        return current != null && current.equals(versionString);
    }

    public static interface EmergencyFixer {
        public void fix();

        public String getQuestion();

        public String getYesMessage();

        public String getNoMessage();
    }
}

