/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.guicomponents;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.harctoolbox.guicomponents.HarcPanel;

public class HarcletFrame
extends JFrame {
    private final boolean exitOnClose;
    private JMenuItem aboutMenuItem;
    private JMenuItem closeMenuItem;
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JMenuItem helpMenuItem;
    private final HarcPanel harclet;
    private JMenuBar jMenuBar;

    public HarcletFrame(HarcPanel panel, boolean exitOnClose, String lafClassName) {
        try {
            if (lafClassName != null) {
                UIManager.setLookAndFeel(lafClassName);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
            // empty catch block
        }
        this.exitOnClose = exitOnClose;
        this.harclet = panel;
        this.initComponents();
        super.setTitle(this.harclet.getProgName());
        super.setIconImage(new ImageIcon(HarcletFrame.class.getResource(this.harclet.getIconPath())).getImage());
        super.setResizable(false);
        if (exitOnClose) {
            super.setDefaultCloseOperation(3);
        }
    }

    public static HarcletFrame newHarcletFrame(Component parent, HarcPanel panel, boolean exitOnClose, String lafClassName) {
        HarcletFrame harcletFrame = new HarcletFrame(panel, exitOnClose, lafClassName);
        harcletFrame.setLocationRelativeTo(parent);
        harcletFrame.setVisible(true);
        return harcletFrame;
    }

    private void initComponents() {
        this.jMenuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.closeMenuItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.aboutMenuItem = new JMenuItem();
        this.helpMenuItem = new JMenuItem();
        this.setDefaultCloseOperation(2);
        this.fileMenu.setText("File");
        this.closeMenuItem.setAccelerator(KeyStroke.getKeyStroke(27, 0));
        this.closeMenuItem.setText(this.exitOnClose ? "Exit" : "Close");
        this.closeMenuItem.setIcon(new ImageIcon(HarcletFrame.class.getResource("/icons/Crystal-Clear/22x22/actions/stop.png")));
        this.closeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HarcletFrame.this.closeMenuItemActionPerformed(evt);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                HarcletFrame.this.closeMenuItemActionPerformed(null);
            }
        });
        this.fileMenu.add(this.closeMenuItem);
        this.jMenuBar.add(this.fileMenu);
        this.helpMenu.setText("Help");
        this.aboutMenuItem.setMnemonic('A');
        this.aboutMenuItem.setText("About...");
        this.aboutMenuItem.setIcon(new ImageIcon(HarcletFrame.class.getResource("/icons/Crystal-Clear/22x22/actions/info.png")));
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HarcletFrame.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.helpMenuItem.setMnemonic('H');
        this.helpMenuItem.setText("Help...");
        this.helpMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.helpMenuItem.setIcon(new ImageIcon(HarcletFrame.class.getResource("/icons/Crystal-Clear/22x22/actions/help.png")));
        this.helpMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HarcletFrame.this.helpMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.helpMenuItem);
        this.jMenuBar.add(this.helpMenu);
        this.setJMenuBar(this.jMenuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.harclet, -2, -1, -2)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.harclet, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, this.harclet.getAboutMessage(), "About " + this.harclet.getProgName(), 1, new ImageIcon(HarcletFrame.class.getResource("/icons/Crystal-Clear/48x48/actions/info.png")));
    }

    private void helpMenuItemActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, this.harclet.getHelpMessage(), this.harclet.getProgName() + " help", 1, new ImageIcon(HarcletFrame.class.getResource("/icons/Crystal-Clear/48x48/actions/info.png")));
    }

    private void closeMenuItemActionPerformed(ActionEvent evt) {
        if (this.exitOnClose) {
            HarcletFrame.doExit(0);
        } else {
            try {
                this.harclet.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.dispose();
        }
    }

    private static void doExit(int exitcode) {
        System.exit(exitcode);
    }

    public static void main(String[] args) {
        String lafName = null;
        String className = "TimeFrequencyCalculator";
        HarcPanel panel = null;
        if (args.length == 1) {
            className = args[0];
        } else if (args.length == 2) {
            lafName = args[0];
            className = args[1];
        }
        final String laf = lafName;
        try {
            Class<?> clazz = Class.forName("org.harctoolbox.guicomponents." + className);
            Constructor<?> constructor = clazz.getConstructor(null);
            panel = (HarcPanel)constructor.newInstance(null);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.err.println(ex.getMessage());
        }
        final HarcPanel harcPanel = panel;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new HarcletFrame(harcPanel, true, laf).setVisible(true);
            }
        });
    }
}

