/*
 * Decompiled with CFR 0.152.
 */
package org.harctoolbox.guicomponents;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import org.harctoolbox.guicomponents.GuiUtils;

public class HelpButton
extends JButton {
    private GuiUtils guiUtils;
    private String helpText;

    public HelpButton(GuiUtils guiUtils, String helpText) {
        this();
        this.guiUtils = guiUtils;
        this.helpText = helpText;
    }

    public HelpButton() {
        super.setIcon(new ImageIcon(HelpButton.class.getResource("/icons/Crystal-Clear/22x22/actions/help.png")));
        super.setMnemonic('H');
        super.setText("Help");
        super.setToolTipText("Display help.");
        super.setCursor(new Cursor(12));
        super.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HelpButton.this.guiUtils.help(HelpButton.this.helpText);
            }
        });
    }

    public void setHelpText(String helpText) {
        this.helpText = helpText;
    }

    public void setGuiUtils(GuiUtils guiUtils) {
        this.guiUtils = guiUtils;
    }
}

